/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy.transports;

import java.util.Map;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.internal.MultitenantMsgContextDataHolder;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;

public class TenantTransportSender
extends AbstractHandler
implements TransportSender {
    private ConfigurationContext superTenantConfigurationContext;
    private AxisService superTenantSenderClientService;
    private AxisServiceGroup superTenantSenderServiceGroup;
    private static final Log log = LogFactory.getLog(TenantTransportSender.class);
    private static final String SERVICE_PREFIX = "SERVICE_PREFIX";
    private static final String REQUEST_HOST_HEADER = "REQUEST_HOST_HEADER";
    private static final String HTTP_ETAG = "HTTP_ETAG";
    private static final String NO_ENTITY_BODY = "NO_ENTITY_BODY";
    private static final String HTTP_SC_DESC = "HTTP_SC_DESC";
    private static final String EXCESS_TRANSPORT_HEADERS = "EXCESS_TRANSPORT_HEADERS";
    private static final String FORCE_SC_ACCEPTED = "FORCE_SC_ACCEPTED";
    private static final String FORCE_POST_PUT_NOBODY = "FORCE_POST_PUT_NOBODY";
    private static final String DELETE_REQUEST_WITH_PAYLOAD = "DELETE_REQUEST_WITH_PAYLOAD";
    private static final String TRANSPORT_MAIL_FORMAT = "transport.mail.Format";
    private MultitenantMsgContextDataHolder dataHolder = MultitenantMsgContextDataHolder.getInstance();

    public TenantTransportSender(ConfigurationContext superTenantConfigurationContext) {
        this.superTenantConfigurationContext = superTenantConfigurationContext;
        try {
            this.superTenantSenderClientService = superTenantConfigurationContext.getAxisConfiguration().getService("tenantClientService");
            if (this.superTenantSenderClientService != null) {
                this.superTenantSenderClientService.setEnableAllTransports(true);
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Can't find the tenantClientService service!", (Throwable)axisFault);
        }
        this.superTenantSenderServiceGroup = superTenantConfigurationContext.getAxisConfiguration().getServiceGroup("tenantClientService");
    }

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        Object decodeMultipartDataParam;
        MessageContext inMessageContext;
        boolean forcedNoBody;
        AxisOperation axisOperation;
        MessageContext superTenantOutMessageContext = this.superTenantConfigurationContext.createMessageContext();
        superTenantOutMessageContext.setProperty("TRANSPORT_OUT", msgContext.getProperty("TRANSPORT_OUT"));
        superTenantOutMessageContext.setProperty("OutTransportInfo", msgContext.getProperty("OutTransportInfo"));
        String incomingMEP = msgContext.getAxisOperation().getMessageExchangePattern();
        AxisOperation axisOperation2 = axisOperation = incomingMEP.equals("http://www.w3.org/ns/wsdl/out-only") ? this.superTenantSenderClientService.getOperation(MultitenantConstants.MULTITENANT_CLIENT_SERVICE_OUT_ONLY_OPERATION) : this.superTenantSenderClientService.getOperation(MultitenantConstants.MULTITENANT_CLIENT_SERVICE_IN_OUT_OPERATION);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Incoming message MEP " + incomingMEP + "Selected axisOperation MEP " + axisOperation.getMessageExchangePattern()));
        }
        superTenantOutMessageContext.setAxisService(this.superTenantSenderClientService);
        ServiceGroupContext serviceGroupContext = this.superTenantConfigurationContext.createServiceGroupContext(this.superTenantSenderServiceGroup);
        ServiceContext serviceContext = serviceGroupContext.getServiceContext(this.superTenantSenderClientService);
        superTenantOutMessageContext.setServiceContext(serviceContext);
        OperationContext operationContext = serviceContext.createOperationContext(axisOperation);
        operationContext.addMessageContext(superTenantOutMessageContext);
        superTenantOutMessageContext.setOperationContext(operationContext);
        String transportOutName = msgContext.getTransportOut().getName();
        superTenantOutMessageContext.setTransportOut(this.superTenantConfigurationContext.getAxisConfiguration().getTransportOut(transportOutName));
        superTenantOutMessageContext.setEnvelope(msgContext.getEnvelope());
        superTenantOutMessageContext.setProperty("org.apache.synapse.commons.json.JsonInputStream", msgContext.getProperty("org.apache.synapse.commons.json.JsonInputStream"));
        superTenantOutMessageContext.setTo(msgContext.getTo());
        superTenantOutMessageContext.setSoapAction(msgContext.getSoapAction());
        superTenantOutMessageContext.setDoingREST(msgContext.isDoingREST());
        superTenantOutMessageContext.setDoingMTOM(msgContext.isDoingMTOM());
        superTenantOutMessageContext.setProperty("TRANSPORT_HEADERS", msgContext.getProperty("TRANSPORT_HEADERS"));
        superTenantOutMessageContext.setProperty(EXCESS_TRANSPORT_HEADERS, msgContext.getProperty(EXCESS_TRANSPORT_HEADERS));
        superTenantOutMessageContext.setProperty("HTTP_SC", msgContext.getProperty("HTTP_SC"));
        superTenantOutMessageContext.setProperty(HTTP_SC_DESC, msgContext.getProperty(HTTP_SC_DESC));
        superTenantOutMessageContext.setProperty("HTTP_HEADERS", msgContext.getProperty("HTTP_HEADERS"));
        String msgTypeProperty = (String)msgContext.getProperty("messageType");
        superTenantOutMessageContext.setProperty("messageType", (Object)msgTypeProperty);
        String contentTypeProperty = (String)msgContext.getProperty("ContentType");
        superTenantOutMessageContext.setProperty("ContentType", (Object)contentTypeProperty);
        superTenantOutMessageContext.setDoingMTOM(msgContext.isDoingMTOM());
        superTenantOutMessageContext.setAttachmentMap(msgContext.getAttachmentMap());
        superTenantOutMessageContext.setProperty("CHARACTER_SET_ENCODING", msgContext.getProperty("CHARACTER_SET_ENCODING"));
        superTenantOutMessageContext.setProperty("enableMTOM", msgContext.getProperty("enableMTOM"));
        superTenantOutMessageContext.setProperty("enableSwA", msgContext.getProperty("enableSwA"));
        superTenantOutMessageContext.setProperty("HTTP_METHOD", msgContext.getProperty("HTTP_METHOD"));
        superTenantOutMessageContext.setProperty("DISABLE_CHUNKING", msgContext.getProperty("DISABLE_CHUNKING"));
        superTenantOutMessageContext.setProperty("NO_KEEPALIVE", msgContext.getProperty("NO_KEEPALIVE"));
        boolean forced = msgContext.isPropertyTrue(FORCE_SC_ACCEPTED);
        if (forced) {
            superTenantOutMessageContext.setProperty(FORCE_SC_ACCEPTED, (Object)true);
        }
        if (forcedNoBody = msgContext.isPropertyTrue(FORCE_POST_PUT_NOBODY)) {
            superTenantOutMessageContext.setProperty(FORCE_POST_PUT_NOBODY, (Object)true);
        }
        if (msgContext.getReplyTo() == null) {
            superTenantOutMessageContext.setReplyTo(new EndpointReference("http://www.w3.org/2005/08/addressing/none"));
        } else {
            superTenantOutMessageContext.setReplyTo(msgContext.getReplyTo());
        }
        Map headers = (Map)msgContext.getProperty("TRANSPORT_HEADERS");
        if (headers != null && headers.get("Content-Length") != null) {
            superTenantOutMessageContext.setProperty("ORGINAL_CONTENT_LENGTH", headers.get("Content-Length"));
        }
        boolean forceContentLength = msgContext.isPropertyTrue("FORCE_HTTP_CONTENT_LENGTH");
        boolean contentLengthCopy = msgContext.isPropertyTrue("COPY_CONTENT_LENGTH_FROM_INCOMING");
        superTenantOutMessageContext.setProperty("POST_TO_URI", msgContext.getProperty("POST_TO_URI"));
        superTenantOutMessageContext.setProperty("FORCE_HTTP_CONTENT_LENGTH", (Object)forceContentLength);
        superTenantOutMessageContext.setProperty("COPY_CONTENT_LENGTH_FROM_INCOMING", (Object)contentLengthCopy);
        superTenantOutMessageContext.setProperty("messageType", msgContext.getProperty("messageType"));
        if (msgContext.getOperationContext() != null && (inMessageContext = msgContext.getOperationContext().getMessageContext("In")) != null) {
            superTenantOutMessageContext.setProperty("RequestResponseTransportControl", inMessageContext.getProperty("RequestResponseTransportControl"));
        }
        if (msgContext.getProperty("disableAddressingForOutMessages") != null && ((Boolean)msgContext.getProperty("disableAddressingForOutMessages")).booleanValue()) {
            superTenantOutMessageContext.setProperty("disableAddressingForOutMessages", msgContext.getProperty("disableAddressingForOutMessages"));
        }
        if (msgContext.getProperty("pass-through.pipe") != null) {
            superTenantOutMessageContext.setProperty("pass-through.pipe", msgContext.getProperty("pass-through.pipe"));
            superTenantOutMessageContext.setProperty("message.builder.invoked", msgContext.getProperty("message.builder.invoked") != null ? msgContext.getProperty("message.builder.invoked") : Boolean.FALSE);
        }
        if (msgContext.getProperty("pass-through.Source-Connection") != null) {
            superTenantOutMessageContext.setProperty("pass-through.Source-Connection", msgContext.getProperty("pass-through.Source-Connection"));
        }
        if (msgContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION") != null) {
            superTenantOutMessageContext.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", msgContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION"));
        }
        if (msgContext.getProperty("rest_get_delete_invoke") != null) {
            superTenantOutMessageContext.setProperty("rest_get_delete_invoke", msgContext.getProperty("rest_get_delete_invoke"));
        }
        if ((decodeMultipartDataParam = msgContext.getProperty("DECODE_MULTIPART_DATA")) != null) {
            superTenantOutMessageContext.setProperty("DECODE_MULTIPART_DATA", decodeMultipartDataParam);
        }
        if (msgContext.getProperty(SERVICE_PREFIX) != null) {
            superTenantOutMessageContext.setProperty(SERVICE_PREFIX, msgContext.getProperty(SERVICE_PREFIX));
        }
        if (msgContext.getProperty(HTTP_ETAG) != null) {
            superTenantOutMessageContext.setProperty(HTTP_ETAG, msgContext.getProperty(HTTP_ETAG));
        }
        if (msgContext.getProperty(REQUEST_HOST_HEADER) != null) {
            superTenantOutMessageContext.setProperty(REQUEST_HOST_HEADER, msgContext.getProperty(REQUEST_HOST_HEADER));
        }
        if (msgContext.getProperty(NO_ENTITY_BODY) != null) {
            superTenantOutMessageContext.setProperty(NO_ENTITY_BODY, msgContext.getProperty(NO_ENTITY_BODY));
        }
        if (msgContext.getProperty(TRANSPORT_MAIL_FORMAT) != null) {
            superTenantOutMessageContext.setProperty(TRANSPORT_MAIL_FORMAT, msgContext.getProperty(TRANSPORT_MAIL_FORMAT));
        }
        for (String property : this.dataHolder.getTenantMsgContextProperties()) {
            if (msgContext.getProperty(property) == null) continue;
            superTenantOutMessageContext.setProperty(property, msgContext.getProperty(property));
        }
        this.setDeleteRequestWithPayloadProperty(superTenantOutMessageContext, msgContext);
        EndpointReference epr = TenantTransportSender.getDestinationEPR(msgContext);
        if (epr != null && !incomingMEP.equals("http://www.w3.org/ns/wsdl/out-only")) {
            String messageId = UIDGenerator.generateURNString();
            superTenantOutMessageContext.setMessageID(messageId);
            superTenantOutMessageContext.setProperty("TENANT_REQUEST_MSG_CTX", (Object)msgContext);
            superTenantOutMessageContext.setServerSide(true);
            MessageContext superTenantInMessageContext = new MessageContext();
            superTenantInMessageContext.setMessageID(superTenantOutMessageContext.getMessageID());
            superTenantInMessageContext.setProperty("synapse.RelatesToForPox", (Object)messageId);
            superTenantInMessageContext.setServerSide(true);
            superTenantInMessageContext.setMessageID(messageId);
            superTenantInMessageContext.setServiceContext(serviceContext);
            axisOperation.registerOperationContext(superTenantInMessageContext, operationContext);
        }
        if (!JavaUtils.isTrueExplicitly((Object)msgContext.getProperty("tenantMRStartedFault"))) {
            AxisEngine.send((MessageContext)superTenantOutMessageContext);
            if (superTenantOutMessageContext.getProperty("TRANSPORT_IN") != null) {
                msgContext.getOperationContext().setProperty("TRANSPORT_IN", superTenantOutMessageContext.getProperty("TRANSPORT_IN"));
            }
            msgContext.setProperty("HTTP_METHOD_OBJECT", superTenantOutMessageContext.getProperty("HTTP_METHOD_OBJECT"));
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    public void cleanup(MessageContext msgContext) throws AxisFault {
        HttpMethod httpMethod = (HttpMethod)msgContext.getProperty("HTTP_METHOD_OBJECT");
        if (httpMethod != null) {
            httpMethod.releaseConnection();
            msgContext.removeProperty("HTTP_METHOD_OBJECT");
        }
    }

    public void init(ConfigurationContext confContext, TransportOutDescription transportOut) throws AxisFault {
    }

    public void stop() {
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }

    protected void setDeleteRequestWithPayloadProperty(MessageContext superTenantOutMessageContext, MessageContext msgContext) {
        if (msgContext.getProperty(DELETE_REQUEST_WITH_PAYLOAD) != null) {
            superTenantOutMessageContext.setProperty(DELETE_REQUEST_WITH_PAYLOAD, msgContext.getProperty(DELETE_REQUEST_WITH_PAYLOAD));
        }
    }
}

