/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy.eager;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;

public class TenantLoadingConfig {
    private static final Log logger = LogFactory.getLog(TenantLoadingConfig.class);
    public static final String TENANT_IDLE_TIME = "tenant.idle.time";
    private LinkedHashSet<String> includeTenantList = new LinkedHashSet();
    private LinkedHashSet<String> excludeTenantList = new LinkedHashSet();
    private boolean includeAllTenants;
    private boolean isOptional;

    public void init() {
        ServerConfigurationService serverConfigurationService = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
        String tenantIdleTime = serverConfigurationService.getFirstProperty("Tenant.LoadingPolicy.LazyLoading.IdleTime");
        String eagerLoadingString = serverConfigurationService.getFirstProperty("Tenant.LoadingPolicy.EagerLoading.Include");
        if (tenantIdleTime != null) {
            logger.info((Object)"Using tenant lazy loading policy...");
            System.setProperty(TENANT_IDLE_TIME, tenantIdleTime);
            if (eagerLoadingString != null) {
                logger.warn((Object)"Make sure that Eager loading configuration is disabled when Lazy loading in use.");
            }
        } else {
            String[] tenants;
            if (eagerLoadingString == null || eagerLoadingString.trim().isEmpty()) {
                this.isOptional = true;
                logger.info((Object)"Switching to default mode : Tenant lazy loading mechanism has been activated...");
                return;
            }
            this.isOptional = false;
            logger.info((Object)"Using tenant eager loading policy...");
            for (String tenant : tenants = eagerLoadingString.split(",")) {
                if ((tenant = tenant.trim()).equals("*")) {
                    this.includeAllTenants = true;
                    continue;
                }
                if (tenant.contains("!")) {
                    if (tenant.contains("*")) {
                        throw new IllegalArgumentException(tenant + " is not a valid tenant domain");
                    }
                    this.excludeTenantList.add(tenant.replace("!", ""));
                    continue;
                }
                this.includeTenantList.add(tenant);
            }
        }
    }

    public boolean isEagerLoadingEnabled() {
        return this.includeAllTenants || !this.excludeTenantList.isEmpty() || !this.includeTenantList.isEmpty();
    }

    public List<String> getExcludeTenantList() {
        return new ArrayList<String>(this.excludeTenantList);
    }

    public List<String> getIncludeTenantList() {
        return new ArrayList<String>(this.includeTenantList);
    }

    public boolean includeAllTenants() {
        return this.includeAllTenants;
    }

    public boolean isOptional() {
        return this.isOptional;
    }
}

