/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy.eager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.eager.TenantLoadingConfig;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.core.service.RealmService;

public class TenantEagerLoader {
    private static final Log logger = LogFactory.getLog(TenantEagerLoader.class);
    private CarbonCoreDataHolder carbonCoreDataHolder = CarbonCoreDataHolder.getInstance();
    private TenantLoadingConfig tenantLoadingConfig = new TenantLoadingConfig();

    public TenantEagerLoader() {
        this.tenantLoadingConfig.init();
    }

    public void initializeEagerLoadingTenants() {
        List<String> validTenantDomains = null;
        validTenantDomains = this.getValidTenantDomains();
        if (!this.tenantLoadingConfig.isOptional()) {
            List<String> tenantsToBeEagerLoaded = this.getTenantsToBeEagerLoaded(validTenantDomains);
            this.loadTenants(tenantsToBeEagerLoaded);
        }
    }

    private List<String> getValidTenantDomains() {
        ArrayList<String> tenantDomains;
        try {
            RealmService realmService = this.carbonCoreDataHolder.getRealmService();
            tenantDomains = new ArrayList<String>();
            List<Tenant> validTenantList = Arrays.asList(realmService.getTenantManager().getAllTenants());
            for (Tenant tenant : validTenantList) {
                tenantDomains.add(tenant.getDomain());
            }
        }
        catch (Exception e) {
            String msg = "Could not load valid tenant domains";
            logger.error((Object)msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        return tenantDomains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTenants(List<String> validTenantDomains) {
        for (String tenantDomain : validTenantDomains) {
            String msg;
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext ctx = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                ctx.setTenantDomain(tenantDomain, true);
                TenantAxisUtils.getTenantConfigurationContext(tenantDomain, this.carbonCoreDataHolder.getMainServerConfigContext());
            }
            catch (OutOfMemoryError e) {
                msg = "OutOfMemoryError while Eager loading tenant : " + tenantDomain;
                throw new RuntimeException(msg, e);
            }
            catch (Throwable e) {
                msg = "Error while Eager loading tenant : " + tenantDomain;
                logger.error((Object)msg, e);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    private List<String> getTenantsToBeEagerLoaded(List<String> validTenantDomains) {
        ArrayList<String> tenantsToBeLoaded = new ArrayList<String>();
        if (this.tenantLoadingConfig.isEagerLoadingEnabled()) {
            List<String> includeTenantList = this.validateTenantDomains(this.tenantLoadingConfig.getIncludeTenantList(), validTenantDomains);
            List<String> excludeTenantList = this.validateTenantDomains(this.tenantLoadingConfig.getExcludeTenantList(), validTenantDomains);
            if (this.tenantLoadingConfig.includeAllTenants()) {
                tenantsToBeLoaded.addAll(validTenantDomains);
                if (!excludeTenantList.isEmpty()) {
                    tenantsToBeLoaded.removeAll(excludeTenantList);
                }
            } else {
                tenantsToBeLoaded.addAll(includeTenantList);
            }
        }
        return tenantsToBeLoaded;
    }

    private List<String> validateTenantDomains(List<String> tenantDomains, List<String> validTenantDomains) {
        ArrayList<String> validatedTenantDomains = new ArrayList<String>();
        for (String domain : tenantDomains) {
            if (!validTenantDomains.contains(domain)) {
                logger.warn((Object)("Tenant " + domain + " is not available in the system."));
                continue;
            }
            validatedTenantDomains.add(domain);
        }
        return validatedTenantDomains;
    }
}

