/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.wso2.carbon.context.PrivilegedCarbonContext;

public class TenantAxisConfiguration
extends AxisConfiguration {
    private static final String REPOSITORY = "carbon.repository";
    private Map<String, Boolean> restrictedItems = new HashMap<String, Boolean>();

    private TenantAxisConfiguration() {
    }

    public static TenantAxisConfiguration createInstance() {
        TenantAxisConfiguration tenantAxisConfiguration = new TenantAxisConfiguration();
        tenantAxisConfiguration.init();
        return tenantAxisConfiguration;
    }

    private void init() {
        this.restrictedItems.put("carbonContextHolder", true);
        this.restrictedItems.put(REPOSITORY, false);
    }

    public void setRepository(URL axis2Repository) {
        this.checkRestrictedItem(REPOSITORY);
        super.setRepository(axis2Repository);
    }

    public void addParameter(Parameter param) throws AxisFault {
        this.checkRestrictedItem(param.getName());
        super.addParameter(param);
    }

    public void addParameter(String paramName, Object value) throws AxisFault {
        this.checkRestrictedItem(paramName);
        super.addParameter(paramName, value);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.checkRestrictedItem(param.getName());
        super.removeParameter(param);
    }

    private void checkRestrictedItem(String itemName) {
        if (this.restrictedItems.containsKey(itemName)) {
            Boolean isSet = this.restrictedItems.get(itemName);
            if (isSet.booleanValue()) {
                int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
                String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                throw new SecurityException("Malicious code detected! Trying to override restricted item: " + itemName + ". An incident has been logged for tenant " + tenantDomain + "[" + tenantId + "]");
            }
            this.restrictedItems.put(itemName, true);
        }
    }
}

