/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.multitenancy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axiom.attachments.Attachments;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.dispatchers.HTTPLocationBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.internal.MultitenantMsgContextDataHolder;
import org.wso2.carbon.core.multitenancy.MultitenantRESTServlet;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class MultitenantMessageReceiver
implements MessageReceiver {
    private static final String TENANT_DELIMITER = "/t/";
    private static final Log log = LogFactory.getLog(MultitenantMessageReceiver.class);
    private static final String TENANT_IN_ONLY_MESSAGE = "TENANT_IN_ONLY_MESSAGE";
    private static final String FORCE_SC_ACCEPTED = "FORCE_SC_ACCEPTED";
    private static final String SYNAPSE_IS_RESPONSE = "synapse.isresponse";
    private static final String FORCE_POST_PUT_NOBODY = "FORCE_POST_PUT_NOBODY";
    private MultitenantMsgContextDataHolder dataHolder = MultitenantMsgContextDataHolder.getInstance();

    public void receive(MessageContext mainInMsgContext) throws AxisFault {
        EndpointReference toEpr = MultitenantMessageReceiver.getDestinationEPR(mainInMsgContext);
        if (toEpr != null) {
            this.processRequest(mainInMsgContext);
        } else {
            this.processResponse(mainInMsgContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponse(MessageContext mainInMsgContext) throws AxisFault {
        MessageContext tenantRequestMsgCtx;
        MessageContext requestMsgCtx = mainInMsgContext.getOperationContext().getMessageContext("In");
        if (requestMsgCtx != null && (tenantRequestMsgCtx = (MessageContext)requestMsgCtx.getProperty("TENANT_REQUEST_MSG_CTX")) != null) {
            String tenantDomain;
            MessageContext tenantResponseMsgCtx = tenantRequestMsgCtx.getOperationContext().getMessageContext("In");
            if (tenantRequestMsgCtx.getProperty("tenantDomain") != null) {
                tenantDomain = (String)tenantRequestMsgCtx.getProperty("tenantDomain");
            } else {
                tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                log.warn((Object)"Tenant domain is not available in tenant request message context, hence it might not be set in the thread local carbon context");
            }
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                privilegedCarbonContext.setTenantDomain(tenantDomain, true);
                if (tenantResponseMsgCtx == null) {
                    tenantResponseMsgCtx = new MessageContext();
                    tenantResponseMsgCtx.setOperationContext(tenantRequestMsgCtx.getOperationContext());
                }
                tenantResponseMsgCtx.setProperty("tenantDomain", (Object)tenantDomain);
                tenantResponseMsgCtx.setServerSide(true);
                tenantResponseMsgCtx.setDoingREST(tenantRequestMsgCtx.isDoingREST());
                Iterator itr = mainInMsgContext.getPropertyNames();
                while (itr.hasNext()) {
                    String key = (String)itr.next();
                    if (key == null) continue;
                    tenantResponseMsgCtx.setProperty(key, mainInMsgContext.getProperty(key));
                }
                tenantResponseMsgCtx.setProperty("TRANSPORT_IN", tenantRequestMsgCtx.getProperty("TRANSPORT_IN"));
                tenantResponseMsgCtx.setTransportIn(tenantRequestMsgCtx.getTransportIn());
                tenantResponseMsgCtx.setTransportOut(tenantRequestMsgCtx.getTransportOut());
                tenantResponseMsgCtx.setProperty("TRANSPORT_HEADERS", mainInMsgContext.getProperty("TRANSPORT_HEADERS"));
                if (!(tenantRequestMsgCtx.getOperationContext().getAxisOperation() instanceof OutOnlyAxisOperation)) {
                    tenantResponseMsgCtx.setAxisMessage(tenantRequestMsgCtx.getOperationContext().getAxisOperation().getMessage("In"));
                }
                tenantResponseMsgCtx.setOperationContext(tenantRequestMsgCtx.getOperationContext());
                tenantResponseMsgCtx.setConfigurationContext(tenantRequestMsgCtx.getConfigurationContext());
                tenantResponseMsgCtx.setTo(null);
                tenantResponseMsgCtx.setSoapAction(mainInMsgContext.getSoapAction());
                tenantResponseMsgCtx.setEnvelope(mainInMsgContext.getEnvelope());
                tenantResponseMsgCtx.removeProperty("DISABLE_CHUNKING");
                if (mainInMsgContext.getProperty("pass-through.pipe") != null) {
                    tenantResponseMsgCtx.setProperty("pass-through.pipe", mainInMsgContext.getProperty("pass-through.pipe"));
                    tenantResponseMsgCtx.setProperty("PASS_THROUGH_SOURCE_CONFIGURATION", mainInMsgContext.getProperty("PASS_THROUGH_SOURCE_CONFIGURATION"));
                    tenantResponseMsgCtx.setProperty("READY2ROCK", mainInMsgContext.getProperty("READY2ROCK"));
                    tenantResponseMsgCtx.setProperty("pass-through.Source-Connection", mainInMsgContext.getProperty("pass-through.Source-Connection"));
                }
                if (this.isHTTPOrHTTPsRequest(mainInMsgContext)) {
                    tenantResponseMsgCtx.setProperty("message.builder.invoked", (Object)Boolean.FALSE);
                } else if (mainInMsgContext.getProperty("message.builder.invoked") != null) {
                    tenantResponseMsgCtx.setProperty("message.builder.invoked", mainInMsgContext.getProperty("message.builder.invoked"));
                }
                tenantResponseMsgCtx.setProperty("ContentType", mainInMsgContext.getProperty("ContentType"));
                AxisEngine.receive((MessageContext)tenantResponseMsgCtx);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(MessageContext mainInMsgContext) throws AxisFault {
        String serviceAndOperation;
        String tenantDomain;
        ConfigurationContext mainConfigCtx = mainInMsgContext.getConfigurationContext();
        String to = mainInMsgContext.getTo().getAddress();
        int tenantDelimiterIndex = to.indexOf(TENANT_DELIMITER);
        if (tenantDelimiterIndex != -1) {
            tenantDomain = MultitenantUtils.getTenantDomainFromUrl((String)to);
            serviceAndOperation = to.substring(tenantDelimiterIndex + tenantDomain.length() + 4);
        } else {
            tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
            serviceAndOperation = Utils.getServiceAndOperationPart((String)to, (String)mainInMsgContext.getConfigurationContext().getServiceContextPath());
        }
        if (tenantDomain == null) {
            this.handleException(mainInMsgContext, new AxisFault("Tenant not specified"));
            return;
        }
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantDomain(tenantDomain, true);
            mainInMsgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", (Object)"SKIP");
            ConfigurationContext tenantConfigCtx = TenantAxisUtils.getTenantConfigurationContext(tenantDomain, mainConfigCtx);
            if (tenantConfigCtx == null) {
                this.handleException(mainInMsgContext, new AxisFault("Tenant " + tenantDomain + "  not found"));
                return;
            }
            if (mainInMsgContext.isDoingREST()) {
                this.doREST(mainInMsgContext, to, tenantDomain, tenantConfigCtx, serviceAndOperation);
            } else {
                this.doSOAP(mainInMsgContext, tenantDomain, tenantConfigCtx, serviceAndOperation);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private void doSOAP(MessageContext mainInMsgContext, String tenant, ConfigurationContext tenantConfigCtx, String serviceName) throws AxisFault {
        MessageContext tenantInMsgCtx = tenantConfigCtx.createMessageContext();
        tenantInMsgCtx.setMessageID(UUIDGenerator.getUUID());
        Options options = tenantInMsgCtx.getOptions();
        options.setTo(new EndpointReference("local://" + tenantConfigCtx.getServicePath() + "/" + serviceName));
        options.setAction(mainInMsgContext.getSoapAction());
        tenantInMsgCtx.setEnvelope(mainInMsgContext.getEnvelope());
        tenantInMsgCtx.setServerSide(true);
        this.copyProperties(mainInMsgContext, tenantInMsgCtx);
        tenantInMsgCtx.setProperty("tenantDomain", (Object)tenant);
        try {
            String transportOutName = mainInMsgContext.getTransportOut().getName();
            TransportOutDescription transportOutDescription = tenantConfigCtx.getAxisConfiguration().getTransportOut(transportOutName);
            tenantInMsgCtx.setTransportOut(transportOutDescription);
            TransportInDescription incomingTransport = tenantConfigCtx.getAxisConfiguration().getTransportIn(mainInMsgContext.getIncomingTransportName());
            tenantInMsgCtx.setTransportIn(incomingTransport);
            tenantInMsgCtx.setProperty("TRANSPORT_OUT", mainInMsgContext.getProperty("TRANSPORT_OUT"));
            tenantInMsgCtx.setProperty("OutTransportInfo", mainInMsgContext.getProperty("OutTransportInfo"));
            tenantInMsgCtx.setIncomingTransportName(mainInMsgContext.getIncomingTransportName());
            tenantInMsgCtx.setProperty("RequestResponseTransportControl", mainInMsgContext.getProperty("RequestResponseTransportControl"));
            AxisEngine.receive((MessageContext)tenantInMsgCtx);
            boolean nioAck = tenantInMsgCtx.isPropertyTrue("NIO-ACK-Requested", false);
            String respWritten = "";
            if (tenantInMsgCtx.getOperationContext() != null) {
                respWritten = (String)tenantInMsgCtx.getOperationContext().getProperty("RESPONSE_WRITTEN");
            }
            boolean respWillFollow = !"true".equals(respWritten) && !"SKIP".equals(respWritten);
            boolean forced = tenantInMsgCtx.isPropertyTrue(FORCE_SC_ACCEPTED);
            if (forced) {
                mainInMsgContext.setProperty(FORCE_SC_ACCEPTED, (Object)true);
            }
            if (nioAck || respWillFollow || forced) {
                mainInMsgContext.setProperty("HTTP_SC", tenantInMsgCtx.getProperty("HTTP_SC"));
                mainInMsgContext.setProperty("NIO-ACK-Requested", (Object)nioAck);
                mainInMsgContext.removeProperty("TRANSPORT_HEADERS");
                Map responseHeaders = (Map)tenantInMsgCtx.getProperty("TRANSPORT_HEADERS");
                mainInMsgContext.setProperty("TRANSPORT_HEADERS", (Object)responseHeaders);
            }
            if (mainInMsgContext.getOperationContext() != null && tenantInMsgCtx.getOperationContext() != null) {
                if (tenantInMsgCtx.getOperationContext().getMessageContext("Out") != null) {
                    mainInMsgContext.getOperationContext().addMessageContext(tenantInMsgCtx.getOperationContext().getMessageContext("Out"));
                } else {
                    mainInMsgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", tenantInMsgCtx.getOperationContext().getProperty("RESPONSE_WRITTEN"));
                }
            }
        }
        catch (AxisFault axisFault) {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)tenantInMsgCtx, (Throwable)axisFault);
            faultContext.setTransportOut(tenantInMsgCtx.getTransportOut());
            faultContext.setProperty("tenantMRStartedFault", (Object)"true");
            AxisEngine.sendFault((MessageContext)faultContext);
            axisFault.setDetail(null);
            MessageContext mainFaultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mainInMsgContext, (Throwable)axisFault);
            mainFaultContext.setTo(faultContext.getTo());
            mainFaultContext.setSoapAction(faultContext.getSoapAction());
            mainFaultContext.setEnvelope(faultContext.getEnvelope());
            throw new AxisFault(axisFault.getMessage(), mainFaultContext);
        }
    }

    private void doREST(MessageContext mainInMsgContext, String to, String tenant, ConfigurationContext tenantConfigCtx, String serviceName) throws AxisFault {
        HttpServletRequest request = (HttpServletRequest)mainInMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        if (request != null) {
            HttpServletResponse response = (HttpServletResponse)mainInMsgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETRESPONSE);
            this.doServletRest(mainInMsgContext, to, tenant, tenantConfigCtx, serviceName, request, response);
        } else {
            this.doNhttpREST(mainInMsgContext, to, tenant, tenantConfigCtx, serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doServletRest(MessageContext mainInMsgContext, String to, String tenant, ConfigurationContext tenantConfigCtx, String serviceName, HttpServletRequest request, HttpServletResponse response) throws AxisFault {
        String serviceWithSlashT = TENANT_DELIMITER + tenant + "/" + serviceName;
        String requestUri = "local://" + tenantConfigCtx.getServicePath() + "/" + serviceName + (to.endsWith(serviceWithSlashT) ? "" : "/" + to.substring(to.indexOf(serviceWithSlashT) + serviceWithSlashT.length() + 1));
        MultitenantRESTServlet restServlet = new MultitenantRESTServlet(tenantConfigCtx, requestUri, tenant);
        String httpMethod = (String)mainInMsgContext.getProperty("HTTP_METHOD_OBJECT");
        try {
            if (httpMethod.equals("GET")) {
                restServlet.doGet(request, response);
            } else if (httpMethod.equals("POST")) {
                restServlet.doPost(request, response);
            } else if (httpMethod.equals("PUT")) {
                restServlet.doPut(request, response);
            } else if (httpMethod.equals("DELETE")) {
                restServlet.doDelete(request, response);
            }
        }
        catch (ServletException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        MessageContext tenantOutMsgContext = restServlet.getOutMessageContext();
        MessageContext tenantOutFaultMsgContext = restServlet.getOutFaultMessageContext();
        if (tenantOutFaultMsgContext != null) {
            MessageContext mainOutFaultMsgContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mainInMsgContext, null);
            mainOutFaultMsgContext.setEnvelope(tenantOutFaultMsgContext.getEnvelope());
            throw new AxisFault("Problem with executing the message", mainOutFaultMsgContext);
        }
        if (tenantOutMsgContext != null) {
            MessageContext mainOutMsgContext = MessageContextBuilder.createOutMessageContext((MessageContext)mainInMsgContext);
            mainOutMsgContext.getOperationContext().addMessageContext(mainOutMsgContext);
            mainOutMsgContext.getAxisOperation().getMessage("Out").setElementQName(tenantOutMsgContext.getAxisOperation().getMessage("Out").getElementQName());
            mainOutMsgContext.getAxisService().addSchema((Collection)tenantOutMsgContext.getAxisService().getSchema());
            mainOutMsgContext.setEnvelope(tenantOutMsgContext.getEnvelope());
            mainOutMsgContext.setProperty("messageType", tenantOutMsgContext.getProperty("messageType"));
            try {
                AxisEngine.send((MessageContext)mainOutMsgContext);
            }
            finally {
                mainOutMsgContext.getAxisService().getSchema().removeAll(tenantOutMsgContext.getAxisService().getSchema());
            }
        }
    }

    public void doNhttpREST(MessageContext mainInMsgContext, String to, String tenant, ConfigurationContext tenantConfigCtx, String servicePart) throws AxisFault {
        String serviceWithSlashT = TENANT_DELIMITER + tenant + "/" + servicePart;
        String requestUri = "local://" + tenantConfigCtx.getServicePath() + "/" + servicePart + (to.endsWith(serviceWithSlashT) ? "" : "/" + to.substring(to.indexOf(serviceWithSlashT) + serviceWithSlashT.length() + 1));
        MessageContext tenantInMsgCtx = tenantConfigCtx.createMessageContext();
        String trsPrefix = (String)mainInMsgContext.getProperty("TransportInURL");
        int sepindex = trsPrefix.indexOf(58);
        if (sepindex > -1) {
            trsPrefix = trsPrefix.substring(0, sepindex);
            tenantInMsgCtx.setIncomingTransportName(trsPrefix);
        } else {
            tenantInMsgCtx.setIncomingTransportName("http");
        }
        tenantInMsgCtx.setMessageID(UIDGenerator.generateURNString());
        tenantInMsgCtx.setServerSide(true);
        tenantInMsgCtx.setDoingREST(true);
        this.copyProperties(mainInMsgContext, tenantInMsgCtx);
        tenantInMsgCtx.setTo(new EndpointReference(requestUri));
        String transportOutName = mainInMsgContext.getTransportOut().getName();
        TransportOutDescription transportOutDescription = tenantConfigCtx.getAxisConfiguration().getTransportOut(transportOutName);
        tenantInMsgCtx.setTransportOut(transportOutDescription);
        TransportInDescription incomingTransport = tenantConfigCtx.getAxisConfiguration().getTransportIn(mainInMsgContext.getIncomingTransportName());
        tenantInMsgCtx.setTransportIn(incomingTransport);
        tenantInMsgCtx.setProperty("TRANSPORT_OUT", mainInMsgContext.getProperty("TRANSPORT_OUT"));
        tenantInMsgCtx.setProperty("OutTransportInfo", mainInMsgContext.getProperty("OutTransportInfo"));
        tenantInMsgCtx.setIncomingTransportName(mainInMsgContext.getIncomingTransportName());
        String transportInClassName = mainInMsgContext.getTransportIn().getReceiver().getClass().getName();
        if ("org.apache.synapse.transport.nhttp.HttpCoreNIOListener".equals(transportInClassName) || "org.apache.synapse.transport.nhttp.HttpCoreNIOSSLListener".equals(transportInClassName) || "org.apache.synapse.transport.passthru.PassThroughHttpListener".equals(transportInClassName) || "org.apache.synapse.transport.passthru.PassThroughHttpSSLListener".equals(transportInClassName) || "org.apache.synapse.transport.passthru.PassThroughHttpMultiSSLListener".equals(transportInClassName)) {
            tenantInMsgCtx.setProperty("tenantDomain", (Object)tenant);
        }
        String service = "";
        String postFix = "";
        int index = servicePart.indexOf("/");
        if (index > 0) {
            service = servicePart.substring(0, index);
            postFix = servicePart.substring(index + 1);
        }
        if (service.equals("")) {
            service = servicePart;
        }
        tenantInMsgCtx.setProperty("REST_URL_POSTFIX", (Object)postFix);
        if (tenantConfigCtx.getAxisConfiguration().getService(service) == null) {
            tenantInMsgCtx.setAxisService(tenantConfigCtx.getAxisConfiguration().getService("__SynapseService"));
        }
        tenantInMsgCtx.setEnvelope(mainInMsgContext.getEnvelope());
        InputStream in = (InputStream)mainInMsgContext.getProperty("nhttp.input.stream");
        OutputStream os = (OutputStream)mainInMsgContext.getProperty("nhttp.output.stream");
        String contentType = (String)mainInMsgContext.getProperty("ContentType");
        try {
            boolean forced;
            String httpMethod = (String)mainInMsgContext.getProperty("HTTP_METHOD");
            if (httpMethod.equals("GET") || httpMethod.equals("DELETE") || "OPTIONS".equals(httpMethod) || "HEAD".equals(httpMethod)) {
                this.processRESTRequest(tenantInMsgCtx, os, contentType);
            } else if (httpMethod.equals("POST") || httpMethod.equals("PUT") || httpMethod.equals("PATCH")) {
                this.processRESTRequest(tenantInMsgCtx, os, contentType);
            }
            if (mainInMsgContext.getOperationContext() != null && tenantInMsgCtx.getOperationContext() != null) {
                boolean isResponse;
                forced = tenantInMsgCtx.isPropertyTrue(FORCE_SC_ACCEPTED);
                if (forced) {
                    mainInMsgContext.setProperty(FORCE_SC_ACCEPTED, (Object)true);
                }
                if (isResponse = tenantInMsgCtx.isPropertyTrue(SYNAPSE_IS_RESPONSE)) {
                    mainInMsgContext.setProperty(SYNAPSE_IS_RESPONSE, (Object)true);
                } else {
                    mainInMsgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", tenantInMsgCtx.getOperationContext().getProperty("RESPONSE_WRITTEN"));
                }
            }
            if (tenantInMsgCtx.getProperty(TENANT_IN_ONLY_MESSAGE) != null && Boolean.TRUE.equals(tenantInMsgCtx.getProperty(TENANT_IN_ONLY_MESSAGE))) {
                mainInMsgContext.getOperationContext().removeProperty("RESPONSE_WRITTEN");
            }
            if (mainInMsgContext.getOperationContext() != null && tenantInMsgCtx.getOperationContext() != null) {
                boolean isResponse;
                boolean forcedNoBody;
                forced = tenantInMsgCtx.isPropertyTrue(FORCE_SC_ACCEPTED);
                if (forced) {
                    mainInMsgContext.setProperty(FORCE_SC_ACCEPTED, (Object)true);
                }
                if (forcedNoBody = tenantInMsgCtx.isPropertyTrue(FORCE_POST_PUT_NOBODY)) {
                    mainInMsgContext.setProperty(FORCE_POST_PUT_NOBODY, (Object)true);
                }
                if (isResponse = tenantInMsgCtx.isPropertyTrue(SYNAPSE_IS_RESPONSE)) {
                    mainInMsgContext.setProperty(SYNAPSE_IS_RESPONSE, (Object)true);
                } else {
                    mainInMsgContext.getOperationContext().setProperty("RESPONSE_WRITTEN", tenantInMsgCtx.getOperationContext().getProperty("RESPONSE_WRITTEN"));
                }
            }
        }
        catch (AxisFault axisFault) {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)tenantInMsgCtx, (Throwable)axisFault);
            faultContext.setTransportOut(tenantInMsgCtx.getTransportOut());
            faultContext.setProperty("tenantMRStartedFault", (Object)"true");
            AxisEngine.sendFault((MessageContext)faultContext);
            axisFault.setDetail(null);
            MessageContext mainFaultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mainInMsgContext, (Throwable)axisFault);
            mainFaultContext.setTo(faultContext.getTo());
            mainFaultContext.setSoapAction(faultContext.getSoapAction());
            mainFaultContext.setEnvelope(faultContext.getEnvelope());
            throw new AxisFault(axisFault.getMessage(), mainFaultContext);
        }
    }

    private Handler.InvocationResponse processRESTRequest(MessageContext msgContext, OutputStream os, String contentType) throws AxisFault {
        try {
            msgContext.setDoingREST(true);
            String charSetEncoding = BuilderUtil.getCharSetEncoding((String)contentType);
            msgContext.setProperty("CHARACTER_SET_ENCODING", (Object)charSetEncoding);
            MultitenantMessageReceiver.dispatchAndVerify(msgContext);
        }
        catch (AxisFault axisFault) {
            throw axisFault;
        }
        finally {
            String messageType = (String)msgContext.getProperty("messageType");
            if ("application/x-www-form-urlencoded".equals(messageType) || "multipart/form-data".equals(messageType)) {
                msgContext.setProperty("messageType", (Object)"application/xml");
            }
        }
        return AxisEngine.receive((MessageContext)msgContext);
    }

    private static void dispatchAndVerify(MessageContext msgContext) throws AxisFault {
        RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();
        requestDispatcher.invoke(msgContext);
        AxisService axisService = msgContext.getAxisService();
        if (axisService != null) {
            AxisOperation axisOperation;
            HTTPLocationBasedDispatcher httpLocationBasedDispatcher = new HTTPLocationBasedDispatcher();
            httpLocationBasedDispatcher.invoke(msgContext);
            if (msgContext.getAxisOperation() == null) {
                RequestURIOperationDispatcher requestURIOperationDispatcher = new RequestURIOperationDispatcher();
                requestURIOperationDispatcher.invoke(msgContext);
            }
            if ((axisOperation = msgContext.getAxisOperation()) != null) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)msgContext.getProperty("endpoint");
                if (axisEndpoint != null) {
                    AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisEndpoint.getBinding().getChild((Object)axisOperation.getName());
                    msgContext.setProperty("AxisBindingOperation", (Object)axisBindingOperation);
                }
                msgContext.setAxisOperation(axisOperation);
            }
        }
    }

    private void copyProperties(MessageContext mainMsgCtx, MessageContext tenantMsgCtx) {
        tenantMsgCtx.setSoapAction(mainMsgCtx.getSoapAction());
        tenantMsgCtx.setDoingREST(mainMsgCtx.isDoingREST());
        tenantMsgCtx.setDoingMTOM(mainMsgCtx.isDoingMTOM());
        tenantMsgCtx.setDoingSwA(mainMsgCtx.isDoingSwA());
        Attachments attachments = mainMsgCtx.getAttachmentMap();
        if (attachments != null && attachments.getAllContentIDs().length > 0) {
            String[] cIDs = attachments.getAllContentIDs();
            String soapPart = attachments.getSOAPPartContentID();
            for (String cID : cIDs) {
                if (cID.equals(soapPart)) continue;
                tenantMsgCtx.addAttachment(cID, attachments.getDataHandler(cID));
            }
        }
        Iterator itr = mainMsgCtx.getPropertyNames();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (key == null) continue;
            tenantMsgCtx.setProperty(key, mainMsgCtx.getProperty(key));
        }
        for (String property : this.dataHolder.getTenantMsgContextProperties()) {
            if (mainMsgCtx.getProperty(property) == null) continue;
            tenantMsgCtx.setProperty(property, mainMsgCtx.getProperty(property));
        }
    }

    private void handleException(MessageContext mainInMsgContext, AxisFault fault) throws AxisFault {
        MessageContext mainOutMsgContext = MessageContextBuilder.createFaultMessageContext((MessageContext)mainInMsgContext, (Throwable)fault);
        OperationContext mainOpContext = mainInMsgContext.getOperationContext();
        mainOpContext.addMessageContext(mainOutMsgContext);
        mainOutMsgContext.setOperationContext(mainOpContext);
        AxisEngine.sendFault((MessageContext)mainOutMsgContext);
    }

    private boolean isHTTPOrHTTPsRequest(MessageContext messageContext) {
        String incomingTransportName;
        return messageContext.getTransportOut() != null && ((incomingTransportName = String.valueOf(messageContext.getTransportOut().getName())).equals("http") || incomingTransportName.equals("https"));
    }

    public static EndpointReference getDestinationEPR(MessageContext msgContext) {
        String transportURL = (String)msgContext.getProperty("TransportURL");
        if (transportURL != null) {
            return new EndpointReference(transportURL);
        }
        if (msgContext.getTo() != null && !msgContext.getTo().hasAnonymousAddress()) {
            return msgContext.getTo();
        }
        return null;
    }
}

