/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.util.Arrays;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.core.multitenancy.MultitenantMessageReceiver;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.utils.multitenancy.MultitenantConstants;

@Component(name="org.wso2.carbon.core.internal.MultitenantTransportOutServiceComponent", immediate=true)
public class MultitenantTransportOutServiceComponent {
    private static final Log log = LogFactory.getLog(MultitenantTransportOutServiceComponent.class);
    private ConfigurationContext configCtx;

    protected void activate(ComponentContext context) {
        try {
            this.deployMultiTenantClientOutService(this.configCtx.getAxisConfiguration());
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Failed to activate the MultitenantTransportOutServiceComponent", (Throwable)axisFault);
        }
    }

    protected void deactivate(ComponentContext context) {
    }

    private void deployMultiTenantClientOutService(AxisConfiguration axisCfg) throws AxisFault {
        AxisServiceGroup superTenantSenderServiceGroup = new AxisServiceGroup(axisCfg);
        superTenantSenderServiceGroup.setServiceGroupName("tenantClientService");
        AxisService superTenantSenderClientService = new AxisService("tenantClientService");
        superTenantSenderClientService.addParameter("hiddenService", (Object)"true");
        superTenantSenderServiceGroup.addService(superTenantSenderClientService);
        superTenantSenderClientService.addOperation((AxisOperation)new InOutAxisOperation(MultitenantConstants.MULTITENANT_CLIENT_SERVICE_IN_OUT_OPERATION));
        superTenantSenderClientService.getOperation(MultitenantConstants.MULTITENANT_CLIENT_SERVICE_IN_OUT_OPERATION).setMessageReceiver((MessageReceiver)new MultitenantMessageReceiver());
        superTenantSenderClientService.addOperation((AxisOperation)new OutOnlyAxisOperation(MultitenantConstants.MULTITENANT_CLIENT_SERVICE_OUT_ONLY_OPERATION));
        superTenantSenderClientService.getOperation(MultitenantConstants.MULTITENANT_CLIENT_SERVICE_OUT_ONLY_OPERATION).setMessageReceiver((MessageReceiver)new MultitenantMessageReceiver());
        axisCfg.addServiceGroup(superTenantSenderServiceGroup);
        superTenantSenderClientService.setClientSide(true);
        List<String> exposedTransportList = Arrays.asList("http", "https", "local");
        superTenantSenderClientService.setExposedTransports(exposedTransportList);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Deployed tenantClientService");
        }
    }

    @Reference(name="org.wso2.carbon.configCtx", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContext")
    protected void setConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = configCtx.getServerConfigContext();
    }

    protected void unsetConfigurationContext(ConfigurationContextService configCtx) {
        this.configCtx = null;
    }
}

