/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.core.internal.MultitenantMsgContextDataHolder;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="org.wso2.carbon.core.internal.MultitenantMsgContextServiceComponent", immediate=true)
public class MultitenantMsgContextServiceComponent {
    private static final Log log = LogFactory.getLog(MultitenantMsgContextServiceComponent.class);
    private MultitenantMsgContextDataHolder dataHolder = MultitenantMsgContextDataHolder.getInstance();
    private static String MULTITENANT_MSG_CONTEXT_PROPERTIES_FILE = "multitenant-msg-context.properties";

    @Activate
    protected void activate(ComponentContext context) {
        this.loadTenantMessageContextProperties();
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    private void loadTenantMessageContextProperties() {
        Properties properties = new Properties();
        List<String> tenantMsgContextProperties = this.dataHolder.getTenantMsgContextProperties();
        String filePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + MULTITENANT_MSG_CONTEXT_PROPERTIES_FILE;
        File file = new File(filePath);
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
                for (Object key : properties.keySet()) {
                    tenantMsgContextProperties.add((String)key);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)((String)key + " is added to MultitenantMsgContextDataHolder.tenantMsgContextProperties list"));
                }
            }
            catch (IOException e) {
                log.warn((Object)("Error while reading file from " + filePath), (Throwable)e);
            }
        }
    }
}

