/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.CarbonCoreInitializedEvent;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.ServerRestartHandler;
import org.wso2.carbon.core.ServerShutdownHandler;
import org.wso2.carbon.core.ServerStartupHandler;
import org.wso2.carbon.core.ServerStartupObserver;
import org.wso2.carbon.core.clustering.api.CoordinatedActivity;
import org.wso2.carbon.core.encryption.KeyStoreBasedExternalCryptoProvider;
import org.wso2.carbon.core.encryption.SymmetricEncryption;
import org.wso2.carbon.core.init.CarbonServerManager;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.internal.DeploymentServerStartupObserver;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.crypto.api.ExternalCryptoProvider;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="carbon.core.dscomponent", immediate=true)
public class CarbonCoreServiceComponent {
    private static Log log = LogFactory.getLog(CarbonCoreServiceComponent.class);
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();
    private static List<ServerShutdownHandler> shutdownHandlers = new ArrayList<ServerShutdownHandler>();
    private static List<ServerRestartHandler> restartHandlers = new ArrayList<ServerRestartHandler>();
    private static List<ServerStartupHandler> startupHandlers = new ArrayList<ServerStartupHandler>();
    private static List<ServerStartupObserver> serverStartupObservers = new ArrayList<ServerStartupObserver>();
    private static boolean serverStarted;
    private CarbonServerManager carbonServerManager;

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantDomain("carbon.super");
            carbonContext.setTenantId(-1234);
            ctxt.getBundleContext().registerService(ServerStartupObserver.class.getName(), (Object)new DeploymentServerStartupObserver(), null);
            SymmetricEncryption encryption = SymmetricEncryption.getInstance();
            encryption.generateSymmetricKey();
            ctxt.getBundleContext().registerService(ExternalCryptoProvider.class, (Object)new KeyStoreBasedExternalCryptoProvider(), null);
            this.carbonServerManager = new CarbonServerManager();
            this.carbonServerManager.start(ctxt.getBundleContext());
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Carbon Core bundle ", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        try {
            PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            privilegedCarbonContext.setTenantDomain("carbon.super");
            privilegedCarbonContext.setTenantId(-1234);
            this.carbonServerManager.stop();
        }
        catch (Throwable e) {
            log.error((Object)"Failed clean up Carbon core", e);
        }
        try {
            if ("false".equals(this.dataHolder.getServerConfigurationService().getFirstProperty("RequireCarbonServlet"))) {
                return;
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error while retrieving serverConfiguration instance", (Throwable)e);
        }
        serverStarted = false;
        log.debug((Object)"Carbon Core bundle is deactivated ");
    }

    @Reference(name="server.configuration.service", policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MANDATORY, unbind="unsetServerConfigurationService")
    protected void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(serverConfigurationService);
    }

    protected void unsetServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.dataHolder.setServerConfigurationService(null);
    }

    @Reference(name="user.realmservice.default", unbind="unsetRealmService", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC)
    protected void setRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        this.dataHolder.setRealmService(null);
    }

    @Reference(name="http.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetHttpService")
    protected void setHttpService(HttpService httpService) {
        this.dataHolder.setHttpService(httpService);
    }

    protected void unsetHttpService(HttpService httpService) {
        this.dataHolder.setHttpService(null);
    }

    @Reference(name="registry.service", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    @Reference(name="tenant.registry.loader", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unSetTenantRegistryLoader")
    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        this.dataHolder.setTenantRegistryLoader(tenantRegistryLoader);
    }

    protected void unSetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        this.dataHolder.setTenantRegistryLoader(null);
    }

    @Reference(name="carbonCryptoService", cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonCryptoService")
    protected void setCarbonCryptoService(CryptoService cryptoService) {
        this.dataHolder.setCryptoService(cryptoService);
    }

    protected void unsetCarbonCryptoService(CryptoService cryptoService) {
        this.dataHolder.setCryptoService(null);
    }

    @Reference(name="serverShutdownHandler", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeServerShutdownHandler")
    protected void addServerShutdownHandler(ServerShutdownHandler shutdownHandler) {
        shutdownHandlers.add(shutdownHandler);
    }

    protected void removeServerShutdownHandler(ServerShutdownHandler shutdownHandler) {
        shutdownHandlers.remove(shutdownHandler);
    }

    @Reference(name="serverRestartHandler", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeServerRestartHandler")
    protected void addServerRestartHandler(ServerRestartHandler restartHandler) {
        restartHandlers.add(restartHandler);
    }

    protected void removeServerRestartHandler(ServerRestartHandler restartHandler) {
        restartHandlers.remove(restartHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="serverStartupHandler", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeServerStartupHandler")
    protected void addServerStartupHandler(ServerStartupHandler startupHandler) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (serverStarted) {
                startupHandler.invoke();
            } else {
                startupHandlers.add(startupHandler);
            }
        }
    }

    protected void removeServerStartupHandler(ServerStartupHandler startupHandler) {
        startupHandlers.remove(startupHandler);
    }

    public static void shutdown() {
        for (ServerShutdownHandler shutdownHandler : shutdownHandlers) {
            shutdownHandler.invoke();
        }
    }

    public static void restart() {
        for (ServerRestartHandler restartHandler : restartHandlers) {
            restartHandler.invoke();
        }
    }

    public static synchronized void startup() {
        for (ServerStartupHandler startupHandler : startupHandlers) {
            startupHandler.invoke();
        }
        startupHandlers.clear();
        serverStarted = true;
    }

    @Reference(name="coordinatedActivity", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeCoordinatedActivity")
    protected void addCoordinatedActivity(CoordinatedActivity coordinatedActivity) {
        CarbonCoreDataHolder.getInstance().addCoordinatedActivity(coordinatedActivity);
    }

    protected void removeCoordinatedActivity(CoordinatedActivity coordinatedActivity) {
        CarbonCoreDataHolder.getInstance().removeCoordinatedActivity(coordinatedActivity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(name="serverStartupObserver", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="removeServerStartupObserver")
    protected void addServerStartupObserver(ServerStartupObserver startupObserver) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (serverStarted) {
                startupObserver.completedServerStartup();
            } else {
                serverStartupObservers.add(startupObserver);
            }
        }
    }

    protected void removeServerStartupObserver(ServerStartupObserver startupObserver) {
        serverStartupObservers.remove(startupObserver);
    }

    public static synchronized void notifyBefore() {
        for (ServerStartupObserver observer : serverStartupObservers) {
            observer.completingServerStartup();
        }
    }

    public static synchronized void notifyAfter() {
        for (ServerStartupObserver observer : serverStartupObservers) {
            observer.completedServerStartup();
        }
        serverStarted = true;
        startupHandlers.clear();
    }

    protected void unsetCarbonCoreInitializedEventService(CarbonCoreInitializedEvent carbonCoreInitializedEvent) {
    }

    @Reference(name="carbonCoreInitializedEventService", cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonCoreInitializedEventService")
    protected void setCarbonCoreInitializedEventService(CarbonCoreInitializedEvent carbonCoreInitializedEventService) {
    }
}

