/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.engine.ListenerManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.http.HttpService;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.core.clustering.api.CoordinatedActivity;
import org.wso2.carbon.crypto.api.CryptoService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.user.core.service.RealmService;

public class CarbonCoreDataHolder {
    private static CarbonCoreDataHolder instance = new CarbonCoreDataHolder();
    private Log log = LogFactory.getLog(CarbonCoreDataHolder.class);
    private BundleContext bundleContext;
    private RealmService realmService;
    private RegistryService registryService;
    private HttpService httpService;
    private ListenerManager listenerManager;
    private ConfigurationContext mainServerConfigContext;
    private ServerConfigurationService serverConfigurationService;
    private TenantRegistryLoader tenantRegistryLoader;
    private List<CoordinatedActivity> coordinatedActivities = new ArrayList<CoordinatedActivity>();
    private CryptoService cryptoService;

    public static CarbonCoreDataHolder getInstance() {
        return instance;
    }

    private CarbonCoreDataHolder() {
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void setRealmService(RealmService realmService) {
        this.realmService = realmService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public HttpService getHttpService() throws Exception {
        if (this.httpService == null) {
            String msg = "Before activating Carbon Core bundle, an instance of " + HttpService.class.getName() + " should be in existance";
            this.log.error((Object)msg);
            throw new Exception(msg);
        }
        return this.httpService;
    }

    public RealmService getRealmService() throws Exception {
        if (this.realmService == null) {
            String msg = "Before activating Carbon Core bundle, an instance of UserRealm service should be in existance";
            this.log.error((Object)msg);
            throw new Exception(msg);
        }
        return this.realmService;
    }

    public RegistryService getRegistryService() throws Exception {
        if (this.registryService == null) {
            String msg = "Before activating Carbon Core bundle, an instance of RegistryService should be in existance";
            this.log.error((Object)msg);
            throw new Exception(msg);
        }
        return this.registryService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        if (this.serverConfigurationService == null) {
            String msg = "Before activating Carbon Core bundle, an instance of ServerConfigurationService should be in existance";
            this.log.error((Object)msg);
        }
        return this.serverConfigurationService;
    }

    public ListenerManager getListenerManager() {
        return this.listenerManager;
    }

    public void setListenerManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
    }

    public void setMainServerConfigContext(ConfigurationContext mainServerConfigContext) {
        this.mainServerConfigContext = mainServerConfigContext;
    }

    public ConfigurationContext getMainServerConfigContext() {
        return this.mainServerConfigContext;
    }

    public void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        this.tenantRegistryLoader = tenantRegistryLoader;
    }

    public TenantRegistryLoader getTenantRegistryLoader() {
        return this.tenantRegistryLoader;
    }

    public void addCoordinatedActivity(CoordinatedActivity coordinatedActivity) {
        this.coordinatedActivities.add(coordinatedActivity);
    }

    public void removeCoordinatedActivity(CoordinatedActivity coordinatedActivity) {
        this.coordinatedActivities.remove(coordinatedActivity);
    }

    public List<CoordinatedActivity> getCoordinatedActivities() {
        return this.coordinatedActivities;
    }

    public void setCryptoService(CryptoService cryptoService) {
        this.cryptoService = cryptoService;
    }

    public CryptoService getCryptoService() {
        return this.cryptoService;
    }
}

