/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.init;

import java.io.File;
import java.net.SocketException;
import java.rmi.NoSuchObjectException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.carbon.core.security.CarbonJMXAuthenticator;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.ManagementFactory;
import org.wso2.carbon.utils.NetworkUtils;
import org.wso2.carbon.utils.ServerException;

public class JMXServerManager {
    private static Log log = LogFactory.getLog(JMXServerManager.class);
    private Registry rmiRegistry;
    private JMXConnectorServer jmxConnectorServer;
    private static final String START_RMI_SERVER = "StartRMIServer";
    private static final String JMX_HOST_NAME = "HostName";
    private static final String JMX_RMI_REGISTRY_PORT = "RMIRegistryPort";
    private static final String JMX_RMI_SERVER_PORT = "RMIServerPort";
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private JMXConfig jmxProperties = new JMXConfig();

    public void startJMXService() throws ServerException {
        int rmiRegistryPort;
        String filePath = CarbonUtils.getEtcCarbonConfigDirPath() + File.separator + "jmx.xml";
        boolean startJMXServer = false;
        File jmxConfigFile = new File(filePath);
        if (jmxConfigFile.exists()) {
            this.parseJMXConfigXML(filePath);
            startJMXServer = this.jmxProperties.isStartServer();
            if (!startJMXServer) {
                return;
            }
        }
        if ((rmiRegistryPort = this.jmxProperties.getRmiRegistryPort()) == -1) {
            throw new ServerException("RMIRegistry port has not been properly defined in the jmx.xml or carbon.xml files");
        }
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        try {
            try {
                this.rmiRegistry = LocateRegistry.createRegistry(rmiRegistryPort);
            }
            catch (Throwable ignored) {
                log.error((Object)"Could not create the RMI local registry", ignored);
            }
            String hostName = startJMXServer && this.jmxProperties.getHostName() != null ? this.jmxProperties.getHostName() : NetworkUtils.getLocalHostname();
            int rmiServerPort = this.jmxProperties.getRmiServerPort();
            String jmxURL = rmiServerPort != -1 ? "service:jmx:rmi://" + hostName + ":" + rmiServerPort + "/jndi/rmi://" + hostName + ":" + rmiRegistryPort + "/jmxrmi" : "service:jmx:rmi:///jndi/rmi://" + hostName + ":" + rmiRegistryPort + "/jmxrmi";
            JMXServiceURL url = new JMXServiceURL(jmxURL);
            HashMap<String, Object> env = new HashMap<String, Object>();
            String accessFilePath = CarbonUtils.getCarbonSecurityConfigDirPath() + File.separator + "jmxremote.access";
            env.put("jmx.remote.authenticator", new CarbonJMXAuthenticator());
            env.put("jmx.remote.x.access.file", accessFilePath);
            this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            this.jmxConnectorServer.start();
            log.info((Object)("JMX Service URL  : " + jmxURL));
        }
        catch (Exception e) {
            String msg = "Could not initialize RMI server";
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void stopJmxService() {
        try {
            if (this.jmxConnectorServer != null) {
                this.jmxConnectorServer.stop();
                try {
                    UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
                }
                catch (NoSuchObjectException noSuchObjectException) {}
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred while stopping JMXConnectorServer", (Throwable)e);
        }
    }

    private void parseJMXConfigXML(String jmxXmlPath) {
        String hostName = "localhost";
        try {
            hostName = NetworkUtils.getLocalHostname();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        boolean startServer = false;
        try {
            Node item;
            Node item2;
            Node startRMIServer;
            DocumentBuilderFactory docBuilderFactory = JMXServerManager.getSecuredDocumentBuilder();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new File(jmxXmlPath));
            Node jmx = doc.getElementsByTagName("JMX").item(0);
            if (jmx == null) {
                throw new RuntimeException("JMX element not found");
            }
            Element jmxEle = (Element)jmx;
            if (jmxEle.getElementsByTagName(START_RMI_SERVER).getLength() > 0 && (startRMIServer = jmxEle.getElementsByTagName(START_RMI_SERVER).item(0)) != null && (item2 = startRMIServer.getChildNodes().item(0)) != null && !(startServer = Boolean.parseBoolean(item2.getNodeValue().trim()))) {
                this.jmxProperties.setStartServer(false);
                return;
            }
            if (jmxEle.getElementsByTagName(JMX_HOST_NAME).getLength() > 0 && (item = jmxEle.getElementsByTagName(JMX_HOST_NAME).item(0)) != null && (item = item.getChildNodes().item(0)) != null) {
                hostName = item.getNodeValue().trim();
            }
            int rmiRegistryPort = this.getPort(JMX_RMI_REGISTRY_PORT, jmxEle);
            int rmiServerPort = this.getPort(JMX_RMI_SERVER_PORT, jmxEle);
            this.jmxProperties.setHostName(hostName);
            this.jmxProperties.setStartServer(startServer);
            this.jmxProperties.setRmiRegistryPort(rmiRegistryPort);
            this.jmxProperties.setRmiServerPort(rmiServerPort);
        }
        catch (Throwable t) {
            log.fatal((Object)"Failed to parse jmx.xml", t);
        }
    }

    private static DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }

    private int getPort(String elementTagName, Element jmxEle) {
        Node item;
        String port = "-1";
        if (jmxEle.getElementsByTagName(elementTagName).getLength() > 0 && (item = jmxEle.getElementsByTagName(elementTagName).item(0)) != null && (item = item.getChildNodes().item(0)) != null && (port = item.getNodeValue().trim()).startsWith("${")) {
            port = Integer.toString(CarbonUtils.getPortFromServerConfig((String)port));
        }
        return Integer.parseInt(port);
    }

    private static class JMXConfig {
        private String hostName;
        private boolean startServer;
        private int rmiRegistryPort;
        private int rmiServerPort;

        private JMXConfig() {
        }

        public void setStartServer(boolean startServer) {
            this.startServer = startServer;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String hostName) {
            this.hostName = hostName;
        }

        public boolean isStartServer() {
            return this.startServer;
        }

        public int getRmiRegistryPort() {
            return this.rmiRegistryPort;
        }

        public void setRmiRegistryPort(int rmiRegistryPort) {
            this.rmiRegistryPort = rmiRegistryPort;
        }

        public int getRmiServerPort() {
            return this.rmiServerPort;
        }

        public void setRmiServerPort(int rmiServerPort) {
            this.rmiServerPort = rmiServerPort;
        }
    }
}

