/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.encryption;

import java.io.File;
import java.io.FileInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.axiom.om.util.Base64;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.CryptoException;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class SymmetricEncryption {
    private static SymmetricEncryption instance = null;
    private static SecretKey symmetricKey = null;
    private static boolean isSymmetricKeyFromFile = false;
    private static String symmetricKeyEncryptAlgoDefault = "AES";
    private static String symmetricKeySecureVaultAliasDefault = "symmetric.key.value";
    private String propertyKey = "symmetric.key";
    private String symmetricKeyEncryptEnabled;
    private String symmetricKeyEncryptAlgo;
    private String symmetricKeySecureVaultAlias;

    public static synchronized SymmetricEncryption getInstance() {
        if (instance == null) {
            instance = new SymmetricEncryption();
        }
        return instance;
    }

    public void generateSymmetricKey() throws CryptoException {
        Object output = null;
        Object generator = null;
        String encryptionAlgo = null;
        try {
            ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
            this.symmetricKeyEncryptEnabled = serverConfiguration.getFirstProperty("SymmetricEncryption.IsEnabled");
            if (!Boolean.parseBoolean(this.symmetricKeyEncryptEnabled)) {
                return;
            }
            this.symmetricKeyEncryptAlgo = serverConfiguration.getFirstProperty("SymmetricEncryption.Algorithm");
            this.symmetricKeySecureVaultAlias = serverConfiguration.getFirstProperty("SymmetricEncryption.SecureVaultAlias");
            String filePath = CarbonUtils.getCarbonHome() + File.separator + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "symmetric-key.properties";
            File file = new File(filePath);
            if (file.exists()) {
                Properties properties;
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    properties = new Properties();
                    properties.load(fileInputStream);
                }
                SecretResolver secretResolver = SecretResolverFactory.create((Properties)properties);
                String secretAlias = this.symmetricKeySecureVaultAlias == null ? symmetricKeySecureVaultAliasDefault : this.symmetricKeySecureVaultAlias;
                encryptionAlgo = this.symmetricKeyEncryptAlgo == null ? symmetricKeyEncryptAlgoDefault : this.symmetricKeyEncryptAlgo;
                if (secretResolver != null && secretResolver.isInitialized()) {
                    symmetricKey = secretResolver.isTokenProtected(secretAlias) ? new SecretKeySpec(Base64.decode((String)secretResolver.resolve(secretAlias)), 0, Base64.decode((String)secretResolver.resolve(secretAlias)).length, encryptionAlgo) : new SecretKeySpec(Base64.decode((String)((String)properties.get(secretAlias))), 0, Base64.decode((String)((String)properties.get(secretAlias))).length, encryptionAlgo);
                } else if (properties.containsKey(this.propertyKey)) {
                    symmetricKey = new SecretKeySpec(properties.getProperty(this.propertyKey).getBytes(), 0, properties.getProperty(this.propertyKey).getBytes().length, encryptionAlgo);
                }
                if (symmetricKey != null) {
                    isSymmetricKeyFromFile = true;
                }
            }
            if (!isSymmetricKeyFromFile) {
                throw new CryptoException("Error in generating symmetric key. Symmetric key is not available.");
            }
        }
        catch (Exception e) {
            throw new CryptoException("Error in generating symmetric key", e);
        }
    }

    public byte[] encryptWithSymmetricKey(byte[] plainText) throws CryptoException {
        Cipher c = null;
        byte[] encryptedData = null;
        try {
            String encryptionAlgo = this.symmetricKeyEncryptAlgo == null ? symmetricKeyEncryptAlgoDefault : this.symmetricKeyEncryptAlgo;
            c = Cipher.getInstance(encryptionAlgo);
            c.init(1, symmetricKey);
            encryptedData = c.doFinal(plainText);
        }
        catch (Exception e) {
            throw new CryptoException("Error when encrypting data.", e);
        }
        return encryptedData;
    }

    public byte[] decryptWithSymmetricKey(byte[] encryptionBytes) throws CryptoException {
        Cipher c = null;
        byte[] decryptedData = null;
        try {
            String encryptionAlgo = this.symmetricKeyEncryptAlgo == null ? symmetricKeyEncryptAlgoDefault : this.symmetricKeyEncryptAlgo;
            c = Cipher.getInstance(encryptionAlgo);
            c.init(2, symmetricKey);
            decryptedData = c.doFinal(encryptionBytes);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new CryptoException("Error when decrypting data.", e);
        }
        return decryptedData;
    }

    public String getSymmetricKeyEncryptEnabled() {
        return this.symmetricKeyEncryptEnabled;
    }
}

