/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.encryption.AlgorithmParameterResolver;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.crypto.api.CertificateInfo;
import org.wso2.carbon.crypto.api.CryptoContext;
import org.wso2.carbon.crypto.api.CryptoException;
import org.wso2.carbon.crypto.api.ExternalCryptoProvider;
import org.wso2.carbon.crypto.api.HybridEncryptionInput;
import org.wso2.carbon.crypto.api.HybridEncryptionOutput;
import org.wso2.carbon.crypto.api.PrivateKeyInfo;

public class KeyStoreBasedExternalCryptoProvider
implements ExternalCryptoProvider {
    private static Log log = LogFactory.getLog(KeyStoreBasedExternalCryptoProvider.class);
    private static SecureRandom random = new SecureRandom();

    public byte[] sign(byte[] data, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext, PrivateKeyInfo privateKeyInfo) throws CryptoException {
        try {
            Signature signature = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, javaSecurityAPIProvider);
            PrivateKey privateKey = this.getPrivateKey(cryptoContext, privateKeyInfo);
            if (privateKey == null) {
                String errorMessage = String.format("Could not retrieve the private key using '%s' and '%s'. ", privateKeyInfo, cryptoContext);
                log.error((Object)errorMessage);
                throw new CryptoException(errorMessage);
            }
            signature.initSign(privateKey);
            signature.update(data);
            byte[] signatureBytes = signature.sign();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully signed data using the algorithm '%s' and the Java Security API provider '%s'; %s ; %s", algorithm, javaSecurityAPIProvider, cryptoContext, privateKeyInfo));
            }
            return signatureBytes;
        }
        catch (Exception e) {
            String errorMessage = String.format("An error occurred while signing using the algorithm : '%s' and the Java Security API provider : '%s'; %s ; %s", algorithm, javaSecurityAPIProvider, cryptoContext, privateKeyInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] ciphertext, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext, PrivateKeyInfo privateKeyInfo) throws CryptoException {
        try {
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, javaSecurityAPIProvider);
            PrivateKey privateKey = this.getPrivateKey(cryptoContext, privateKeyInfo);
            if (privateKey == null) {
                String errorMessage = String.format("Could not retrieve the private key using '%s' and '%s'. ", privateKeyInfo, cryptoContext);
                log.error((Object)errorMessage);
                throw new CryptoException(errorMessage);
            }
            cipher.init(2, privateKey);
            byte[] cleartext = cipher.doFinal(ciphertext);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully decrypted data using the algorithm '%s' and the Java Security API provider '%s'; %s ; %s", algorithm, javaSecurityAPIProvider, cryptoContext, privateKeyInfo));
            }
            return cleartext;
        }
        catch (Exception e) {
            String errorMessage = String.format("An error occurred while decrypting using the algorithm : '%s' and the Java Security API provider : '%s'; %s ; %s", algorithm, javaSecurityAPIProvider, cryptoContext, privateKeyInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] encrypt(byte[] plaintext, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext, CertificateInfo certificateInfo) throws CryptoException {
        try {
            Cipher cipher = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, javaSecurityAPIProvider);
            Certificate certificate = this.getCertificate(cryptoContext, certificateInfo);
            if (certificate == null) {
                String errorMessage = String.format("Could not retrieve the certificate using '%s' and '%s'. ", certificateInfo, cryptoContext);
                log.error((Object)errorMessage);
                throw new CryptoException(errorMessage);
            }
            cipher.init(1, certificate);
            byte[] ciphertext = cipher.doFinal(plaintext);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully encrypted data using the algorithm '%s' and the Java Security API provider '%s'; %s ; %s", algorithm, javaSecurityAPIProvider, cryptoContext, certificateInfo));
            }
            return ciphertext;
        }
        catch (Exception e) {
            String errorMessage = String.format("An error occurred while encrypting using the algorithm '%s' and the Java Security API provider '%s'; %s ; %s", algorithm, javaSecurityAPIProvider, cryptoContext, certificateInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public boolean verifySignature(byte[] data, byte[] signatureBytes, String algorithm, String javaSecurityAPIProvider, CryptoContext cryptoContext, CertificateInfo certificateInfo) throws CryptoException {
        try {
            Signature signature = StringUtils.isBlank((String)javaSecurityAPIProvider) ? Signature.getInstance(algorithm) : Signature.getInstance(algorithm, javaSecurityAPIProvider);
            Certificate certificate = this.getCertificate(cryptoContext, certificateInfo);
            if (certificate == null) {
                String errorMessage = String.format("Could not retrieve the certificate using '%s' and '%s'. ", certificateInfo, cryptoContext);
                log.error((Object)errorMessage);
                throw new CryptoException(errorMessage);
            }
            signature.initVerify(certificate);
            signature.update(data);
            boolean verificationResult = signature.verify(signatureBytes);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully carried out the signature validation operation using the algorithm '%s' and the Java Security API provider '%s'; %s ; %s. Verification Result : '%s'", algorithm, javaSecurityAPIProvider, cryptoContext, certificateInfo, verificationResult));
            }
            return verificationResult;
        }
        catch (Exception e) {
            String errorMessage = String.format("An error occurred while verifying the signature using the algorithm '%s' and the Java Security API provider '%s'; %s ; %s ", algorithm, javaSecurityAPIProvider, cryptoContext, certificateInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public Certificate getCertificate(CryptoContext cryptoContext, CertificateInfo certificateInfo) throws CryptoException {
        this.failIfContextInformationIsMissing(cryptoContext);
        if (certificateInfo.getCertificate() != null) {
            return certificateInfo.getCertificate();
        }
        KeyStoreManager keyStoreManager = KeyStoreManager.getInstance(cryptoContext.getTenantId());
        try {
            if (-1234 == cryptoContext.getTenantId()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking for the certificate in the super tenant using " + certificateInfo));
                }
                KeyStore keyStore = keyStoreManager.getPrimaryKeyStore();
                return keyStore.getCertificate(certificateInfo.getCertificateAlias());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Looking for the certificate in the tenant '%s' using %s", cryptoContext.getTenantDomain(), certificateInfo));
            }
            String keyStoreName = this.getTenantKeyStoreName(cryptoContext.getTenantDomain());
            KeyStore keyStore = keyStoreManager.getKeyStore(keyStoreName);
            return keyStore.getCertificate(certificateInfo.getCertificateAlias());
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while retrieving the certificate from the key store.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public PrivateKey getPrivateKey(CryptoContext cryptoContext, PrivateKeyInfo privateKeyInfo) throws CryptoException {
        this.failIfContextInformationIsMissing(cryptoContext);
        try {
            PrivateKey privateKey;
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance(cryptoContext.getTenantId());
            if (-1234 == cryptoContext.getTenantId()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Looking for the private key in the super tenant using " + privateKeyInfo));
                }
                KeyStore keyStore = keyStoreManager.getPrimaryKeyStore();
                privateKey = (PrivateKey)keyStore.getKey(privateKeyInfo.getKeyAlias(), privateKeyInfo.getKeyPassword().toCharArray());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Looking for the private key in the tenant '%s' using %s", cryptoContext.getTenantDomain(), privateKeyInfo));
                }
                String keyStoreName = this.getTenantKeyStoreName(cryptoContext.getTenantDomain());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Derived Key Store name of the the tenant '%s' is %s", cryptoContext.getTenantDomain(), keyStoreName));
                }
                privateKey = (PrivateKey)keyStoreManager.getPrivateKey(keyStoreName, privateKeyInfo.getKeyAlias());
            }
            return privateKey;
        }
        catch (Exception e) {
            String errorMessage = "An error occurred while retrieving the private key from the key store.";
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public HybridEncryptionOutput hybridEncrypt(HybridEncryptionInput hybridEncryptionInput, String symmetricAlgorithm, String asymmetricAlgorithm, String jceSecurityProvider, CryptoContext cryptoContext, CertificateInfo certificateInfo) throws CryptoException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Hybrid encrypt initiated with '%s' symmetric algorithm, '%s' asymmetric algorithm using '%s' JCE provider related to '%s' crypto context.", symmetricAlgorithm, asymmetricAlgorithm, jceSecurityProvider, cryptoContext));
        }
        String[] resolvedSymmetricAlgorithmSpec = this.resolveSymmetricAlgorithm(symmetricAlgorithm);
        int keyLength = Integer.parseInt(resolvedSymmetricAlgorithmSpec[1]) / 8;
        symmetricAlgorithm = resolvedSymmetricAlgorithmSpec[2];
        byte[] keyValue = new byte[keyLength];
        random.nextBytes(keyValue);
        SecretKeySpec symmetricKey = new SecretKeySpec(keyValue, resolvedSymmetricAlgorithmSpec[0]);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("A secret key of %s type was successfully generated for hybrid encryption.", resolvedSymmetricAlgorithmSpec[0]));
        }
        try {
            AlgorithmParameterSpec algoParams = AlgorithmParameterResolver.resolveSymmetricAlgorithmParameters(symmetricAlgorithm);
            byte[] encryptedData = this.symmetricEncryptData(hybridEncryptionInput, jceSecurityProvider, symmetricAlgorithm, symmetricKey, algoParams);
            byte[] encryptedKey = this.encrypt(keyValue, asymmetricAlgorithm, jceSecurityProvider, cryptoContext, certificateInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Secret key value was successfully encrypted with %s asymmetric algorithm with public certificate : %s", asymmetricAlgorithm, certificateInfo));
            }
            if (hybridEncryptionInput.getAuthData() != null) {
                int tagPos = encryptedData.length - ((GCMParameterSpec)algoParams).getTLen() / 8;
                byte[] authTag = KeyStoreBasedExternalCryptoProvider.subArray(encryptedData, tagPos, ((GCMParameterSpec)algoParams).getTLen() / 8);
                byte[] cipherData = KeyStoreBasedExternalCryptoProvider.subArray(encryptedData, 0, tagPos);
                return new HybridEncryptionOutput(cipherData, encryptedKey, hybridEncryptionInput.getAuthData(), authTag, algoParams);
            }
            return new HybridEncryptionOutput(encryptedData, encryptedKey, algoParams);
        }
        catch (Exception e) {
            String errorMessage = String.format("An error occurred while hybrid encrypting data using the asymmetric algorithm '%s' and symmetric algorithm '%s' with the Java Security API provider '%s'; %s ; %s", asymmetricAlgorithm, symmetricAlgorithm, jceSecurityProvider, cryptoContext, certificateInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    public byte[] hybridDecrypt(HybridEncryptionOutput hybridEncryptionOutput, String symmetricAlgorithm, String asymmetricAlgorithm, String jceSecurityProvider, CryptoContext cryptoContext, PrivateKeyInfo privateKeyInfo) throws CryptoException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Hybrid decrypt initiated with '%s' symmetric algorithm, '%s' asymmetric algorithm using '%s' JCE provider related to '%s' crypto context.", symmetricAlgorithm, asymmetricAlgorithm, jceSecurityProvider, cryptoContext));
        }
        String[] resolvedSpecification = this.resolveSymmetricAlgorithm(symmetricAlgorithm);
        symmetricAlgorithm = resolvedSpecification[2];
        byte[] decryptedKey = this.decrypt(hybridEncryptionOutput.getEncryptedSymmetricKey(), asymmetricAlgorithm, jceSecurityProvider, cryptoContext, privateKeyInfo);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Symmetric key value was successfully decrypted with %s asymmetric algorithm and '%s' private key", asymmetricAlgorithm, privateKeyInfo.getKeyAlias()));
        }
        SecretKeySpec decryptionKey = new SecretKeySpec(decryptedKey, resolvedSpecification[0]);
        try {
            byte[] decryptedData = this.symmetricDecryptData(hybridEncryptionOutput, jceSecurityProvider, symmetricAlgorithm, decryptionKey);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Successfully decrypted data with '%s' symmetric algorithm, '%s' asymmetric algorithm using '%s' JCE provider related to '%s' crypto context.", symmetricAlgorithm, asymmetricAlgorithm, jceSecurityProvider, cryptoContext));
            }
            return decryptedData;
        }
        catch (Exception e) {
            String errorMessage = String.format("An error occurred while hybrid decrypting using the symmetric algorithm : '%s' and asymmetric algorithm : '%s' with the Java Security API provider : '%s'; %s ; %s", symmetricAlgorithm, asymmetricAlgorithm, jceSecurityProvider, cryptoContext, privateKeyInfo);
            if (log.isDebugEnabled()) {
                log.debug((Object)errorMessage, (Throwable)e);
            }
            throw new CryptoException(errorMessage, (Throwable)e);
        }
    }

    private void failIfContextInformationIsMissing(CryptoContext cryptoContext) throws CryptoException {
        if (cryptoContext.getTenantId() == 0 || StringUtils.isBlank((String)cryptoContext.getTenantDomain())) {
            throw new CryptoException("Tenant information is missing in the crypto context.");
        }
    }

    private String getTenantKeyStoreName(String tenantDomain) {
        return tenantDomain.trim().replace(".", "-") + ".jks";
    }

    protected byte[] symmetricEncryptData(HybridEncryptionInput hybridEncryptionInput, String jceSecurityProvider, String symmetricAlgorithm, SecretKeySpec symmetricKey, AlgorithmParameterSpec algoParams) throws Exception {
        Cipher cipher = StringUtils.isBlank((String)jceSecurityProvider) ? Cipher.getInstance(symmetricAlgorithm) : Cipher.getInstance(symmetricAlgorithm, jceSecurityProvider);
        cipher.init(1, (Key)symmetricKey, algoParams);
        if (hybridEncryptionInput.getAuthData() != null) {
            cipher.updateAAD(hybridEncryptionInput.getAuthData());
        }
        byte[] encryptedData = cipher.doFinal(hybridEncryptionInput.getPlainData());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Plain data was successfully encrypted with %s symmetric algorithm and %s secret key.", symmetricAlgorithm, symmetricKey.getAlgorithm()));
        }
        return encryptedData;
    }

    private byte[] symmetricDecryptData(HybridEncryptionOutput hybridEncryptionOutput, String jceSecurityProvider, String symmetricAlgorithm, SecretKeySpec decryptionKey) throws Exception {
        Cipher cipher = StringUtils.isBlank((String)jceSecurityProvider) ? Cipher.getInstance(symmetricAlgorithm) : Cipher.getInstance(symmetricAlgorithm, jceSecurityProvider);
        if (hybridEncryptionOutput.getParameterSpec() == null) {
            cipher.init(2, decryptionKey);
        } else {
            cipher.init(2, (Key)decryptionKey, hybridEncryptionOutput.getParameterSpec());
        }
        if (hybridEncryptionOutput.getAuthData() != null && hybridEncryptionOutput.getAuthTag() != null) {
            cipher.updateAAD(hybridEncryptionOutput.getAuthData());
            return cipher.doFinal(KeyStoreBasedExternalCryptoProvider.concatByteArrays(new byte[][]{hybridEncryptionOutput.getCipherData(), hybridEncryptionOutput.getAuthTag()}));
        }
        return cipher.doFinal(hybridEncryptionOutput.getCipherData());
    }

    private String[] resolveSymmetricAlgorithm(String symmetricAlgorithm) throws CryptoException {
        String keyLength;
        CharSequence[] algorithmSpecification = symmetricAlgorithm.split("/");
        String[] keySpecification = algorithmSpecification[0].split("_");
        if (symmetricAlgorithm.contains("AES")) {
            keyLength = "128";
        } else if (symmetricAlgorithm.contains("DES")) {
            keyLength = "64";
        } else {
            String errorMessage = String.format("'%s' symmetric algorithm is not supported for hybrid encryption/decryption.", symmetricAlgorithm);
            throw new CryptoException(errorMessage);
        }
        if (keySpecification.length > 1) {
            keyLength = keySpecification[1];
        }
        algorithmSpecification[0] = keySpecification[0];
        symmetricAlgorithm = String.join((CharSequence)"/", algorithmSpecification);
        return new String[]{keySpecification[0], keyLength, symmetricAlgorithm};
    }

    private static byte[] subArray(byte[] byteArray, int beginIndex, int length) {
        byte[] subArray = new byte[length];
        System.arraycopy(byteArray, beginIndex, subArray, 0, subArray.length);
        return subArray;
    }

    protected static byte[] concatByteArrays(byte[][] byteArrays) throws CryptoException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        for (byte[] byteArray : byteArrays) {
            try {
                outputStream.write(byteArray);
            }
            catch (IOException e) {
                String errorMessage = String.format("Error occurred while concatenating byte arrays.", new Object[0]);
                throw new CryptoException(errorMessage, (Throwable)e);
            }
        }
        return outputStream.toByteArray();
    }
}

