/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.encryption;

import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import org.wso2.carbon.crypto.api.CryptoException;

class AlgorithmParameterResolver {
    private static SecureRandom random = new SecureRandom();

    AlgorithmParameterResolver() {
    }

    static AlgorithmParameterSpec resolveSymmetricAlgorithmParameters(String symmetricAlgorithm) throws CryptoException {
        String errorMessage = String.format("'%s' symmetric algorithm is not supported.", symmetricAlgorithm);
        if (symmetricAlgorithm.contains("AES")) {
            byte[] iv = new byte[16];
            random.nextBytes(iv);
            if (symmetricAlgorithm.contains("GCM")) {
                return new GCMParameterSpec(128, iv);
            }
            if (symmetricAlgorithm.contains("CFB") || symmetricAlgorithm.contains("CBC") || symmetricAlgorithm.contains("OFB")) {
                return new IvParameterSpec(iv);
            }
            throw new CryptoException(errorMessage);
        }
        if (symmetricAlgorithm.contains("DES")) {
            byte[] iv = new byte[8];
            random.nextBytes(iv);
            return new IvParameterSpec(iv);
        }
        throw new CryptoException(errorMessage);
    }
}

