/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;

public class SynchronizeRepositoryRequest
extends ClusteringMessage {
    private static final transient Log log = LogFactory.getLog(SynchronizeRepositoryRequest.class);
    private int tenantId;
    private String tenantDomain;

    public SynchronizeRepositoryRequest() {
    }

    public SynchronizeRepositoryRequest(int tenantId, String tenantDomain) {
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public void execute(ConfigurationContext configContext) throws ClusteringFault {
        log.info((Object)("Received [" + (Object)((Object)this) + "] "));
        Parameter parameter = null;
        if (this.tenantId == -1234) {
            parameter = configContext.getAxisConfiguration().getParameter("repo.update.required");
        } else if (TenantAxisUtils.getTenantConfigurationContexts(configContext).get(this.tenantDomain) != null) {
            parameter = TenantAxisUtils.getTenantConfigurationContexts(configContext).get(this.tenantDomain).getAxisConfiguration().getParameter("repo.update.required");
        }
        log.debug((Object)"Updating repo update required parameter");
        if (parameter != null) {
            ((AtomicBoolean)parameter.getValue()).compareAndSet(false, true);
        }
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    public String toString() {
        return "SynchronizeRepositoryRequest{tenantId=" + this.tenantId + ", tenantDomain='" + this.tenantDomain + '\'' + ", messageId=" + this.getUuid() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SynchronizeRepositoryRequest)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SynchronizeRepositoryRequest that = (SynchronizeRepositoryRequest)((Object)o);
        return this.tenantId == that.tenantId && this.tenantDomain.equals(that.tenantDomain);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tenantId;
        result = 31 * result + this.tenantDomain.hashCode();
        return result;
    }
}

