/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.CarbonThreadFactory;
import org.wso2.carbon.core.deployment.RegistryBasedRepository;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class RegistryBasedRepositoryUpdater {
    private static final Log log = LogFactory.getLog(RegistryBasedRepositoryUpdater.class);
    private static final ScheduledThreadPoolExecutor exec = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(20, new CarbonThreadFactory(new ThreadGroup("RegistryBasedRepositoryUpdaterThread")));
    private static final Map<String, ScheduledFuture> futures = new ConcurrentHashMap<String, ScheduledFuture>();

    public static void scheduleAtFixedRate(UserRegistry userRegistry, String registryPath, String fileSystemRepo, long startSecs, long periodSecs) {
        ScheduledFuture<?> scheduledFuture = exec.scheduleAtFixedRate(new UpdaterTask(userRegistry, registryPath, fileSystemRepo), startSecs, periodSecs, TimeUnit.SECONDS);
        futures.put(fileSystemRepo, scheduledFuture);
    }

    private RegistryBasedRepositoryUpdater() {
    }

    public static void cleanup() {
        exec.shutdownNow();
    }

    public static void cancelTask(String fileSystemRepo) {
        ScheduledFuture scheduledFuture = futures.get(fileSystemRepo);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            exec.purge();
            futures.remove(fileSystemRepo);
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                exec.shutdownNow();
            }
        });
    }

    private static class UpdaterTask
    implements Runnable {
        private RegistryBasedRepository registryBasedRepository;

        public UpdaterTask(UserRegistry userRegistry, String registryPath, String fileSystemRepo) {
            this.registryBasedRepository = new RegistryBasedRepository(userRegistry, registryPath, fileSystemRepo);
        }

        @Override
        public void run() {
            try {
                this.registryBasedRepository.updateFileSystemFromRegistry();
            }
            catch (Throwable e) {
                log.error((Object)"Cannot load repository from registry", e);
            }
        }
    }
}

