/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.util.SystemFilter;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class DeploymentInterceptor
implements AxisObserver {
    private static final Log log = LogFactory.getLog(DeploymentInterceptor.class);
    private static volatile String[] httpAdminServicesList = null;
    private static volatile boolean allAdminServicesHttp = false;
    private static volatile boolean isFirstCheck = true;
    private final Map<String, Parameter> paramMap = new HashMap<String, Parameter>();
    private final HashMap<String, HashMap<String, AxisDescription>> faultyServicesDueToModules = new HashMap();
    private Registry registry;
    private int tenantId = -1;
    private String tenantDomain = "carbon.super";
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void init(AxisConfiguration axisConfig) {
        this.extractTenantInfo(axisConfig);
        try {
            if (this.registry == null) {
                this.registry = this.dataHolder.getRegistryService().getConfigSystemRegistry();
            }
        }
        catch (AxisFault e) {
            log.error((Object)"Error while adding PersistenceFactory parameter to axisConfig", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error while obtaining registry instance for the deployment interceptor", (Throwable)e);
        }
    }

    private void extractTenantInfo(AxisConfiguration axisConfig) {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        this.tenantId = carbonContext.getTenantId();
        this.tenantDomain = carbonContext.getTenantDomain();
    }

    private String getTenantIdAndDomainString() {
        return this.tenantId != -1 && this.tenantId != -1234 ? " {" + this.tenantDomain + "[" + this.tenantId + "]}" : " {super-tenant}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceGroupUpdate(AxisEvent axisEvent, AxisServiceGroup axisServiceGroup) {
        if (CarbonUtils.isWorkerNode()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip deployment intercepting in worker nodes.");
            }
            return;
        }
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            carbonContext.setApplicationName(axisServiceGroup.getServiceGroupName());
            if (SystemFilter.isFilteredOutService(axisServiceGroup)) {
                return;
            }
            boolean isClientSide = true;
            Iterator axisServiceGroupIterator = axisServiceGroup.getServices();
            while (axisServiceGroupIterator.hasNext()) {
                AxisService axisService = (AxisService)axisServiceGroupIterator.next();
                if (axisService.isClientSide()) continue;
                isClientSide = false;
                break;
            }
            if (isClientSide) {
                return;
            }
            int eventType = axisEvent.getEventType();
            if (SystemFilter.isGhostServiceGroup(axisServiceGroup) && eventType != 0) {
                return;
            }
            if (eventType == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deploying service group : " + axisServiceGroup.getServiceGroupName() + this.getTenantIdAndDomainString()));
                }
            } else if (eventType == 0 && log.isDebugEnabled()) {
                log.debug((Object)("Removing service group : " + axisServiceGroup.getServiceGroupName() + this.getTenantIdAndDomainString()));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceUpdate(AxisEvent axisEvent, AxisService axisService) {
        if (CarbonUtils.isWorkerNode() && axisEvent.getEventType() != 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip deployment intercepting in worker nodes.");
            }
            return;
        }
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            carbonContext.setApplicationName(axisService.getName());
            if (SystemFilter.isFilteredOutService((AxisServiceGroup)axisService.getParent())) {
                if (this.isHttpAdminService(axisService.getName())) {
                    this.changeAdminServiceTransport(axisService);
                }
                return;
            }
            if (axisService.isClientSide()) {
                return;
            }
            int eventType = axisEvent.getEventType();
            if (GhostDeployerUtils.isGhostService((AxisService)axisService) && eventType != 0) {
                return;
            }
            String serviceName = axisService.getName();
            try {
                if (eventType == 1) {
                    axisService.setActive(this.getPersistedServiceStatus(axisService));
                    if (!JavaUtils.isTrue((Object)axisService.getParameterValue("hiddenService"))) {
                        log.info((Object)("Deploying Axis2 service: " + serviceName + this.getTenantIdAndDomainString()));
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("Deploying hidden Axis2 service : " + serviceName + this.getTenantIdAndDomainString()));
                    }
                } else if (eventType == 3) {
                    this.removeServiceStatus(axisService);
                } else if (eventType == 2) {
                    this.persistServiceStatus(axisService);
                } else if (eventType == 0) {
                    log.info((Object)("Removing Axis2 Service: " + axisService.getName() + this.getTenantIdAndDomainString()));
                    if (!this.keepHistory(axisService)) {
                        this.deleteServiceResource(axisService);
                    }
                }
            }
            catch (Exception e) {
                String msg = "Exception occurred while handling service update event." + this.getTenantIdAndDomainString();
                log.error((Object)msg, (Throwable)e);
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private String getServiceResourcePath(AxisService axisService) {
        return "/repository/axis2/service-groups/" + axisService.getAxisServiceGroup().getServiceGroupName() + "/services/" + axisService.getName();
    }

    private boolean getPersistedServiceStatus(AxisService axisService) {
        String serviceResourcePath = this.getServiceResourcePath(axisService);
        boolean isServerActive = axisService.isActive();
        try {
            Resource serviceResource;
            if (this.registry.resourceExists(serviceResourcePath) && (serviceResource = this.registry.get(serviceResourcePath)).getProperty("service.active") != null) {
                isServerActive = Boolean.parseBoolean(serviceResource.getProperty("service.active"));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to read persisted service status.", (Throwable)e);
        }
        return isServerActive;
    }

    private void deleteServiceResource(AxisService axisService) {
        String serviceResourcePath = this.getServiceResourcePath(axisService);
        try {
            if (this.registry.resourceExists(serviceResourcePath)) {
                this.registry.delete(serviceResourcePath);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Service [" + axisService.getName() + "] doesn't have any resource or resource path [" + serviceResourcePath + "] has already been deleted."));
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to delete service resource.", (Throwable)e);
        }
    }

    private void persistServiceStatus(AxisService axisService) {
        String serviceResourcePath = this.getServiceResourcePath(axisService);
        try {
            Object serviceResource = this.registry.resourceExists(serviceResourcePath) ? this.registry.get(serviceResourcePath) : this.registry.newCollection();
            serviceResource.setProperty("service.active", Boolean.toString(axisService.isActive()));
            this.registry.put(serviceResourcePath, (Resource)serviceResource);
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to persist service status.", (Throwable)e);
        }
    }

    private void removeServiceStatus(AxisService axisService) {
        String serviceResourcePath = this.getServiceResourcePath(axisService);
        try {
            if (this.registry.resourceExists(serviceResourcePath)) {
                Resource serviceResource = this.registry.get(serviceResourcePath);
                serviceResource.removeProperty("service.active");
                this.registry.put(serviceResourcePath, serviceResource);
            }
        }
        catch (RegistryException e) {
            log.error((Object)"Failed to remove service status.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moduleUpdate(AxisEvent axisEvent, AxisModule axisModule) {
        if (CarbonUtils.isWorkerNode()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Skip deployment intercepting in worker nodes.");
            }
            return;
        }
        PrivilegedCarbonContext.startTenantFlow();
        try {
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            String moduleName = axisModule.getName();
            if (axisEvent.getEventType() == 4) {
                boolean globallyEngaged;
                if (axisModule.getVersion() == null) {
                    log.warn((Object)("A valid Version not found for the module : '" + moduleName + "'" + this.getTenantIdAndDomainString()));
                    String moduleVersion = "undefined";
                } else {
                    String moduleVersion = axisModule.getVersion().toString();
                }
                if (!SystemFilter.isFilteredOutModule(axisModule) && log.isDebugEnabled()) {
                    log.debug((Object)("Deploying Axis2 module: " + axisModule.getArchiveName() + this.getTenantIdAndDomainString()));
                }
                if (globallyEngaged = this.getPersistedModuleGloballyEngagedStatus(axisModule)) {
                    axisModule.addParameter(new Parameter("globally.engaged", (Object)Boolean.TRUE.toString()));
                    axisModule.getParent().engageModule(axisModule);
                }
            }
        }
        catch (AxisFault axisFault) {
            log.error((Object)("Failed to globally engage the module: " + axisModule.getName()), (Throwable)axisFault);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    private boolean getPersistedModuleGloballyEngagedStatus(AxisModule axisModule) {
        boolean globallyEngagedModule = false;
        String moduleResourcePath = this.getModuleResourcePath(axisModule);
        try {
            Resource moduleResource;
            if (this.registry.resourceExists(moduleResourcePath) && (moduleResource = this.registry.get(moduleResourcePath)).getProperty("globally.engaged") != null) {
                globallyEngagedModule = Boolean.valueOf(moduleResource.getProperty("globally.engaged"));
            }
        }
        catch (org.wso2.carbon.registry.core.exceptions.RegistryException e) {
            log.error((Object)"Failed to read persisted module globally engaged status.", (Throwable)e);
        }
        return globallyEngagedModule;
    }

    private String getModuleResourcePath(AxisModule axisModule) {
        return "/repository/axis2/modules/" + axisModule.getName() + "/" + axisModule.getVersion();
    }

    public void addParameter(Parameter parameter) throws AxisFault {
        this.paramMap.put(parameter.getName(), parameter);
    }

    public void removeParameter(Parameter param) throws AxisFault {
        this.paramMap.remove(param.getName());
    }

    public void deserializeParameters(OMElement omElement) throws AxisFault {
    }

    public Parameter getParameter(String paramName) {
        return this.paramMap.get(paramName);
    }

    public ArrayList<Parameter> getParameters() {
        Collection<Parameter> collection = this.paramMap.values();
        ArrayList<Parameter> arr = new ArrayList<Parameter>();
        for (Parameter aCollection : collection) {
            arr.add(aCollection);
        }
        return arr;
    }

    public boolean isParameterLocked(String paramName) {
        return this.paramMap.get(paramName).isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFaultyServiceDueToModule(String moduleName, AxisDescription axisDescription) {
        HashMap<String, HashMap<String, AxisDescription>> hashMap = this.faultyServicesDueToModules;
        synchronized (hashMap) {
            if (this.faultyServicesDueToModules.containsKey(moduleName)) {
                HashMap<String, AxisDescription> faultyServicesMap = this.faultyServicesDueToModules.get(moduleName);
                faultyServicesMap.put((String)axisDescription.getKey(), axisDescription);
            } else {
                HashMap<String, AxisDescription> faultyServicesMap = new HashMap<String, AxisDescription>();
                faultyServicesMap.put((String)axisDescription.getKey(), axisDescription);
                this.faultyServicesDueToModules.put(moduleName, faultyServicesMap);
            }
        }
    }

    private HashMap<String, AxisDescription> getFaultyServicesDueToModule(String moduleName) {
        if (this.faultyServicesDueToModules.containsKey(moduleName)) {
            return this.faultyServicesDueToModules.get(moduleName);
        }
        return new HashMap<String, AxisDescription>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFaultyServiceDueToModule(String moduleName, String serviceGroupName) {
        HashMap<String, HashMap<String, AxisDescription>> hashMap = this.faultyServicesDueToModules;
        synchronized (hashMap) {
            HashMap<String, AxisDescription> faultyServices = this.faultyServicesDueToModules.get(moduleName);
            if (faultyServices != null) {
                faultyServices.remove(serviceGroupName);
                if (faultyServices.isEmpty()) {
                    this.faultyServicesDueToModules.remove(moduleName);
                }
            }
        }
    }

    public void startServiceGroup(AxisServiceGroup serviceGroup, AxisConfiguration axisConfiguration) {
        Iterator itr = serviceGroup.getServices();
        while (itr.hasNext()) {
            this.startService((AxisService)itr.next(), axisConfiguration);
        }
    }

    public void stopServiceGroup(AxisServiceGroup serviceGroup, AxisConfiguration axisConfiguration) {
        Iterator itr = serviceGroup.getServices();
        while (itr.hasNext()) {
            this.stopService((AxisService)itr.next(), axisConfiguration);
        }
    }

    public void startService(AxisService axisService, AxisConfiguration axisConfiguration) {
        String serviceName = axisService.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Activating service: " + serviceName + this.getTenantIdAndDomainString()));
        }
        try {
            axisConfiguration.startService(serviceName);
            Parameter param = axisService.getParameter("carbonFaultyService");
            if (param != null) {
                axisService.removeParameter(param);
            }
        }
        catch (AxisFault e) {
            String msg = "Cannot start service : " + serviceName + this.getTenantIdAndDomainString();
            log.error((Object)msg, (Throwable)e);
        }
    }

    public void stopService(AxisService axisService, AxisConfiguration axisConfiguration) {
        String serviceName = axisService.getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deactivating service: " + serviceName + this.getTenantIdAndDomainString()));
        }
        try {
            axisConfiguration.stopService(serviceName);
            axisService.addParameter("carbonFaultyService", (Object)"This service is cannot be started due to missing modules");
        }
        catch (AxisFault e) {
            String msg = "Cannot stop service: " + serviceName + this.getTenantIdAndDomainString();
            log.error((Object)msg, (Throwable)e);
        }
    }

    private void changeAdminServiceTransport(AxisService axisService) {
        axisService.addExposedTransport("http");
        if (log.isDebugEnabled()) {
            log.debug((Object)("AdminService " + axisService.getName() + " exposed in HTTP"));
        }
    }

    private boolean isHttpAdminService(String serviceName) {
        if (!isFirstCheck && !allAdminServicesHttp && httpAdminServicesList == null) {
            return false;
        }
        if (allAdminServicesHttp) {
            return true;
        }
        if (isFirstCheck) {
            String httpAdminServices = CarbonCoreDataHolder.getInstance().getServerConfigurationService().getFirstProperty("Axis2Config.HttpAdminServices");
            if (httpAdminServices != null && !"".equals(httpAdminServices)) {
                if (httpAdminServices.equals("*")) {
                    allAdminServicesHttp = true;
                    isFirstCheck = false;
                    return true;
                }
                httpAdminServicesList = httpAdminServices.split(",");
                isFirstCheck = false;
            } else {
                isFirstCheck = false;
                return false;
            }
        }
        if (httpAdminServicesList == null) {
            return false;
        }
        for (String httpAdminService : httpAdminServicesList) {
            if (!serviceName.equals(httpAdminService)) continue;
            return true;
        }
        return false;
    }

    private boolean keepHistory(AxisService axisService) {
        Parameter keepHistoryParam = axisService.getParameter("keepServiceHistory");
        if (keepHistoryParam == null) {
            return false;
        }
        Object value = keepHistoryParam.getValue();
        return value instanceof String && Boolean.valueOf((String)value) != false;
    }
}

