/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.deployment;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.axis2.AxisFault;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.deployment.RepositoryListener;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.base.api.ServerConfigurationService;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.deployment.DeploymentSynchronizer;
import org.wso2.carbon.core.deployment.SynchronizeRepositoryRequest;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.deployment.GhostMetaArtifactsLoader;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class CarbonDeploymentSchedulerTask
extends SchedulerTask {
    public static final String REPO_UPDATE_REQUIRED = "repo.update.required";
    private static final Integer REPO_UPDATE_MIN_TIME_SECONDS = 300;
    private static final Integer REPO_UPDATE_MAX_TIME_SECONDS = 900;
    private static final Integer DEPLOYMENT_INTERVAL = 15;
    private static final Log log = LogFactory.getLog(CarbonDeploymentSchedulerTask.class);
    private int tenantId;
    private String tenantDomain;
    private boolean isInitialUpdateDone;
    private boolean isRepoUpdateFailed;
    private Integer iterationsForNextRepoUpdate;
    private AxisConfiguration axisConfig;

    public CarbonDeploymentSchedulerTask(RepositoryListener listener, AxisConfiguration axisConfig, int tenantId, String tenantDomain) {
        super(listener, axisConfig);
        this.tenantId = tenantId;
        this.tenantDomain = tenantDomain;
        this.axisConfig = axisConfig;
        this.iterationsForNextRepoUpdate = this.getIterationsNoForNextRepoUpdate();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Initial artifact repository update is set to " + this.iterationsForNextRepoUpdate + " iterations. tenant : " + tenantDomain));
        }
        try {
            axisConfig.addParameter(REPO_UPDATE_REQUIRED, (Object)new AtomicBoolean(false));
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Cannot add repo.update.required parameter");
        }
    }

    public synchronized void runAxisDeployment() {
        PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
        carbonContext.setTenantId(this.tenantId);
        carbonContext.setTenantDomain(this.tenantDomain);
        carbonContext.setApplicationName(null);
        super.run();
        if (GhostDeployerUtils.isGhostOn() && GhostDeployerUtils.isPartialUpdateEnabled() && CarbonUtils.isWorkerNode() && this.tenantId > 0) {
            this.doInitialGhostArtifactDeployement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialGhostArtifactDeployement() {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(GhostMetaArtifactsLoader.class.getName());
        if (reference != null) {
            try (ServiceTracker serviceTracker = new ServiceTracker(bundleContext, GhostMetaArtifactsLoader.class.getName(), null);){
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    GhostMetaArtifactsLoader artifactsLoader = (GhostMetaArtifactsLoader)obj;
                    if (log.isDebugEnabled()) {
                        if (artifactsLoader.getClass().toString().contains("Service")) {
                            log.debug((Object)("Loading ghost service meta artifacts for tenant: " + this.tenantDomain));
                        } else if (artifactsLoader.getClass().toString().contains("Webapp")) {
                            log.debug((Object)("Loading ghost webapp meta artifacts for tenant: " + this.tenantDomain));
                        }
                    }
                    artifactsLoader.loadArtifacts(this.axisConfig, this.tenantDomain);
                }
            }
        }
    }

    public synchronized void run() {
        try {
            boolean isRepoChanged;
            PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
            carbonContext.setTenantId(this.tenantId);
            carbonContext.setTenantDomain(this.tenantDomain);
            carbonContext.setApplicationName(null);
            this.deploymentSyncUpdate();
            this.runAxisDeployment();
            if (!CarbonUtils.isWorkerNode() && (isRepoChanged = this.deploymentSyncCommit())) {
                this.sendRepositorySyncMessage();
            }
        }
        catch (Throwable t) {
            log.error((Object)"Error while running deployment scheduler.. ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deploymentSyncUpdate() {
        BundleContext bundleContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running deployment synchronizer update... tenant : " + this.tenantDomain));
        }
        if ((bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext()) == null) {
            return;
        }
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            try (ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);){
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    DeploymentSynchronizer depsync = (DeploymentSynchronizer)obj;
                    boolean repoUpdateRequired = this.isRepoUpdateRequired();
                    if (this.isInitialUpdateDone && !this.isRepoUpdateFailed && !repoUpdateRequired) continue;
                    if (GhostDeployerUtils.isGhostOn() && GhostDeployerUtils.isPartialUpdateEnabled() && CarbonUtils.isWorkerNode() && this.tenantId > 0 && repoUpdateRequired) {
                        String repoPath = MultitenantUtils.getAxis2RepositoryPath((int)this.tenantId);
                        depsync.update(repoPath, repoPath, 3);
                    } else {
                        depsync.update(this.tenantId);
                    }
                    this.isInitialUpdateDone = true;
                    this.isRepoUpdateFailed = false;
                }
            }
        }
    }

    private boolean isRepoUpdateRequired() {
        AtomicBoolean value = (AtomicBoolean)this.axisConfig.getParameter(REPO_UPDATE_REQUIRED).getValue();
        boolean updateRequired = value.compareAndSet(true, false);
        Integer n = this.iterationsForNextRepoUpdate;
        Integer n2 = this.iterationsForNextRepoUpdate = Integer.valueOf(this.iterationsForNextRepoUpdate - 1);
        if (n <= 0) {
            updateRequired = true;
            this.iterationsForNextRepoUpdate = this.getIterationsNoForNextRepoUpdate();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Triggering the mandatory artifact synchronization. Next sync is in " + this.iterationsForNextRepoUpdate + " iterations. tenant : " + this.tenantDomain));
            }
        }
        return updateRequired;
    }

    private int getIterationsNoForNextRepoUpdate() {
        int repoUpdateMinSeconds;
        int deploymentInterval = this.getParsedServerConfig("Axis2Config.DeploymentUpdateInterval", DEPLOYMENT_INTERVAL);
        int repoUpdateMaxSeconds = this.getParsedServerConfig("DeploymentSynchronizer.MandatoryRepositoryUpdateInterval", REPO_UPDATE_MAX_TIME_SECONDS);
        if (repoUpdateMaxSeconds <= (repoUpdateMinSeconds = REPO_UPDATE_MIN_TIME_SECONDS.intValue())) {
            repoUpdateMaxSeconds = REPO_UPDATE_MAX_TIME_SECONDS;
            log.warn((Object)("Artifact synchronization MandatoryRepositoryUpdateInterval should be greater than " + REPO_UPDATE_MIN_TIME_SECONDS + " seconds.Defaulting to " + REPO_UPDATE_MAX_TIME_SECONDS + " seconds."));
        }
        int wigglePeriod = repoUpdateMaxSeconds - repoUpdateMinSeconds;
        double nextUpdateInSeconds = repoUpdateMinSeconds + new Random().nextInt(wigglePeriod);
        return (int)Math.ceil(nextUpdateInSeconds / (double)deploymentInterval);
    }

    private int getParsedServerConfig(String key, int defaultValue) {
        ServerConfigurationService serverConfiguration = CarbonCoreDataHolder.getInstance().getServerConfigurationService();
        String valueString = serverConfiguration.getFirstProperty(key);
        int value = defaultValue;
        if (valueString != null) {
            value = Integer.parseInt(valueString);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deploymentSyncCommit() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Running deployment synchronizer commit... tenant : " + this.tenantDomain));
        }
        boolean isFilesCommitted = false;
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        ServiceReference reference = bundleContext.getServiceReference(DeploymentSynchronizer.class.getName());
        if (reference != null) {
            try (ServiceTracker serviceTracker = new ServiceTracker(bundleContext, DeploymentSynchronizer.class.getName(), null);){
                serviceTracker.open();
                for (Object obj : serviceTracker.getServices()) {
                    DeploymentSynchronizer depsync = (DeploymentSynchronizer)obj;
                    isFilesCommitted = depsync.commit(this.tenantId);
                    if (!isFilesCommitted) continue;
                    break;
                }
            }
        }
        return isFilesCommitted;
    }

    private void sendRepositorySyncMessage() {
        ClusteringAgent clusteringAgent = CarbonCoreDataHolder.getInstance().getMainServerConfigContext().getAxisConfiguration().getClusteringAgent();
        if (clusteringAgent != null) {
            int numberOfRetries = 0;
            SynchronizeRepositoryRequest request = new SynchronizeRepositoryRequest(this.tenantId, this.tenantDomain);
            while (numberOfRetries < 60) {
                try {
                    clusteringAgent.sendMessage((ClusteringMessage)request, true);
                    log.info((Object)("Sent [" + (Object)((Object)request) + "]"));
                    break;
                }
                catch (ClusteringFault e) {
                    if (++numberOfRetries < 60) {
                        log.warn((Object)("Could not send SynchronizeRepositoryRequest for tenant " + this.tenantId + ". Retry will be attempted in 2s. Request: " + (Object)((Object)request)), (Throwable)e);
                    } else {
                        log.error((Object)("Could not send SynchronizeRepositoryRequest for tenant " + this.tenantId + ". Several retries failed. Request:" + (Object)((Object)request)), (Throwable)e);
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public void setRepoUpdateFailed() {
        this.isRepoUpdateFailed = true;
    }
}

