/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.multicast;

import com.hazelcast.config.MulticastConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;
import org.wso2.carbon.core.clustering.hazelcast.util.MemberUtils;

public class MulticastBasedMembershipScheme
implements HazelcastMembershipScheme {
    private static final Log log = LogFactory.getLog(MulticastBasedMembershipScheme.class);
    private final Map<String, Parameter> parameters;
    private String primaryDomain;
    private MulticastConfig config;
    private final List<ClusteringMessage> messageBuffer;
    private HazelcastCarbonClusterImpl carbonCluster;
    private HazelcastInstance primaryHazelcastInstance;

    public MulticastBasedMembershipScheme(Map<String, Parameter> parameters, String primaryDomain, MulticastConfig config, List<ClusteringMessage> messageBuffer) {
        this.parameters = parameters;
        this.primaryDomain = primaryDomain;
        this.config = config;
        this.messageBuffer = messageBuffer;
    }

    public void init() throws ClusteringFault {
        this.config.setEnabled(true);
        this.configureMulticastParameters();
    }

    private void configureMulticastParameters() throws ClusteringFault {
        Parameter mcastTTL;
        Parameter mcastTimeout;
        Parameter mcastPort;
        Parameter mcastAddress = this.getParameter("mcastAddress");
        if (mcastAddress != null) {
            this.config.setMulticastGroup((String)mcastAddress.getValue());
        }
        if ((mcastPort = this.getParameter("mcastPort")) != null) {
            this.config.setMulticastPort(Integer.parseInt(((String)mcastPort.getValue()).trim()));
        }
        if ((mcastTimeout = this.getParameter("mcastTimeout")) != null) {
            this.config.setMulticastTimeoutSeconds(Integer.parseInt(((String)mcastTimeout.getValue()).trim()));
        }
        if ((mcastTTL = this.getParameter("mcastTTL")) != null) {
            this.config.setMulticastTimeToLive(Integer.parseInt(((String)mcastTTL.getValue()).trim()));
        }
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    public void joinGroup() throws ClusteringFault {
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new MulticastMembershipListener());
    }

    @Override
    public void setPrimaryHazelcastInstance(HazelcastInstance primaryHazelcastInstance) {
        this.primaryHazelcastInstance = primaryHazelcastInstance;
    }

    @Override
    public void setLocalMember(Member localMember) {
    }

    @Override
    public void setCarbonCluster(HazelcastCarbonClusterImpl hazelcastCarbonCluster) {
        this.carbonCluster = hazelcastCarbonCluster;
    }

    private class MulticastMembershipListener
    implements MembershipListener {
        private Map<String, org.apache.axis2.clustering.Member> members;

        public MulticastMembershipListener() {
            this.members = MemberUtils.getMembersMap(MulticastBasedMembershipScheme.this.primaryHazelcastInstance, MulticastBasedMembershipScheme.this.primaryDomain);
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            MulticastBasedMembershipScheme.this.carbonCluster.memberAdded(member);
            log.info((Object)("Member joined [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HazelcastUtil.sendMessagesToMember(MulticastBasedMembershipScheme.this.messageBuffer, member, MulticastBasedMembershipScheme.this.carbonCluster);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            MulticastBasedMembershipScheme.this.carbonCluster.memberRemoved(member);
            log.info((Object)("Member left [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            this.members.remove(member.getUuid());
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

