/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.general;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;
import org.wso2.carbon.core.clustering.hazelcast.multicast.MulticastBasedMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.util.MemberUtils;

public class GeneralMembershipScheme
implements HazelcastMembershipScheme {
    private static final Log log = LogFactory.getLog(MulticastBasedMembershipScheme.class);
    private String primaryDomain;
    private final List<ClusteringMessage> messageBuffer;
    private HazelcastCarbonClusterImpl carbonCluster;
    private HazelcastInstance primaryHazelcastInstance;

    public GeneralMembershipScheme(String primaryDomain, List<ClusteringMessage> messageBuffer) {
        this.primaryDomain = primaryDomain;
        this.messageBuffer = messageBuffer;
    }

    public void init() throws ClusteringFault {
    }

    public void joinGroup() throws ClusteringFault {
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new GeneralMembershipListener());
    }

    @Override
    public void setPrimaryHazelcastInstance(HazelcastInstance primaryHazelcastInstance) {
        this.primaryHazelcastInstance = primaryHazelcastInstance;
    }

    @Override
    public void setLocalMember(Member localMember) {
    }

    @Override
    public void setCarbonCluster(HazelcastCarbonClusterImpl hazelcastCarbonCluster) {
        this.carbonCluster = hazelcastCarbonCluster;
    }

    private class GeneralMembershipListener
    implements MembershipListener {
        private Map<String, org.apache.axis2.clustering.Member> members;

        public GeneralMembershipListener() {
            this.members = MemberUtils.getMembersMap(GeneralMembershipScheme.this.primaryHazelcastInstance, GeneralMembershipScheme.this.primaryDomain);
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            GeneralMembershipScheme.this.carbonCluster.memberAdded(member);
            log.info((Object)("Member joined [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HazelcastUtil.sendMessagesToMember(GeneralMembershipScheme.this.messageBuffer, member, GeneralMembershipScheme.this.carbonCluster);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            GeneralMembershipScheme.this.carbonCluster.memberRemoved(member);
            log.info((Object)("Member left [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            this.members.remove(member.getUuid());
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

