/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.aws;

import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.description.Parameter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.aws.AWSBasedMembershipScheme;

public class AWSECSBasedMembershipScheme
extends AWSBasedMembershipScheme {
    private static final Log log = LogFactory.getLog(AWSECSBasedMembershipScheme.class);

    public AWSECSBasedMembershipScheme(Map<String, Parameter> parameters, String primaryDomain, Config config, HazelcastInstance primaryHazelcastInstance, List<ClusteringMessage> messageBuffer) {
        super(parameters, primaryDomain, config, primaryHazelcastInstance, messageBuffer);
    }

    @Override
    public void init() throws ClusteringFault {
        super.init();
        Parameter networkInterface = this.getParameter("networkInterface");
        if (networkInterface == null) {
            throw new ClusteringFault("Required parameter for AWS ECS membership scheme: networkInterface is not defined");
        }
        this.getNetworkConfig().getInterfaces().setEnabled(true).addInterface(((String)networkInterface.getValue()).trim());
        if (log.isDebugEnabled()) {
            log.debug((Object)("\"" + networkInterface + "\" has been set set as the networkInterface for AWS ECS membership scheme."));
        }
        this.getNetworkConfig().getJoin().getMulticastConfig().setEnabled(false);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Multicast configuration has been disabled for AWS ECS membership scheme.");
        }
        this.getNetworkConfig().setPublicAddress(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Public address has been unset for AWS ECS membership scheme.");
        }
    }
}

