/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast.aws;

import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.Config;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastUtil;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.xml.StringUtils;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class AWSBasedMembershipScheme
implements HazelcastMembershipScheme {
    private static final Log log = LogFactory.getLog(AWSBasedMembershipScheme.class);
    public static final String SECURE_VAULT_ACCESS_KEY = "Axis2.clustering.aws.accessKey";
    public static final String SECURE_VAULT_SECRET_KEY = "Axis2.clustering.aws.secretKey";
    private final Map<String, Parameter> parameters;
    private final String primaryDomain;
    private final NetworkConfig networkConfig;
    private HazelcastInstance primaryHazelcastInstance;
    private final List<ClusteringMessage> messageBuffer;
    private HazelcastCarbonClusterImpl carbonCluster;

    public AWSBasedMembershipScheme(Map<String, Parameter> parameters, String primaryDomain, Config config, HazelcastInstance primaryHazelcastInstance, List<ClusteringMessage> messageBuffer) {
        this.parameters = parameters;
        this.primaryDomain = primaryDomain;
        this.primaryHazelcastInstance = primaryHazelcastInstance;
        this.messageBuffer = messageBuffer;
        this.networkConfig = config.getNetworkConfig();
    }

    protected NetworkConfig getNetworkConfig() {
        return this.networkConfig;
    }

    @Override
    public void setCarbonCluster(HazelcastCarbonClusterImpl hazelcastCarbonCluster) {
        this.carbonCluster = hazelcastCarbonCluster;
    }

    @Override
    public void setPrimaryHazelcastInstance(HazelcastInstance primaryHazelcastInstance) {
        this.primaryHazelcastInstance = primaryHazelcastInstance;
    }

    @Override
    public void setLocalMember(Member localMember) {
    }

    public void init() throws ClusteringFault {
        String resolvedValue;
        this.networkConfig.getJoin().getMulticastConfig().setEnabled(false);
        this.networkConfig.getJoin().getTcpIpConfig().setEnabled(false);
        AwsConfig awsConfig = this.networkConfig.getJoin().getAwsConfig();
        awsConfig.setEnabled(true);
        Parameter accessKey = this.getParameter("accessKey");
        Parameter secretKey = this.getParameter("secretKey");
        Parameter iamRole = this.getParameter("iamRole");
        Parameter securityGroup = this.getParameter("securityGroup");
        Parameter connTimeout = this.getParameter("connTimeout");
        Parameter hostHeader = this.getParameter("hostHeader");
        Parameter region = this.getParameter("region");
        Parameter tagKey = this.getParameter("tagKey");
        Parameter tagValue = this.getParameter("tagValue");
        SecretResolver secretResolver = this.getAxis2SecretResolver();
        if (accessKey != null) {
            if (secretResolver != null) {
                resolvedValue = MiscellaneousUtil.resolve((OMElement)accessKey.getParameterElement(), (SecretResolver)secretResolver);
                if (!StringUtils.isEmpty((String)resolvedValue)) {
                    awsConfig.setAccessKey(resolvedValue);
                }
            } else {
                awsConfig.setAccessKey(((String)accessKey.getValue()).trim());
            }
        }
        if (secretKey != null) {
            if (secretResolver != null) {
                resolvedValue = MiscellaneousUtil.resolve((OMElement)secretKey.getParameterElement(), (SecretResolver)secretResolver);
                if (!StringUtils.isEmpty((String)resolvedValue)) {
                    awsConfig.setSecretKey(resolvedValue);
                }
            } else {
                awsConfig.setSecretKey(((String)secretKey.getValue()).trim());
            }
        }
        if (iamRole != null) {
            awsConfig.setIamRole(((String)iamRole.getValue()).trim());
        }
        if (securityGroup != null) {
            awsConfig.setSecurityGroupName(((String)securityGroup.getValue()).trim());
        }
        if (connTimeout != null) {
            awsConfig.setConnectionTimeoutSeconds(Integer.parseInt(((String)connTimeout.getValue()).trim()));
        }
        if (hostHeader != null) {
            awsConfig.setHostHeader(((String)hostHeader.getValue()).trim());
        }
        if (region != null) {
            awsConfig.setRegion(((String)region.getValue()).trim());
        }
        if (tagKey != null) {
            awsConfig.setTagKey(((String)tagKey.getValue()).trim());
        }
        if (tagValue != null) {
            awsConfig.setTagValue(((String)tagValue.getValue()).trim());
        }
    }

    public void joinGroup() throws ClusteringFault {
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new AWSMembershipListener());
    }

    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SecretResolver getAxis2SecretResolver() {
        String axis2xml = CarbonUtils.getAxis2Xml();
        InputStream axis2XmlInputStream = null;
        try {
            axis2XmlInputStream = this.getAxis2XmlInputStream(axis2xml);
            OMElement element = (OMElement)XMLUtils.toOM((InputStream)axis2XmlInputStream);
            element.build();
            SecretResolver secretResolver = SecretResolverFactory.create((OMElement)element, (boolean)false);
            return secretResolver;
        }
        catch (IOException | XMLStreamException e) {
            log.error((Object)"Unable to read Axis2.xml", (Throwable)e);
        }
        finally {
            if (axis2XmlInputStream != null) {
                try {
                    axis2XmlInputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)"Unable to close the Axis2.xml input stream", (Throwable)e);
                }
            }
        }
        return null;
    }

    private InputStream getAxis2XmlInputStream(String axis2xml) throws IOException {
        if (axis2xml != null && axis2xml.trim().length() != 0) {
            if (CarbonUtils.isURL((String)axis2xml)) {
                return new URL(axis2xml).openStream();
            }
            return new FileInputStream(axis2xml);
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl.getResourceAsStream("org/apache/axis2/deployment/axis2_default.xml");
    }

    private class AWSMembershipListener
    implements MembershipListener {
        private AWSMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            AWSBasedMembershipScheme.this.carbonCluster.memberAdded(member);
            log.info((Object)("Member joined [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            HazelcastUtil.sendMessagesToMember(AWSBasedMembershipScheme.this.messageBuffer, member, AWSBasedMembershipScheme.this.carbonCluster);
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            Member member = membershipEvent.getMember();
            AWSBasedMembershipScheme.this.carbonCluster.memberRemoved(member);
            log.info((Object)("Member left [" + member.getUuid() + "]: " + member.getInetSocketAddress().toString()));
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }
}

