/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdempotentWrappedClusteringMessage<T extends ClusteringMessage>
extends ClusteringMessage
implements Externalizable {
    private static final transient Log log = LogFactory.getLog(IdempotentWrappedClusteringMessage.class);
    private static final long serialVersionUID = 95L;
    private T wrappedMessage;
    private String clusterNodeId;

    private IdempotentWrappedClusteringMessage() {
    }

    public IdempotentWrappedClusteringMessage(T wrappedMessage) {
        this.wrappedMessage = wrappedMessage;
    }

    public void execute(ConfigurationContext configurationContext) throws ClusteringFault {
        this.wrappedMessage.execute(configurationContext);
    }

    public ClusteringCommand getResponse() {
        return this.wrappedMessage.getResponse();
    }

    public void setClusterNodeId(String clusterNodeId) {
        this.clusterNodeId = clusterNodeId;
    }

    public String getClusterNodeId() {
        return this.clusterNodeId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.wrappedMessage);
        byte[] clusterNodeIdBytes = this.clusterNodeId.getBytes(StandardCharsets.ISO_8859_1);
        out.writeInt(clusterNodeIdBytes.length);
        out.write(clusterNodeIdBytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.wrappedMessage = (ClusteringMessage)in.readObject();
        int clusterNodeIdSize = in.readInt();
        byte[] clusterNodeIdBytes = new byte[clusterNodeIdSize];
        in.read(clusterNodeIdBytes);
        this.clusterNodeId = new String(clusterNodeIdBytes, StandardCharsets.ISO_8859_1);
    }
}

