/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.clustering.hazelcast.IdempotentWrappedClusteringMessage;

public class HazelcastIdempotentClusterMessageListener
implements MessageListener<IdempotentWrappedClusteringMessage> {
    private static final Log log = LogFactory.getLog(HazelcastIdempotentClusterMessageListener.class);
    private ConfigurationContext configurationContext;
    private String nodeId;

    public HazelcastIdempotentClusterMessageListener(ConfigurationContext configurationContext, String nodeId) {
        this.configurationContext = configurationContext;
        this.nodeId = nodeId;
    }

    public void onMessage(Message<IdempotentWrappedClusteringMessage> clusteringMessage) {
        try {
            ClusteringMessage msg = (ClusteringMessage)clusteringMessage.getMessageObject();
            if (msg instanceof IdempotentWrappedClusteringMessage) {
                IdempotentWrappedClusteringMessage idempotentWrappedClusteringMessage = (IdempotentWrappedClusteringMessage)msg;
                if (this.nodeId != null && !this.nodeId.equals(idempotentWrappedClusteringMessage.getClusterNodeId())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Received Cache invalidation message: " + msg));
                    }
                    msg.execute(this.configurationContext);
                }
            }
        }
        catch (ClusteringFault e) {
            log.error((Object)"Cannot process ClusteringMessage", (Throwable)e);
        }
    }
}

