/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.caching.impl.MapEntryListener;

public class HazelcastDistributedMapProvider
implements DistributedMapProvider {
    private static final Log log = LogFactory.getLog(HazelcastDistributedMapProvider.class);
    private HazelcastInstance hazelcastInstance;
    private Map<String, DistMap> maps = new HashMap<String, DistMap>();

    public HazelcastDistributedMapProvider(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public <K, V> Map<K, V> getMap(String mapName, MapEntryListener entryListener) {
        DistMap map = this.maps.get(mapName);
        if (map == null) {
            map = new DistMap(mapName, entryListener);
            this.maps.put(mapName, map);
        }
        return map;
    }

    public void removeMap(String mapName) {
        DistMap map = this.maps.get(mapName);
        try {
            if (map != null) {
                this.hazelcastInstance.getMap(mapName).removeEntryListener(map.getListenerId());
            }
            this.maps.remove(mapName);
        }
        catch (HazelcastException e) {
            log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
        }
    }

    private class DistMap<K, V>
    implements Map<K, V> {
        private IMap<K, V> map;
        private String listenerId;

        public DistMap(String mapName, final MapEntryListener entryListener) {
            try {
                this.map = HazelcastDistributedMapProvider.this.hazelcastInstance.getMap(mapName);
                if (entryListener != null) {
                    this.listenerId = this.map.addEntryListener(new EntryListener<K, V>(){

                        public void entryAdded(EntryEvent<K, V> kvEntryEvent) {
                            if (!kvEntryEvent.getMember().equals(HazelcastDistributedMapProvider.this.hazelcastInstance.getCluster().getLocalMember())) {
                                entryListener.entryAdded(kvEntryEvent.getKey());
                            }
                        }

                        public void entryRemoved(EntryEvent<K, V> kvEntryEvent) {
                            if (!kvEntryEvent.getMember().equals(HazelcastDistributedMapProvider.this.hazelcastInstance.getCluster().getLocalMember())) {
                                entryListener.entryRemoved(kvEntryEvent.getKey());
                            }
                        }

                        public void entryUpdated(EntryEvent<K, V> kvEntryEvent) {
                            if (!kvEntryEvent.getMember().equals(HazelcastDistributedMapProvider.this.hazelcastInstance.getCluster().getLocalMember())) {
                                entryListener.entryUpdated(kvEntryEvent.getKey());
                            }
                        }

                        public void entryEvicted(EntryEvent<K, V> kvEntryEvent) {
                            if (!kvEntryEvent.getMember().equals(HazelcastDistributedMapProvider.this.hazelcastInstance.getCluster().getLocalMember())) {
                                entryListener.entryRemoved(kvEntryEvent.getKey());
                            }
                        }

                        public void mapEvicted(MapEvent mapEvent) {
                            DistMap.this.map.evictAll();
                        }

                        public void mapCleared(MapEvent mapEvent) {
                            if (!mapEvent.getMember().equals(HazelcastDistributedMapProvider.this.hazelcastInstance.getCluster().getLocalMember())) {
                                entryListener.mapCleared();
                            }
                        }
                    }, false);
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
        }

        @Override
        public int size() {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    return this.map.size();
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return 0;
        }

        @Override
        public boolean isEmpty() {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    return this.map.isEmpty();
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                return HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning() && this.map.containsKey(key);
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
                return false;
            }
        }

        @Override
        public boolean containsValue(Object value) {
            try {
                return HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning() && this.map.containsValue(value);
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
                return false;
            }
        }

        @Override
        public V get(Object key) {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    return (V)this.map.get(key);
                }
            }
            catch (HazelcastException | NullPointerException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", e);
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    this.map.set(key, value);
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return value;
        }

        @Override
        public V remove(Object key) {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    this.map.remove(key);
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    this.map.putAll(m);
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
        }

        @Override
        public void clear() {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    this.map.clear();
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
        }

        @Override
        public Set<K> keySet() {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    return this.map.keySet();
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return new LinkedHashSet();
        }

        @Override
        public Collection<V> values() {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    return this.map.values();
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return new ArrayList();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            try {
                if (HazelcastDistributedMapProvider.this.hazelcastInstance.getLifecycleService().isRunning()) {
                    return this.map.entrySet();
                }
            }
            catch (HazelcastException e) {
                log.warn((Object)"Cache lookup failed. Falling back to normal path.", (Throwable)e);
            }
            return new LinkedHashSet<Map.Entry<K, V>>();
        }

        public String getListenerId() {
            return this.listenerId;
        }
    }
}

