/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.clustering.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MemberAttributeConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ILock;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.DefaultGroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementCommand;
import org.apache.axis2.clustering.management.NodeManager;
import org.apache.axis2.clustering.state.StateManager;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.base.api.IdempotentMessage;
import org.wso2.carbon.caching.impl.DistributedMapProvider;
import org.wso2.carbon.core.CarbonThreadFactory;
import org.wso2.carbon.core.ServerStatus;
import org.wso2.carbon.core.clustering.api.CarbonCluster;
import org.wso2.carbon.core.clustering.api.ClusterMessage;
import org.wso2.carbon.core.clustering.api.CoordinatedActivity;
import org.wso2.carbon.core.clustering.hazelcast.GroupManagementCommandListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastCarbonClusterImpl;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastClusterMessageListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastControlCommandListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastDistributedMapProvider;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastGroupManagementAgent;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastIdempotentClusterMessageListener;
import org.wso2.carbon.core.clustering.hazelcast.HazelcastMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.IdempotentWrappedClusteringMessage;
import org.wso2.carbon.core.clustering.hazelcast.ParameterAdapter;
import org.wso2.carbon.core.clustering.hazelcast.aws.AWSBasedMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.aws.AWSECSBasedMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.general.GeneralMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.multicast.MulticastBasedMembershipScheme;
import org.wso2.carbon.core.clustering.hazelcast.util.MemberUtils;
import org.wso2.carbon.core.clustering.hazelcast.wka.WKABasedMembershipScheme;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.utils.CarbonUtils;

public class HazelcastClusteringAgent
extends ParameterAdapter
implements ClusteringAgent {
    private static final Log log = LogFactory.getLog(HazelcastClusteringAgent.class);
    private static final String MEMBERSHIP_SCHEME_CLASS_NAME = "membershipSchemeClassName";
    public static final String DEFAULT_SUB_DOMAIN = "__$default";
    private static final int CONFIG_MODE_FILE = 0;
    private static final int CONFIG_MODE_SYSPROP = 1;
    private static final int CONFIG_MODE_AXIS2 = 2;
    private static final Path DEFAULT_CONFIG_FILE_PATH;
    private Config primaryHazelcastConfig;
    private HazelcastInstance primaryHazelcastInstance;
    private HazelcastMembershipScheme membershipScheme;
    private ConfigurationContext configurationContext;
    private ITopic<ClusteringMessage> clusteringMessageTopic;
    private ITopic<IdempotentWrappedClusteringMessage> idempotentNonReliableMessageTopic;
    private ITopic<GroupManagementCommand> groupManagementTopic;
    private List<ClusteringMessage> sentMsgsBuffer = new CopyOnWriteArrayList<ClusteringMessage>();
    private Map<String, Long> recdMsgsBuffer = new ConcurrentHashMap<String, Long>();
    private List<Member> wkaMembers;
    private final Map<String, Map<String, GroupManagementAgent>> groupManagementAgents = new HashMap<String, Map<String, GroupManagementAgent>>();
    private boolean clusterManagementMode;
    private String primaryDomain;
    private boolean isCoordinator;
    private static final String LOCAL_MEMBER_IDENTIFIER = "localMemberIdentifier";
    private HazelcastDistributedMapProvider distributedMapProvider;
    private HazelcastCarbonClusterImpl hazelcastCarbonCluster;
    private ScheduledExecutorService msgCleanupScheduler;
    private String clusterNodeId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ClusteringFault {
        MemberUtils.init(this.parameters, this.configurationContext);
        this.primaryDomain = this.getClusterDomain();
        log.info((Object)("Cluster domain: " + this.primaryDomain));
        int configMode = this.getConfigMode();
        this.primaryHazelcastConfig = this.loadHazelcastConfig(configMode);
        Parameter localParameter = this.getParameter(LOCAL_MEMBER_IDENTIFIER);
        if (localParameter != null) {
            MemberAttributeConfig memberAttributeConfig = new MemberAttributeConfig();
            memberAttributeConfig.setStringAttribute(localParameter.getName(), localParameter.getValue().toString());
            this.primaryHazelcastConfig.setMemberAttributeConfig(memberAttributeConfig);
        }
        if (this.clusterManagementMode) {
            for (Map.Entry entry : this.groupManagementAgents.entrySet()) {
                for (GroupManagementAgent agent : ((Map)entry.getValue()).values()) {
                    if (!(agent instanceof HazelcastGroupManagementAgent)) continue;
                    ((HazelcastGroupManagementAgent)agent).init(this.primaryHazelcastConfig, this.configurationContext);
                }
            }
        }
        long start = System.currentTimeMillis();
        log.info((Object)"Hazelcast cluster is initializing...");
        this.primaryHazelcastInstance = Hazelcast.newHazelcastInstance((Config)this.primaryHazelcastConfig);
        log.info((Object)("Hazelcast initialized in " + (System.currentTimeMillis() - start) + "ms"));
        this.hazelcastCarbonCluster = new HazelcastCarbonClusterImpl(this.primaryHazelcastInstance);
        this.clusterNodeId = this.generateLocalNodeId(this.primaryHazelcastInstance);
        this.clusteringMessageTopic = this.primaryHazelcastInstance.getTopic("$clustering.message.topic");
        this.clusteringMessageTopic.addMessageListener((MessageListener)new HazelcastClusterMessageListener(this.configurationContext, this.recdMsgsBuffer, this.sentMsgsBuffer));
        this.idempotentNonReliableMessageTopic = this.primaryHazelcastInstance.getTopic("$carbon.idempotent.message.topic");
        HazelcastIdempotentClusterMessageListener idempotentClusterMessageListener = new HazelcastIdempotentClusterMessageListener(this.configurationContext, this.clusterNodeId);
        this.idempotentNonReliableMessageTopic.addMessageListener((MessageListener)idempotentClusterMessageListener);
        this.groupManagementTopic = this.primaryHazelcastInstance.getTopic(".group.mgt.cmd.topic");
        this.groupManagementTopic.addMessageListener((MessageListener)new GroupManagementCommandListener(this.configurationContext));
        ITopic controlCommandTopic = this.primaryHazelcastInstance.getTopic("$control.$command.$topic");
        controlCommandTopic.addMessageListener((MessageListener)new HazelcastControlCommandListener(this.configurationContext));
        com.hazelcast.core.Member localMember = this.primaryHazelcastInstance.getCluster().getLocalMember();
        if (configMode == 2) {
            this.membershipScheme.setPrimaryHazelcastInstance(this.primaryHazelcastInstance);
            this.membershipScheme.setCarbonCluster(this.hazelcastCarbonCluster);
            this.membershipScheme.setLocalMember(localMember);
            this.membershipScheme.joinGroup();
        } else {
            this.membershipScheme = new GeneralMembershipScheme(this.primaryDomain, this.sentMsgsBuffer);
            this.membershipScheme.setPrimaryHazelcastInstance(this.primaryHazelcastInstance);
            this.membershipScheme.setCarbonCluster(this.hazelcastCarbonCluster);
            this.membershipScheme.joinGroup();
        }
        localMember = this.primaryHazelcastInstance.getCluster().getLocalMember();
        localMember.getInetSocketAddress().getPort();
        Member carbonLocalMember = MemberUtils.getLocalMember(this.primaryDomain, localMember.getInetSocketAddress().getAddress().getHostAddress(), localMember.getInetSocketAddress().getPort());
        log.info((Object)("Local member: [" + localMember.getUuid() + "] - " + carbonLocalMember));
        ITopic replayedMsgs = this.primaryHazelcastInstance.getTopic("$ReplayMessageQueue:" + localMember.getUuid());
        replayedMsgs.addMessageListener((MessageListener)new MessageListener<ClusterMessage>(){

            public void onMessage(Message<ClusterMessage> clusterMessage) {
                ClusterMessage msg = (ClusterMessage)clusterMessage.getMessageObject();
                if (!HazelcastClusteringAgent.this.recdMsgsBuffer.containsKey(msg.getUuid())) {
                    log.info((Object)("Received replayed message: " + msg.getUuid()));
                    msg.execute();
                    HazelcastClusteringAgent.this.recdMsgsBuffer.put(msg.getUuid(), System.currentTimeMillis());
                }
            }
        });
        if (carbonLocalMember.getProperties().get("subDomain") == null) {
            carbonLocalMember.getProperties().put("subDomain", DEFAULT_SUB_DOMAIN);
        }
        MemberUtils.getMembersMap(this.primaryHazelcastInstance, this.primaryDomain).put((Object)localMember.getUuid(), (Object)carbonLocalMember);
        this.primaryHazelcastInstance.getCluster().addMembershipListener((MembershipListener)new CoordinatorElectionMembershipListener());
        ILock lock = this.primaryHazelcastInstance.getLock("$coordinator#@lock");
        try {
            log.debug((Object)"Trying to get the CLUSTER_COORDINATOR_LOCK lock.");
            lock.lock();
            log.debug((Object)"Acquired the CLUSTER_COORDINATOR_LOCK lock.");
            com.hazelcast.core.Member oldestMember = (com.hazelcast.core.Member)this.primaryHazelcastInstance.getCluster().getMembers().iterator().next();
            if (oldestMember.localMember() && !this.isCoordinator) {
                this.electCoordinatorNode();
            }
        }
        finally {
            lock.unlock();
            log.debug((Object)"Released the CLUSTER_COORDINATOR_LOCK lock.");
        }
        this.distributedMapProvider = new HazelcastDistributedMapProvider(this.primaryHazelcastInstance);
        this.registerOsgiServices();
        this.msgCleanupScheduler = Executors.newScheduledThreadPool(1, new CarbonThreadFactory(new ThreadGroup("ClusterMsgCleanupThread")));
        this.msgCleanupScheduler.scheduleWithFixedDelay(new ClusterMessageCleanupTask(), 2L, 2L, TimeUnit.MINUTES);
        log.info((Object)"Cluster initialization completed");
    }

    private String generateLocalNodeId(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance != null && hazelcastInstance.getCluster() != null && hazelcastInstance.getCluster().getLocalMember() != null) {
            return hazelcastInstance.getCluster().getLocalMember().getUuid();
        }
        return this.clusterNodeId != null ? this.clusterNodeId : UUID.randomUUID().toString();
    }

    public DistributedMapProvider getDistributedMapProvider() {
        return this.distributedMapProvider;
    }

    public HazelcastInstance getPrimaryHazelcastInstance() {
        return this.primaryHazelcastInstance;
    }

    public CarbonCluster getCarbonCluster() {
        return this.hazelcastCarbonCluster;
    }

    @Deprecated
    private void registerOsgiServices() {
        BundleContext bundleContext = CarbonCoreDataHolder.getInstance().getBundleContext();
        if (bundleContext == null) {
            return;
        }
        bundleContext.registerService(DistributedMapProvider.class, (Object)this.distributedMapProvider, null);
        bundleContext.registerService(HazelcastInstance.class, (Object)this.primaryHazelcastInstance, null);
        bundleContext.registerService(CarbonCluster.class, (Object)this.hazelcastCarbonCluster, null);
    }

    private Config createConfigForAxis2Mode() throws ClusteringFault {
        Parameter licenseKey;
        Config primaryHazelcastConfig = new Config();
        this.setHazelcastProperties(primaryHazelcastConfig);
        Parameter managementCenterURL = this.getParameter("mgtCenterURL");
        if (managementCenterURL != null) {
            primaryHazelcastConfig.getManagementCenterConfig().setEnabled(true).setUrl((String)managementCenterURL.getValue());
        }
        if ((licenseKey = this.getParameter("licenseKey")) != null) {
            primaryHazelcastConfig.setLicenseKey((String)licenseKey.getValue());
        }
        primaryHazelcastConfig.setInstanceName(this.primaryDomain + ".instance");
        GroupConfig groupConfig = primaryHazelcastConfig.getGroupConfig();
        groupConfig.setName(this.primaryDomain);
        Parameter memberPassword = this.getParameter("groupPassword");
        if (memberPassword != null) {
            groupConfig.setPassword((String)memberPassword.getValue());
        }
        NetworkConfig nwConfig = primaryHazelcastConfig.getNetworkConfig();
        Parameter localMemberHostParam = this.getParameter("localMemberHost");
        String localMemberHost = "";
        if (localMemberHostParam != null) {
            localMemberHost = ((String)localMemberHostParam.getValue()).trim();
            if ("127.0.0.1".equals(localMemberHost) || "localhost".equals(localMemberHost)) {
                log.warn((Object)"localMemberHost is configured to use the loopback address. Hazelcast Clustering needs ip addresses for localMemberHost and well-known members.");
            }
        } else {
            try {
                localMemberHost = Utils.getIpAddress();
            }
            catch (SocketException e) {
                log.error((Object)"Could not set local member host", (Throwable)e);
            }
        }
        nwConfig.setPublicAddress(localMemberHost);
        int localMemberPort = 4000;
        Parameter localMemberPortParam = this.getParameter("localMemberPort");
        if (localMemberPortParam != null) {
            localMemberPort = Integer.parseInt(((String)localMemberPortParam.getValue()).trim());
        }
        nwConfig.setPort(localMemberPort);
        this.configureMembershipScheme(nwConfig, primaryHazelcastConfig);
        MapConfig mapConfig = new MapConfig("carbon-map-config");
        mapConfig.setEvictionPolicy(MapConfig.DEFAULT_EVICTION_POLICY);
        if (licenseKey != null) {
            mapConfig.setInMemoryFormat(InMemoryFormat.BINARY);
        }
        primaryHazelcastConfig.addMapConfig(mapConfig);
        return primaryHazelcastConfig;
    }

    private Config loadHazelcastConfig(int configMode) throws ClusteringFault {
        Config primaryHazelcastConfig;
        if (configMode == 0) {
            log.info((Object)("Loading hazelcast configuration from default path: " + DEFAULT_CONFIG_FILE_PATH));
            try {
                primaryHazelcastConfig = new XmlConfigBuilder(DEFAULT_CONFIG_FILE_PATH.toFile().getPath()).build();
            }
            catch (FileNotFoundException e) {
                throw new ClusteringFault("File not found");
            }
            catch (HazelcastException e) {
                String msg = "Error while loading config";
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg);
            }
        } else if (configMode == 1) {
            String configPath = System.getProperty("hazelcast.config");
            log.info((Object)("Loading hazelcast configuration from system property, path: " + configPath));
            try {
                primaryHazelcastConfig = new XmlConfigBuilder(configPath).build();
            }
            catch (FileNotFoundException e) {
                String msg = "Error while building config from " + configPath;
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg);
            }
            catch (HazelcastException e) {
                String msg = "Error while loading config";
                log.error((Object)msg, (Throwable)e);
                throw new ClusteringFault(msg);
            }
        } else {
            log.info((Object)"Loading hazelcast configuration from axis2 clustering configuration");
            primaryHazelcastConfig = this.createConfigForAxis2Mode();
        }
        this.loadCustomHazelcastSerializers(primaryHazelcastConfig);
        return primaryHazelcastConfig;
    }

    private int getConfigMode() {
        if (Files.exists(DEFAULT_CONFIG_FILE_PATH, new LinkOption[0])) {
            return 0;
        }
        String configPath = System.getProperty("hazelcast.config");
        if (configPath != null) {
            return 1;
        }
        return 2;
    }

    private void electCoordinatorNode() {
        this.isCoordinator = true;
        log.info((Object)("Elected this member [" + this.primaryHazelcastInstance.getCluster().getLocalMember().getUuid() + "] as the Coordinator node"));
        List<CoordinatedActivity> coordinatedActivities = CarbonCoreDataHolder.getInstance().getCoordinatedActivities();
        for (CoordinatedActivity coordinatedActivity : coordinatedActivities) {
            coordinatedActivity.execute();
        }
        log.debug((Object)"Invoked all the coordinated activities after electing this member as the Coordinator");
    }

    private void loadCustomHazelcastSerializers(Config primaryHazelcastConfig) {
        Parameter hazelcastSerializers = this.getParameter("hazelcastSerializers");
        if (hazelcastSerializers == null) {
            return;
        }
        OMElement paramEle = hazelcastSerializers.getParameterElement();
        Iterator iter = paramEle.getChildrenWithLocalName("serializer");
        while (iter.hasNext()) {
            OMElement serializerEle = (OMElement)iter.next();
            OMAttribute typeClassAttrib = serializerEle.getAttribute(new QName("typeClass"));
            if (typeClassAttrib == null) continue;
            String typeClass = typeClassAttrib.getAttributeValue();
            String serializer = serializerEle.getText();
            try {
                Class<?> serializerClass = Class.forName(serializer);
                SerializerConfig serializerConfig = new SerializerConfig();
                Object serializerObj = serializerClass.newInstance();
                if (serializerObj instanceof StreamSerializer) {
                    serializerConfig.setImplementation((Serializer)((StreamSerializer)serializerObj));
                } else if (serializerObj instanceof ByteArraySerializer) {
                    serializerConfig.setImplementation((Serializer)((ByteArraySerializer)serializerObj));
                } else {
                    throw new IllegalArgumentException("Unknown Hazelcast serializer type: " + serializerObj.getClass());
                }
                serializerConfig.setTypeClass(Class.forName(typeClass));
                primaryHazelcastConfig.getSerializationConfig().addSerializerConfig(serializerConfig);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Cannot find Hazelcast serializer class " + serializer), (Throwable)e);
            }
            catch (InstantiationException e) {
                log.error((Object)("Cannot instantiate Hazelcast serializer class " + serializer), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)("Illegal access while trying to instantiate Hazelcast serializer class " + serializer), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHazelcastProperties(Config primaryHazelcastConfig) {
        String confPath = System.getProperty("carbon.config.dir.path");
        String hazelcastPropsFileName = confPath == null ? Paths.get(CarbonBaseUtils.getCarbonConfigDirPath(), "hazelcast.properties").toString() : Paths.get(confPath, "hazelcast.properties").toString();
        Properties hazelcastProperties = new Properties();
        hazelcastProperties.setProperty("hazelcast.max.no.heartbeat.seconds", "600");
        hazelcastProperties.setProperty("hazelcast.max.no.master.confirmation.seconds", "900");
        hazelcastProperties.setProperty("hazelcast.merge.first.run.delay.seconds", "60");
        hazelcastProperties.setProperty("hazelcast.merge.next.run.delay.seconds", "30");
        if (new File(hazelcastPropsFileName).exists()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(hazelcastPropsFileName);
                hazelcastProperties.load(fileInputStream);
            }
            catch (IOException e) {
                log.error((Object)("Cannot load properties from file " + hazelcastPropsFileName), (Throwable)e);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException e) {
                        log.error((Object)("Cannot close file " + hazelcastPropsFileName), (Throwable)e);
                    }
                }
            }
        }
        primaryHazelcastConfig.setProperties(hazelcastProperties);
    }

    private String getClusterDomain() {
        Parameter domainParam = this.getParameter("domain");
        String domain = domainParam != null ? (String)domainParam.getValue() : "apache.axis2.domain";
        return domain;
    }

    private void configureMembershipScheme(NetworkConfig nwConfig, Config primaryHazelcastConfig) throws ClusteringFault {
        String scheme = this.getMembershipScheme();
        log.info((Object)("Using " + scheme + " based membership management scheme"));
        if (scheme.equals("wka")) {
            this.membershipScheme = new WKABasedMembershipScheme(this.parameters, this.primaryDomain, this.wkaMembers, primaryHazelcastConfig, this.sentMsgsBuffer);
            this.membershipScheme.init();
        } else if (scheme.equals("multicast")) {
            this.membershipScheme = new MulticastBasedMembershipScheme(this.parameters, this.primaryDomain, nwConfig.getJoin().getMulticastConfig(), this.sentMsgsBuffer);
            this.membershipScheme.init();
        } else if (scheme.equals("aws")) {
            this.membershipScheme = new AWSBasedMembershipScheme(this.parameters, this.primaryDomain, primaryHazelcastConfig, this.primaryHazelcastInstance, this.sentMsgsBuffer);
            this.membershipScheme.init();
        } else if (scheme.equals("aws-ecs")) {
            this.membershipScheme = new AWSECSBasedMembershipScheme(this.parameters, this.primaryDomain, primaryHazelcastConfig, this.primaryHazelcastInstance, this.sentMsgsBuffer);
            this.membershipScheme.init();
        } else {
            Parameter classNameParameter = (Parameter)this.parameters.get(MEMBERSHIP_SCHEME_CLASS_NAME);
            if (classNameParameter != null) {
                this.initiateCustomMembershipScheme(classNameParameter, primaryHazelcastConfig);
            } else {
                String msg = "Invalid membership scheme '" + scheme + "'. Supported schemes are multicast & wka";
                log.error((Object)msg);
                throw new ClusteringFault(msg);
            }
        }
    }

    private void initiateCustomMembershipScheme(Parameter classNameParameter, Config primaryHazelcastConfig) throws ClusteringFault {
        String className = (String)classNameParameter.getValue();
        try {
            Class<?> membershipSchemeClass = Class.forName(className);
            try {
                this.membershipScheme = (HazelcastMembershipScheme)membershipSchemeClass.getConstructor(Map.class, String.class, Config.class, HazelcastInstance.class, List.class).newInstance(this.parameters, this.primaryDomain, primaryHazelcastConfig, this.primaryHazelcastInstance, this.sentMsgsBuffer);
                this.membershipScheme.init();
            }
            catch (InstantiationException e) {
                throw new ClusteringFault("Could not initiate membership scheme: " + className, (Exception)e);
            }
            catch (IllegalAccessException e) {
                throw new ClusteringFault("Constructor is not accessible in membership scheme: " + className, (Exception)e);
            }
            catch (InvocationTargetException e) {
                throw new ClusteringFault("Could not initiate membership scheme: " + className, (Exception)e);
            }
            catch (NoSuchMethodException e) {
                throw new ClusteringFault("Constructor with parameters Map<String, Parameter> parameters, String primaryDomain, Config config, HazelcastInstance primaryHazelcastInstance, List<ClusteringMessage> messageBuffer not found in membership scheme: " + className, (Exception)e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ClusteringFault("Membership scheme class not found: " + className, (Exception)e);
        }
    }

    private String getMembershipScheme() throws ClusteringFault {
        Parameter classNameParameter;
        Parameter membershipSchemeParam = this.getParameter("membershipScheme");
        String mbrScheme = "multicast";
        if (membershipSchemeParam != null) {
            mbrScheme = ((String)membershipSchemeParam.getValue()).trim();
        }
        if (!(mbrScheme.equals("multicast") || mbrScheme.equals("wka") || mbrScheme.equals("aws") || mbrScheme.equals("aws-ecs") || (classNameParameter = (Parameter)this.parameters.get(MEMBERSHIP_SCHEME_CLASS_NAME)) != null)) {
            String msg = "Invalid membership scheme '" + mbrScheme + "'. Supported schemes are " + "multicast" + ", " + "wka" + " & " + "aws";
            log.error((Object)msg);
            throw new ClusteringFault(msg);
        }
        return mbrScheme;
    }

    public void stop() {
        Hazelcast.shutdownAll();
    }

    public StateManager getStateManager() {
        return null;
    }

    @Deprecated
    public NodeManager getNodeManager() {
        return null;
    }

    public Config getPrimaryHazelcastConfig() {
        return this.primaryHazelcastConfig;
    }

    public void setStateManager(StateManager stateManager) {
        throw new UnsupportedOperationException("setStateManager is not supported");
    }

    @Deprecated
    public void setNodeManager(NodeManager nodeManager) {
        throw new UnsupportedOperationException("setNodeManager is no longer supported");
    }

    public void shutdown() throws ClusteringFault {
        try {
            Hazelcast.shutdownAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.msgCleanupScheduler != null) {
            this.msgCleanupScheduler.shutdown();
        }
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void setMembers(List<Member> wkaMembers) {
        this.wkaMembers = wkaMembers;
    }

    public List<Member> getMembers() {
        return this.wkaMembers;
    }

    public int getAliveMemberCount() {
        return MemberUtils.getMembersMap(this.primaryHazelcastInstance, this.primaryDomain).size();
    }

    public void addGroupManagementAgent(GroupManagementAgent agent, String applicationDomain) {
        this.addGroupManagementAgent(agent, applicationDomain, null);
    }

    public void addGroupManagementAgent(GroupManagementAgent groupManagementAgent, String applicationDomain, String applicationSubDomain, int groupMgtPort) {
        this.addGroupManagementAgent(groupManagementAgent, applicationDomain, applicationSubDomain);
        groupManagementAgent.setGroupMgtPort(groupMgtPort);
    }

    public void resetGroupManagementAgent(String applicationDomain, String applicationSubDomain) {
        if (this.groupManagementAgents.containsKey(applicationDomain) && this.groupManagementAgents.get(applicationDomain).containsKey(applicationSubDomain)) {
            GroupManagementAgent agent = this.groupManagementAgents.get(applicationDomain).get(applicationSubDomain);
            Iterator iterator = agent.getMembers().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove all members of group management agent of cluster domain " + applicationDomain + " and sub domain " + applicationSubDomain));
            }
            if (agent instanceof DefaultGroupManagementAgent) {
                MembershipManager manager = ((DefaultGroupManagementAgent)agent).getMembershipManager();
                manager.removeAllMembers();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Remove all members of Membership Manager of group management agent of cluster domain " + applicationDomain + " and sub domain " + applicationSubDomain));
                }
            }
        }
        log.info((Object)("Resetting group management agent of cluster domain " + applicationDomain + " and sub domain " + applicationSubDomain));
    }

    public void addGroupManagementAgent(GroupManagementAgent agent, String applicationDomain, String applicationSubDomain) {
        if (applicationSubDomain == null) {
            applicationSubDomain = DEFAULT_SUB_DOMAIN;
        }
        log.info((Object)("Managing group application domain:" + applicationDomain + ", sub-domain:" + applicationSubDomain + " using agent " + agent.getClass()));
        if (!this.groupManagementAgents.containsKey(applicationDomain)) {
            this.groupManagementAgents.put(applicationDomain, new HashMap());
        }
        agent.setDomain(applicationDomain);
        agent.setSubDomain(applicationSubDomain);
        this.groupManagementAgents.get(applicationDomain).put(applicationSubDomain, agent);
        this.clusterManagementMode = true;
    }

    public GroupManagementAgent getGroupManagementAgent(String applicationDomain) {
        return this.getGroupManagementAgent(applicationDomain, null);
    }

    public GroupManagementAgent getGroupManagementAgent(String applicationDomain, String applicationSubDomain) {
        Map<String, GroupManagementAgent> groupManagementAgentMap;
        if (applicationSubDomain == null) {
            applicationSubDomain = DEFAULT_SUB_DOMAIN;
        }
        if ((groupManagementAgentMap = this.groupManagementAgents.get(applicationDomain)) != null) {
            return groupManagementAgentMap.get(applicationSubDomain);
        }
        return null;
    }

    public Set<String> getDomains() {
        return this.groupManagementAgents.keySet();
    }

    public boolean isCoordinator() {
        return this.isCoordinator;
    }

    public List<ClusteringCommand> sendMessage(ClusteringMessage clusteringMessage, boolean isSync) throws ClusteringFault {
        if (this.isIdempotent(clusteringMessage)) {
            IdempotentWrappedClusteringMessage<ClusteringMessage> idempotentWrappedClusteringMessage = new IdempotentWrappedClusteringMessage<ClusteringMessage>(clusteringMessage);
            idempotentWrappedClusteringMessage.setClusterNodeId(this.clusterNodeId);
            this.sendToTopic(this.idempotentNonReliableMessageTopic, idempotentWrappedClusteringMessage);
            return Collections.emptyList();
        }
        if (!this.sentMsgsBuffer.contains(clusteringMessage)) {
            this.sentMsgsBuffer.add(clusteringMessage);
        }
        this.sendToTopic(this.clusteringMessageTopic, clusteringMessage);
        return new ArrayList<ClusteringCommand>();
    }

    private <T extends ClusteringMessage> void sendToTopic(ITopic<T> topic, T clusteringMessage) {
        block3: {
            if (topic != null) {
                try {
                    topic.publish(clusteringMessage);
                }
                catch (HazelcastInstanceNotActiveException e) {
                    String serverStatus = ServerStatus.getCurrentStatus();
                    if ("SHUTTING_DOWN".equals(serverStatus) || "RESTARTING".equals(serverStatus)) break block3;
                    log.error((Object)"Could not send cluster message", (Throwable)e);
                }
            }
        }
    }

    boolean isIdempotent(Object message) {
        if (message == null) {
            return true;
        }
        IdempotentMessage annotation = message.getClass().getAnnotation(IdempotentMessage.class);
        return annotation != null;
    }

    static {
        String configPath = CarbonUtils.getCarbonConfigDirPath();
        DEFAULT_CONFIG_FILE_PATH = configPath == null ? Paths.get(CarbonUtils.getCarbonHome(), "repository", "conf", "etc", "hazelcast.xml") : Paths.get(CarbonUtils.getCarbonConfigDirPath(), "etc", "hazelcast.xml");
    }

    private class CoordinatorElectionMembershipListener
    implements MembershipListener {
        private CoordinatorElectionMembershipListener() {
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            if (HazelcastClusteringAgent.this.isCoordinator) {
                log.debug((Object)"Member Added Event: Checking whether there are multiple Coordinator nodes in the cluster.");
                com.hazelcast.core.Member oldestMember = (com.hazelcast.core.Member)HazelcastClusteringAgent.this.primaryHazelcastInstance.getCluster().getMembers().iterator().next();
                if (!oldestMember.localMember()) {
                    log.debug((Object)"This node is not the Coordinator now.");
                    HazelcastClusteringAgent.this.isCoordinator = false;
                }
            }
        }

        public void memberRemoved(MembershipEvent membershipEvent) {
            if (!HazelcastClusteringAgent.this.isCoordinator) {
                log.debug((Object)"Member Removed Event: Checking whether this node became the Coordinator node");
                com.hazelcast.core.Member oldestMember = (com.hazelcast.core.Member)HazelcastClusteringAgent.this.primaryHazelcastInstance.getCluster().getMembers().iterator().next();
                if (oldestMember.localMember()) {
                    com.hazelcast.core.Member localMember = HazelcastClusteringAgent.this.primaryHazelcastInstance.getCluster().getLocalMember();
                    HazelcastClusteringAgent.this.electCoordinatorNode();
                    log.debug((Object)"Member Removed Event: This member is elected as the Coordinator node");
                }
            }
        }

        public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        }
    }

    private class ClusterMessageCleanupTask
    implements Runnable {
        private static final int MAX_MESSAGES_TO_PROCESS = 5000;
        private static final int MAX_MESSAGE_LIFETIME = 300000;

        private ClusterMessageCleanupTask() {
        }

        @Override
        public void run() {
            int messagesProcessed = 0;
            for (ClusteringMessage clusteringMessage : HazelcastClusteringAgent.this.sentMsgsBuffer) {
                if (System.currentTimeMillis() - clusteringMessage.getTimestamp() >= 300000L) {
                    HazelcastClusteringAgent.this.sentMsgsBuffer.remove(clusteringMessage);
                }
                if (++messagesProcessed < 5000) continue;
                break;
            }
            messagesProcessed = 0;
            for (Map.Entry entry : HazelcastClusteringAgent.this.recdMsgsBuffer.entrySet()) {
                if (System.currentTimeMillis() - (Long)entry.getValue() >= 300000L) {
                    HazelcastClusteringAgent.this.recdMsgsBuffer.remove(entry.getKey());
                }
                if (++messagesProcessed < 5000) continue;
                break;
            }
        }
    }
}

