/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core;

import java.io.File;
import java.lang.management.ManagementPermission;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.FileManipulator;
import org.wso2.carbon.utils.ManagementFactory;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class ServerManagement {
    private static final Log log = LogFactory.getLog(ServerManagement.class);
    private static final long TIMEOUT = 60000L;
    private Map<String, TransportInDescription> inTransports;
    private ConfigurationContext serverConfigContext;
    private static CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    public ServerManagement(Map<String, TransportInDescription> inTransports, ConfigurationContext serverConfigContext) {
        this.inTransports = inTransports;
        this.serverConfigContext = serverConfigContext;
    }

    public void startMaintenance() throws Exception {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        log.info((Object)"Starting to switch to maintenance mode...");
        for (TransportInDescription tinDesc : this.inTransports.values()) {
            TransportListener transport = tinDesc.getReceiver();
            transport.stop();
        }
        log.info((Object)"Stopped all transport listeners");
        this.waitForRequestCompletion();
    }

    public void startMaintenanceForShutDown() throws Exception {
        this.startMaintenance();
        this.waitForDeploymentThreadCompletion();
        this.waitForServerTaskCompletion();
    }

    private void waitForServerTaskCompletion() {
        CarbonUtils.checkSecurity();
        log.info((Object)"Waiting for server task completion...");
        BundleContext bundleContext = dataHolder.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, WaitBeforeShutdownObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                boolean allTasksComplete;
                for (Object service : services) {
                    ((WaitBeforeShutdownObserver)service).startingShutdown();
                }
                do {
                    allTasksComplete = true;
                    for (Object service : services) {
                        allTasksComplete &= ((WaitBeforeShutdownObserver)service).isTaskComplete();
                    }
                } while (!allTasksComplete);
            }
            tracker.close();
        }
        log.info((Object)"All server tasks have been completed.");
    }

    private void waitForDeploymentThreadCompletion() {
        boolean isDeploymentSchedulerRunning;
        CarbonUtils.checkSecurity();
        log.info((Object)"Waiting for deployment completion...");
        Map<String, ConfigurationContext> tenantConfigContexts = TenantAxisUtils.getTenantConfigurationContexts(this.serverConfigContext);
        this.serverConfigContext.getAxisConfiguration().getConfigurator().cleanup();
        for (ConfigurationContext tenantConfigCtx : tenantConfigContexts.values()) {
            tenantConfigCtx.getAxisConfiguration().getConfigurator().cleanup();
        }
        do {
            ConfigurationContext tenantConfigCtx;
            if (isDeploymentSchedulerRunning = this.isDeploymentSchedulerRunning(this.serverConfigContext)) continue;
            Iterator<ConfigurationContext> iterator = tenantConfigContexts.values().iterator();
            while (iterator.hasNext() && !(isDeploymentSchedulerRunning = this.isDeploymentSchedulerRunning(tenantConfigCtx = iterator.next()))) {
            }
        } while (isDeploymentSchedulerRunning);
        log.info((Object)"All deployment tasks have been completed.");
    }

    private void cleanCAppWorkDir() {
        String APP_UNZIP_DIR = System.getProperty("carbon.home") + File.separator + "repository" + File.separator + "carbonapps" + File.separator + "work";
        File AppExtractDir = new File(APP_UNZIP_DIR);
        log.debug((Object)"Starting CApp Extract location cleanup...");
        if (AppExtractDir == null) {
            return;
        }
        File[] children = AppExtractDir.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                FileManipulator.deleteDir((File)children[i]);
            }
            if (!AppExtractDir.delete()) {
                log.warn((Object)("Could not delete file " + AppExtractDir.getAbsolutePath()));
            }
        }
    }

    private boolean isDeploymentSchedulerRunning(ConfigurationContext configurationContext) {
        DeploymentEngine deploymentEngine = (DeploymentEngine)configurationContext.getAxisConfiguration().getConfigurator();
        return deploymentEngine.isDeploymentTaskRunning();
    }

    public void waitForRequestCompletion() throws Exception {
        boolean areRequestsInService;
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        log.info((Object)"Waiting for request service completion...");
        MBeanServer mbs = ManagementFactory.getMBeanServer();
        long start = System.currentTimeMillis();
        do {
            QueryExp query;
            Set<ObjectName> set;
            if ((set = mbs.queryNames(new ObjectName("Catalina:type=RequestProcessor,*"), query = Query.eq(Query.attr("stage"), Query.value(3)))).size() > 0) {
                areRequestsInService = true;
                if (System.currentTimeMillis() - start > 60000L) {
                    log.warn((Object)"Timeout occurred even though there are active connections.");
                    break;
                }
                Thread.sleep(2000L);
                continue;
            }
            areRequestsInService = false;
        } while (areRequestsInService);
        log.info((Object)"All requests have been served.");
    }

    public void endMaintenance() throws Exception {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        log.info((Object)"Switching to normal mode...");
        for (TransportInDescription tinDesc : this.inTransports.values()) {
            TransportListener transport = tinDesc.getReceiver();
            transport.start();
        }
        log.info((Object)"Switched to normal mode");
    }
}

