/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.util;

import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class JdbcUtils {
    public static JdbcTemplate getNewTemplate() {
        return new JdbcTemplate(IdentityDatabaseUtil.getDataSource());
    }

    public static boolean isH2MySqlOrPostgresDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("MySQL") || JdbcUtils.isDBTypeOf("H2") || JdbcUtils.isDBTypeOf("PostgreSQL") || JdbcUtils.isDBTypeOf("MariaDB");
    }

    public static boolean isH2() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("H2");
    }

    public static boolean isMySQLDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("MySQL");
    }

    public static boolean isMariaDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("MariaDB");
    }

    public static boolean isDB2DB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("DB2");
    }

    public static boolean isPostgreSQLDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("PostgreSQL");
    }

    public static boolean isMSSqlDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("Microsoft") || JdbcUtils.isDBTypeOf("microsoft");
    }

    public static boolean isInformixDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("Informix");
    }

    public static boolean isOracleDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("Oracle");
    }

    private static boolean isDBTypeOf(String dbType) throws DataAccessException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        return jdbcTemplate.getDriverName().contains(dbType) || jdbcTemplate.getDatabaseProductName().contains(dbType);
    }
}

