/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.util;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.configuration.mgt.core.constant.ConfigurationConstants;
import org.wso2.carbon.identity.configuration.mgt.core.constant.SQLConstants;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementClientException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementRuntimeException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementServerException;
import org.wso2.carbon.identity.configuration.mgt.core.internal.ConfigurationManagerComponentDataHolder;
import org.wso2.carbon.identity.core.ServiceURLBuilder;
import org.wso2.carbon.identity.core.URLBuilderException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;

public class ConfigurationUtils {
    private static final Log log = LogFactory.getLog(ConfigurationUtils.class);

    public static ConfigurationManagementClientException handleClientException(ConfigurationConstants.ErrorMessages error, String ... data) {
        String message = ConfigurationUtils.populateMessageWithData(error, data);
        return new ConfigurationManagementClientException(message, error.getCode());
    }

    public static ConfigurationManagementClientException handleClientException(ConfigurationConstants.ErrorMessages error, String data, Throwable e) {
        String message = ConfigurationUtils.populateMessageWithData(error, data);
        return new ConfigurationManagementClientException(message, error.getCode(), e);
    }

    public static ConfigurationManagementServerException handleServerException(ConfigurationConstants.ErrorMessages error, String data) {
        String message = ConfigurationUtils.populateMessageWithData(error, data);
        return new ConfigurationManagementServerException(message, error.getCode());
    }

    public static ConfigurationManagementServerException handleServerException(ConfigurationConstants.ErrorMessages error, String data, Throwable e) {
        String message = ConfigurationUtils.populateMessageWithData(error, data);
        return new ConfigurationManagementServerException(message, error.getCode(), e);
    }

    public static ConfigurationManagementServerException handleServerException(ConfigurationConstants.ErrorMessages error, Throwable e) {
        String message = ConfigurationUtils.populateMessageWithData(error);
        return new ConfigurationManagementServerException(message, error.getCode(), e);
    }

    public static ConfigurationManagementRuntimeException handleRuntimeException(ConfigurationConstants.ErrorMessages error, String data, Throwable e) {
        String message = ConfigurationUtils.populateMessageWithData(error, data);
        return new ConfigurationManagementRuntimeException(message, error.getCode(), e);
    }

    public static ConfigurationManagementRuntimeException handleRuntimeException(ConfigurationConstants.ErrorMessages error, String data) {
        String message = ConfigurationUtils.populateMessageWithData(error, data);
        return new ConfigurationManagementRuntimeException(message, error.getCode());
    }

    public static String generateUniqueID() {
        return UUID.randomUUID().toString();
    }

    public static int getMaximumQueryLengthInBytes() {
        return StringUtils.isEmpty((String)SQLConstants.MAX_QUERY_LENGTH_IN_BYTES_SQL) ? 0x400000 : Integer.parseInt(SQLConstants.MAX_QUERY_LENGTH_IN_BYTES_SQL);
    }

    public static boolean useCreatedTimeField() {
        return ConfigurationManagerComponentDataHolder.getUseCreatedTime();
    }

    private static String populateMessageWithData(ConfigurationConstants.ErrorMessages error, String ... data) {
        String message = data != null && data.length != 0 ? String.format(error.getMessage(), data) : error.getMessage();
        return message;
    }

    private static String populateMessageWithData(ConfigurationConstants.ErrorMessages error) {
        return error.getMessage();
    }

    public static String getFilePath(String fileId, String resourceType, String resourceName) {
        return "/resource/" + resourceType + "/" + resourceName + "/" + "file" + "/" + fileId;
    }

    public static String buildURIForBody(String endpoint) {
        block3: {
            if (IdentityTenantUtil.isTenantQualifiedUrlsEnabled()) {
                try {
                    String url = ServiceURLBuilder.create().addPath(new String[]{"/api/identity/config-mgt/v1.0" + endpoint}).build().getRelativePublicURL();
                    return URI.create(url).toString();
                }
                catch (URLBuilderException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Error occurred while building URI.", (Throwable)e);
                }
            }
        }
        String tenantQualifiedRelativePath = String.format("/t/%s", ConfigurationUtils.getTenantDomainFromContext()) + "/api/identity/config-mgt/v1.0";
        String url = IdentityUtil.getEndpointURIPath((String)(tenantQualifiedRelativePath + endpoint), (boolean)true, (boolean)true);
        return URI.create(url).toString();
    }

    public static String getTenantDomainFromContext() {
        String tenantDomain = "carbon.super";
        if (((Map)IdentityUtil.threadLocalProperties.get()).get("TenantNameFromContext") != null) {
            tenantDomain = (String)((Map)IdentityUtil.threadLocalProperties.get()).get("TenantNameFromContext");
        }
        return tenantDomain;
    }
}

