/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.search;

import java.lang.reflect.Field;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceSearchBean;
import org.wso2.carbon.identity.configuration.mgt.core.search.PrimitiveCondition;
import org.wso2.carbon.identity.configuration.mgt.core.search.SearchBean;
import org.wso2.carbon.identity.configuration.mgt.core.search.constant.ConditionType;
import org.wso2.carbon.identity.configuration.mgt.core.search.exception.PrimitiveConditionValidationException;

public class PrimitiveConditionValidator {
    private SearchBean searchBean;

    public PrimitiveConditionValidator(SearchBean searchBean) {
        this.searchBean = searchBean;
    }

    public PrimitiveCondition validate(PrimitiveCondition primitiveCondition) throws PrimitiveConditionValidationException {
        if (this.searchBean == null) {
            throw new NullPointerException("Invalid search bean: null in the PrimitiveCondition validate.");
        }
        String property = primitiveCondition.getProperty();
        ConditionType.PrimitiveOperator operator = primitiveCondition.getOperator();
        Object value = primitiveCondition.getValue();
        if (property == null || operator == null || value == null) {
            throw new PrimitiveConditionValidationException("Invalid primitive condition parameters found in: property = " + property + (operator == null ? ", condition = null" : "") + (value == null ? ", value = null" : "") + ".");
        }
        try {
            Field field = this.searchBean.getClass().getDeclaredField(property);
            if (!field.getType().getName().equals(value.getClass().getName())) {
                throw new PrimitiveConditionValidationException("Value for the property: " + property + " is expected to be: " + field.getType().getName() + " but found: " + value.getClass().getName());
            }
        }
        catch (NoSuchFieldException e) {
            throw new PrimitiveConditionValidationException("Property: " + property + " is not found in the allowed search properties present in the bean class: " + ResourceSearchBean.class.getName());
        }
        PrimitiveCondition dbQualifiedPrimitiveCondition = this.searchBean.mapPrimitiveCondition(primitiveCondition);
        dbQualifiedPrimitiveCondition.setProperty(this.searchBean.getDBQualifiedFieldName(dbQualifiedPrimitiveCondition.getProperty()));
        return dbQualifiedPrimitiveCondition;
    }
}

