/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.search;

import java.util.ArrayList;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.configuration.mgt.core.search.PlaceholderSQL;
import org.wso2.carbon.identity.configuration.mgt.core.search.PrimitiveConditionValidator;
import org.wso2.carbon.identity.configuration.mgt.core.search.constant.ConditionType;
import org.wso2.carbon.identity.configuration.mgt.core.search.exception.PrimitiveConditionValidationException;

public class PrimitiveCondition
implements Condition {
    private String property;
    private Object value;
    private ConditionType.PrimitiveOperator operator;

    public PrimitiveCondition(String property, ConditionType.PrimitiveOperator operator, Object value) {
        this.property = property;
        this.value = value;
        this.operator = operator;
    }

    public ConditionType.PrimitiveOperator getOperator() {
        return this.operator;
    }

    public void setOperator(ConditionType.PrimitiveOperator operator) {
        this.operator = operator;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public PlaceholderSQL buildQuery(PrimitiveConditionValidator primitiveConditionValidator) throws PrimitiveConditionValidationException {
        PlaceholderSQL placeholderSQL = new PlaceholderSQL();
        PrimitiveCondition dbQualifiedPrimitiveCondition = primitiveConditionValidator.validate(this);
        placeholderSQL.setQuery(dbQualifiedPrimitiveCondition.getProperty() + " " + dbQualifiedPrimitiveCondition.getOperator().toSQL() + " ?");
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(dbQualifiedPrimitiveCondition.getValue());
        placeholderSQL.setData(data);
        return placeholderSQL;
    }
}

