/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.search;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.configuration.mgt.core.search.PlaceholderSQL;
import org.wso2.carbon.identity.configuration.mgt.core.search.PrimitiveConditionValidator;
import org.wso2.carbon.identity.configuration.mgt.core.search.constant.ConditionType;
import org.wso2.carbon.identity.configuration.mgt.core.search.exception.PrimitiveConditionValidationException;

public class ComplexCondition
implements Condition {
    private List<Condition> conditions;
    private ConditionType.ComplexOperator operator;

    public ComplexCondition(ConditionType.ComplexOperator operator, List<Condition> conditions) {
        this.operator = operator;
        this.conditions = conditions;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public PlaceholderSQL buildQuery(PrimitiveConditionValidator primitiveConditionValidator) throws PrimitiveConditionValidationException {
        PlaceholderSQL placeholderSQL = new PlaceholderSQL();
        ArrayList<Object> data = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Condition condition : this.getNullSafeConditions()) {
            if (!first) {
                sb.append(" ").append(this.operator.toSQL()).append(" ");
            } else {
                first = false;
            }
            sb.append("(");
            PlaceholderSQL eachPlaceholderSQL = condition.buildQuery(primitiveConditionValidator);
            sb.append(eachPlaceholderSQL.getQuery());
            data.addAll(eachPlaceholderSQL.getData());
            sb.append(")");
        }
        placeholderSQL.setQuery(sb.toString());
        placeholderSQL.setData(data);
        return placeholderSQL;
    }

    private List<Condition> getNullSafeConditions() {
        return this.conditions == null ? Collections.emptyList() : this.conditions;
    }
}

