/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.configuration.mgt.core.search.PrimitiveCondition;
import org.wso2.carbon.identity.configuration.mgt.core.search.SearchBean;
import org.wso2.carbon.identity.configuration.mgt.core.search.exception.PrimitiveConditionValidationException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;

public class ResourceSearchBean
implements SearchBean {
    private static final Log log = LogFactory.getLog(ResourceSearchBean.class);
    private int tenantId;
    private String tenantDomain;
    private String resourceTypeId;
    private String resourceTypeName;
    private String resourceId;
    private String resourceName;
    private String attributeKey;
    private String attributeValue;

    @Override
    public String getDBQualifiedFieldName(String fieldName) {
        String dbQualifiedFieldName = null;
        switch (fieldName) {
            case "tenantId": {
                dbQualifiedFieldName = "R.TENANT_ID";
                break;
            }
            case "resourceTypeId": {
                dbQualifiedFieldName = "T.ID";
                break;
            }
            case "resourceTypeName": {
                dbQualifiedFieldName = "T.NAME";
                break;
            }
            case "resourceId": {
                dbQualifiedFieldName = "R.ID";
                break;
            }
            case "resourceName": {
                dbQualifiedFieldName = "R.NAME";
                break;
            }
            case "attributeKey": {
                dbQualifiedFieldName = "A.ATTR_KEY";
                break;
            }
            case "attributeValue": {
                dbQualifiedFieldName = "A.ATTR_VALUE";
            }
        }
        return dbQualifiedFieldName;
    }

    @Override
    public PrimitiveCondition mapPrimitiveCondition(PrimitiveCondition primitiveCondition) throws PrimitiveConditionValidationException {
        if (primitiveCondition.getProperty().equals("tenantDomain")) {
            try {
                primitiveCondition.setValue(IdentityTenantUtil.getTenantId((String)((String)primitiveCondition.getValue())));
            }
            catch (IdentityRuntimeException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Error while retrieving tenant id for the tenant domain: " + primitiveCondition.getValue() + "."), (Throwable)e);
                }
                throw new PrimitiveConditionValidationException("Unable to retrieve the tenant for the tenantDomain: " + primitiveCondition.getValue());
            }
            primitiveCondition.setProperty("tenantId");
        }
        return primitiveCondition;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public String getResourceTypeId() {
        return this.resourceTypeId;
    }

    public void setResourceTypeId(String resourceTypeId) {
        this.resourceTypeId = resourceTypeId;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }

    public void setResourceTypeName(String resourceTypeName) {
        this.resourceTypeName = resourceTypeName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getAttributeKey() {
        return this.attributeKey;
    }

    public void setAttributeKey(String attributeKey) {
        this.attributeKey = attributeKey;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public void setAttributeValue(String attributeValue) {
        this.attributeValue = attributeValue;
    }
}

