/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManager;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManagerImpl;
import org.wso2.carbon.identity.configuration.mgt.core.dao.ConfigurationDAO;
import org.wso2.carbon.identity.configuration.mgt.core.dao.impl.CachedBackedConfigurationDAO;
import org.wso2.carbon.identity.configuration.mgt.core.dao.impl.ConfigurationDAOImpl;
import org.wso2.carbon.identity.configuration.mgt.core.internal.ConfigurationManagerComponentDataHolder;
import org.wso2.carbon.identity.configuration.mgt.core.model.ConfigurationManagerConfigurationHolder;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="carbon.configuration.mgt.component", immediate=true)
public class ConfigurationManagerComponent {
    private static final Log log = LogFactory.getLog(ConfigurationManagerComponent.class);
    private List<ConfigurationDAO> configurationDAOs = new ArrayList<ConfigurationDAO>();

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            BundleContext bundleContext = componentContext.getBundleContext();
            ConfigurationDAOImpl configurationDAO = new ConfigurationDAOImpl();
            bundleContext.registerService(ConfigurationDAO.class.getName(), (Object)configurationDAO, null);
            bundleContext.registerService(ConfigurationDAO.class.getName(), (Object)new CachedBackedConfigurationDAO(configurationDAO), null);
            ConfigurationManagerConfigurationHolder configurationManagerConfigurationHolder = new ConfigurationManagerConfigurationHolder();
            configurationManagerConfigurationHolder.setConfigurationDAOS(this.configurationDAOs);
            bundleContext.registerService(ConfigurationManager.class.getName(), (Object)new ConfigurationManagerImpl(configurationManagerConfigurationHolder), null);
            ConfigurationManagerComponentDataHolder.getInstance().setConfigurationManagementEnabled(this.isConfigurationManagementEnabled());
            this.setUseCreatedTime();
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating ConfigurationManagerComponent.", e);
        }
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"ConfigurationContextService Instance registered.");
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"ConfigurationContextService Instance was unset.");
    }

    @Reference(name="configuration.dao", service=ConfigurationDAO.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfiguration")
    protected void setConfiguration(ConfigurationDAO configurationDAO) {
        if (configurationDAO != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource DAO is registered in ConfigurationManager service.");
            }
            this.configurationDAOs.add(configurationDAO);
            this.configurationDAOs.sort(Comparator.comparingInt(ConfigurationDAO::getPriority));
        }
    }

    protected void unsetConfiguration(ConfigurationDAO configurationDAO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Purpose DAO is unregistered in ConfigurationManager service.");
        }
        this.configurationDAOs.remove(configurationDAO);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the Realm Service");
        }
        ConfigurationManagerComponentDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the Realm Service");
        }
        ConfigurationManagerComponentDataHolder.getInstance().setRealmService(null);
    }

    private void setUseCreatedTime() throws DataAccessException {
        if (ConfigurationManagerComponentDataHolder.getInstance().isConfigurationManagementEnabled() && this.isCreatedTimeFieldExists()) {
            ConfigurationManagerComponentDataHolder.setUseCreatedTime(true);
        } else {
            ConfigurationManagerComponentDataHolder.setUseCreatedTime(false);
        }
    }

    /*
     * Exception decompiling
     */
    private boolean isCreatedTimeFieldExists() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isConfigurationManagementEnabled() {
        return FrameworkUtils.isTableExists((String)"IDN_CONFIG_TYPE") && FrameworkUtils.isTableExists((String)"IDN_CONFIG_RESOURCE") && FrameworkUtils.isTableExists((String)"IDN_CONFIG_ATTRIBUTE") && FrameworkUtils.isTableExists((String)"IDN_CONFIG_FILE");
    }
}

