/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.dao.impl;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.Template;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.database.utils.jdbc.exceptions.TransactionException;
import org.wso2.carbon.identity.configuration.mgt.core.constant.ConfigurationConstants;
import org.wso2.carbon.identity.configuration.mgt.core.constant.SQLConstants;
import org.wso2.carbon.identity.configuration.mgt.core.dao.ConfigurationDAO;
import org.wso2.carbon.identity.configuration.mgt.core.dao.impl.ConfigurationRawDataCollector;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementClientException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementServerException;
import org.wso2.carbon.identity.configuration.mgt.core.model.Attribute;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceFile;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceSearchBean;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceType;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resources;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.configuration.mgt.core.search.PlaceholderSQL;
import org.wso2.carbon.identity.configuration.mgt.core.search.PrimitiveConditionValidator;
import org.wso2.carbon.identity.configuration.mgt.core.search.exception.PrimitiveConditionValidationException;
import org.wso2.carbon.identity.configuration.mgt.core.util.ConfigurationUtils;
import org.wso2.carbon.identity.configuration.mgt.core.util.JdbcUtils;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.LambdaExceptionUtils;

public class ConfigurationDAOImpl
implements ConfigurationDAO {
    private static final Log log = LogFactory.getLog(ConfigurationDAOImpl.class);
    private static final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Resources getTenantResources(Condition condition) throws ConfigurationManagementException {
        PlaceholderSQL placeholderSQL = this.buildPlaceholderSQL(condition, ConfigurationUtils.useCreatedTimeField());
        if (placeholderSQL.getQuery().getBytes().length > ConfigurationUtils.getMaximumQueryLengthInBytes()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error building SQL query for the search. Search expression query length: " + placeholderSQL.getQuery().length() + " exceeds the maximum limit: " + SQLConstants.MAX_QUERY_LENGTH_IN_BYTES_SQL));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_QUERY_LENGTH_EXCEEDED, null);
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            List configurationRawDataCollectors = jdbcTemplate.executeQuery(placeholderSQL.getQuery(), (resultSet, rowNumber) -> {
                ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder configurationRawDataCollectorBuilder = new ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder().setResourceId(resultSet.getString("ID")).setTenantId(resultSet.getInt("TENANT_ID")).setResourceName(resultSet.getString("NAME")).setLastModified(resultSet.getTimestamp("LAST_MODIFIED", calendar)).setResourceTypeName(resultSet.getString("RESOURCE_TYPE")).setResourceTypeDescription(resultSet.getString("DESCRIPTION")).setAttributeKey(resultSet.getString("ATTR_KEY")).setAttributeValue(resultSet.getString("ATTR_VALUE")).setAttributeId(resultSet.getString("ATTR_ID")).setFileId(resultSet.getString("FILE_ID"));
                if (ConfigurationUtils.useCreatedTimeField()) {
                    configurationRawDataCollectorBuilder.setCreatedTime(resultSet.getTimestamp("CREATED_TIME", calendar));
                }
                return configurationRawDataCollectorBuilder.build();
            }, preparedStatement -> {
                for (int count = 0; count < placeholderSQL.getData().size(); ++count) {
                    if (placeholderSQL.getData().get(count).getClass().equals(Integer.class)) {
                        preparedStatement.setInt(count + 1, (Integer)placeholderSQL.getData().get(count));
                        continue;
                    }
                    preparedStatement.setString(count + 1, (String)placeholderSQL.getData().get(count));
                }
            });
            return configurationRawDataCollectors == null || configurationRawDataCollectors.size() == 0 ? null : this.buildResourcesFromRawData(configurationRawDataCollectors);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_SEARCH_TENANT_RESOURCES, null, e);
        }
    }

    @Override
    public Resource getResourceByName(int tenantId, String resourceTypeId, String resourceName) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String queryWithCreatedTime = "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.CREATED_TIME,\n  R.LAST_MODIFIED,\n  R.HAS_FILE,\n  R.HAS_ATTRIBUTE,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  F.NAME AS FILE_NAME,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\nWHERE\n  R.NAME = ?\n  AND R.TENANT_ID = ?\n  AND R.TYPE_ID = ?";
            String queryWithOutCreatedTime = "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.LAST_MODIFIED,\n  R.HAS_FILE,\n  R.HAS_ATTRIBUTE,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\nWHERE\n  R.NAME = ?\n  AND R.TENANT_ID = ?\n  AND R.TYPE_ID = ?";
            if (JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB()) {
                queryWithCreatedTime = "SELECT   R.ID,  R.TENANT_ID,  R.NAME,  R.CREATED_TIME,  R.LAST_MODIFIED,  R.HAS_FILE,  R.HAS_ATTRIBUTE,  T.NAME RESOURCE_TYPE,  T.DESCRIPTION DESCRIPTION,  F.ID FILE_ID,  F.NAME FILE_NAME,  A.ID ATTR_ID,  A.ATTR_KEY ATTR_KEY,  A.ATTR_VALUE ATTR_VALUE FROM  IDN_CONFIG_RESOURCE R  INNER JOIN IDN_CONFIG_TYPE T ON R.TYPE_ID = T.ID  LEFT JOIN IDN_CONFIG_ATTRIBUTE A ON (    R.HAS_ATTRIBUTE = 1    AND A.RESOURCE_ID = R.ID  )  LEFT JOIN IDN_CONFIG_FILE F ON (    R.HAS_FILE = 1    AND F.RESOURCE_ID = R.ID  )WHERE  R.NAME = ?  AND R.TENANT_ID = ?  AND R.TYPE_ID = ?";
            }
            List configurationRawDataCollectors = jdbcTemplate.executeQuery(ConfigurationUtils.useCreatedTimeField() ? queryWithCreatedTime : queryWithOutCreatedTime, (resultSet, rowNumber) -> {
                ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder configurationRawDataCollectorBuilder = new ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder().setResourceId(resultSet.getString("ID")).setTenantId(resultSet.getInt("TENANT_ID")).setResourceName(resultSet.getString("NAME")).setLastModified(resultSet.getTimestamp("LAST_MODIFIED", calendar)).setResourceTypeName(resultSet.getString("RESOURCE_TYPE")).setResourceTypeDescription(resultSet.getString("DESCRIPTION")).setAttributeKey(resultSet.getString("ATTR_KEY")).setAttributeValue(resultSet.getString("ATTR_VALUE")).setAttributeId(resultSet.getString("ATTR_ID")).setFileId(resultSet.getString("FILE_ID")).setFileName(resultSet.getString("FILE_NAME")).setHasFile(resultSet.getBoolean("HAS_FILE")).setHasAttribute(resultSet.getBoolean("HAS_ATTRIBUTE"));
                if (ConfigurationUtils.useCreatedTimeField()) {
                    configurationRawDataCollectorBuilder.setCreatedTime(resultSet.getTimestamp("CREATED_TIME", calendar));
                }
                return configurationRawDataCollectorBuilder.build();
            }, preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resourceName);
                preparedStatement.setInt(++initialParameterIndex, tenantId);
                preparedStatement.setString(++initialParameterIndex, resourceTypeId);
            });
            return configurationRawDataCollectors == null || configurationRawDataCollectors.size() == 0 ? null : this.buildResourceFromRawData(configurationRawDataCollectors);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_RESOURCE, resourceName, e);
        }
    }

    @Override
    public Resource getResourceById(String resourceId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            List configurationRawDataCollectors = jdbcTemplate.executeQuery(ConfigurationUtils.useCreatedTimeField() ? "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.CREATED_TIME,\n  R.LAST_MODIFIED,\n  R.HAS_FILE,\n  R.HAS_ATTRIBUTE,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\nWHERE\n  R.ID = ?\n" : "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.LAST_MODIFIED,\n  R.HAS_FILE,\n  R.HAS_ATTRIBUTE,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\nWHERE\n  R.ID = ?\n", (resultSet, rowNumber) -> {
                ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder configurationRawDataCollectorBuilder = new ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder().setResourceId(resultSet.getString("ID")).setTenantId(resultSet.getInt("TENANT_ID")).setResourceName(resultSet.getString("NAME")).setLastModified(resultSet.getTimestamp("LAST_MODIFIED", calendar)).setResourceTypeName(resultSet.getString("RESOURCE_TYPE")).setResourceTypeDescription(resultSet.getString("DESCRIPTION")).setAttributeKey(resultSet.getString("ATTR_KEY")).setAttributeValue(resultSet.getString("ATTR_VALUE")).setAttributeId(resultSet.getString("ATTR_ID")).setFileId(resultSet.getString("FILE_ID")).setHasFile(resultSet.getBoolean("HAS_FILE")).setHasAttribute(resultSet.getBoolean("HAS_ATTRIBUTE"));
                if (ConfigurationUtils.useCreatedTimeField()) {
                    configurationRawDataCollectorBuilder.setCreatedTime(resultSet.getTimestamp("CREATED_TIME", calendar));
                }
                return configurationRawDataCollectorBuilder.build();
            }, preparedStatement -> preparedStatement.setString(1, resourceId));
            return configurationRawDataCollectors == null || configurationRawDataCollectors.size() == 0 ? null : this.buildResourceFromRawData(configurationRawDataCollectors);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_RESOURCE, "id = " + resourceId, e);
        }
    }

    @Override
    public Resource getTenantResourceById(int tenantId, String resourceId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String queryWithCreatedTime = "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.CREATED_TIME,\n  R.LAST_MODIFIED,\n  R.HAS_FILE,\n  R.HAS_ATTRIBUTE,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\nWHERE\n  R.ID = ?\n";
            String queryWithOutCreatedTime = "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.LAST_MODIFIED,\n  R.HAS_FILE,\n  R.HAS_ATTRIBUTE,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\nWHERE\n  R.ID = ?\n";
            if (JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB()) {
                queryWithCreatedTime = "SELECT   R.ID,   R.TENANT_ID,   R.NAME,   R.CREATED_TIME,   R.LAST_MODIFIED,   R.HAS_FILE,   R.HAS_ATTRIBUTE,   T.NAME RESOURCE_TYPE,   T.DESCRIPTION DESCRIPTION,   F.ID FILE_ID,   A.ID ATTR_ID,   A.ATTR_KEY ATTR_KEY,   A.ATTR_VALUE ATTR_VALUE FROM   IDN_CONFIG_RESOURCE R   INNER JOIN IDN_CONFIG_TYPE T ON R.TYPE_ID = T.ID   LEFT JOIN IDN_CONFIG_ATTRIBUTE A ON (       R.HAS_ATTRIBUTE = 1       AND A.RESOURCE_ID = R.ID   )   LEFT JOIN IDN_CONFIG_FILE F ON (        R.HAS_FILE = 1        AND F.RESOURCE_ID = R.ID   )WHERE   R.ID = ?";
            }
            StringBuilder sb = new StringBuilder();
            sb.append(ConfigurationUtils.useCreatedTimeField() ? queryWithCreatedTime : queryWithOutCreatedTime);
            sb.append(" AND R.TENANT_ID = ?");
            List configurationRawDataCollectors = jdbcTemplate.executeQuery(sb.toString(), (resultSet, rowNumber) -> {
                ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder configurationRawDataCollectorBuilder = new ConfigurationRawDataCollector.ConfigurationRawDataCollectorBuilder().setResourceId(resultSet.getString("ID")).setTenantId(resultSet.getInt("TENANT_ID")).setResourceName(resultSet.getString("NAME")).setLastModified(resultSet.getTimestamp("LAST_MODIFIED", calendar)).setResourceTypeName(resultSet.getString("RESOURCE_TYPE")).setResourceTypeDescription(resultSet.getString("DESCRIPTION")).setAttributeKey(resultSet.getString("ATTR_KEY")).setAttributeValue(resultSet.getString("ATTR_VALUE")).setAttributeId(resultSet.getString("ATTR_ID")).setFileId(resultSet.getString("FILE_ID")).setHasFile(resultSet.getBoolean("HAS_FILE")).setHasAttribute(resultSet.getBoolean("HAS_ATTRIBUTE"));
                if (ConfigurationUtils.useCreatedTimeField()) {
                    configurationRawDataCollectorBuilder.setCreatedTime(resultSet.getTimestamp("CREATED_TIME", calendar));
                }
                return configurationRawDataCollectorBuilder.build();
            }, preparedStatement -> {
                preparedStatement.setString(1, resourceId);
                preparedStatement.setInt(2, tenantId);
            });
            return configurationRawDataCollectors == null || configurationRawDataCollectors.size() == 0 ? null : this.buildResourceFromRawData(configurationRawDataCollectors);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_RESOURCE, "id = " + resourceId, e);
        }
    }

    @Override
    public void deleteResourceByName(int tenantId, String resourceTypeId, String resourceName) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM\n  IDN_CONFIG_RESOURCE\nWHERE\n  NAME = ?\n  AND TENANT_ID = ?\n  AND TYPE_ID = ?", preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resourceName);
                preparedStatement.setInt(++initialParameterIndex, tenantId);
                preparedStatement.setString(++initialParameterIndex, resourceTypeId);
            });
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_DELETE_RESOURCE_TYPE, resourceName, e);
        }
    }

    @Override
    public void deleteResourceById(int tenantId, String resourceId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM IDN_CONFIG_RESOURCE WHERE ID = ? AND TENANT_ID = ?", preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resourceId);
                preparedStatement.setInt(++initialParameterIndex, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_DELETE_RESOURCE, resourceId, e);
        }
    }

    @Override
    public void replaceResource(Resource resource) throws ConfigurationManagementException {
        String resourceTypeId = this.getResourceTypeByName(resource.getResourceType()).getId();
        Timestamp currentTime = new Timestamp(new Date().getTime());
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            Timestamp createdTime = (Timestamp)jdbcTemplate.withTransaction(template -> {
                boolean isAttributeExists;
                boolean bl = isAttributeExists = resource.getAttributes() != null;
                if (JdbcUtils.isH2()) {
                    this.updateMetadataForH2(resource, resourceTypeId, isAttributeExists, currentTime, ConfigurationUtils.useCreatedTimeField());
                } else {
                    this.updateMetadataForMYSQL(resource, resourceTypeId, isAttributeExists, currentTime, ConfigurationUtils.useCreatedTimeField());
                }
                if (isAttributeExists) {
                    template.executeUpdate("DELETE FROM IDN_CONFIG_ATTRIBUTE WHERE RESOURCE_ID = ?", preparedStatement -> preparedStatement.setString(1, resource.getResourceId()));
                    this.insertResourceAttributes(template, resource);
                }
                if (ConfigurationUtils.useCreatedTimeField()) {
                    return this.getCreatedTimeInResponse(resource, resourceTypeId);
                }
                return null;
            });
            resource.setLastModified(currentTime.toInstant().toString());
            if (createdTime != null) {
                resource.setCreatedTime(createdTime.toInstant().toString());
            }
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_REPLACE_RESOURCE, resource.getResourceName(), e);
        }
    }

    @Override
    public void replaceResourceWithFiles(Resource resource) throws ConfigurationManagementException {
        String resourceTypeId = this.getResourceTypeByName(resource.getResourceType()).getId();
        Timestamp currentTime = new Timestamp(new Date().getTime());
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            Timestamp createdTime = (Timestamp)jdbcTemplate.withTransaction(template -> {
                boolean isFileExists;
                boolean isAttributeExists = resource.getAttributes() != null && !resource.getAttributes().isEmpty();
                boolean bl = isFileExists = resource.getFiles() != null && !resource.getFiles().isEmpty();
                if (isAttributeExists) {
                    template.executeUpdate("DELETE FROM IDN_CONFIG_ATTRIBUTE WHERE RESOURCE_ID = ?", preparedStatement -> preparedStatement.setString(1, resource.getResourceId()));
                    this.insertResourceAttributes(template, resource);
                }
                if (isFileExists) {
                    template.executeUpdate("DELETE FROM IDN_CONFIG_FILE WHERE RESOURCE_ID = ?", preparedStatement -> preparedStatement.setString(1, resource.getResourceId()));
                    for (ResourceFile file : resource.getFiles()) {
                        template.executeUpdate("INSERT INTO IDN_CONFIG_FILE(ID, VALUE, RESOURCE_ID, NAME) VALUES(?, ?, ?, ?)", preparedStatement -> {
                            preparedStatement.setString(1, file.getId());
                            preparedStatement.setBlob(2, file.getInputStream());
                            preparedStatement.setString(3, resource.getResourceId());
                            preparedStatement.setString(4, file.getName());
                        });
                    }
                }
                this.updateResourceMetadata(template, resource, isAttributeExists, isFileExists, currentTime);
                if (ConfigurationUtils.useCreatedTimeField()) {
                    return this.getCreatedTimeInResponse(resource, resourceTypeId);
                }
                return null;
            });
            resource.setLastModified(currentTime.toInstant().toString());
            if (createdTime != null) {
                resource.setCreatedTime(createdTime.toInstant().toString());
            }
        }
        catch (TransactionException e) {
            if (e.getCause() instanceof ConfigurationManagementException) {
                throw (ConfigurationManagementException)e.getCause();
            }
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_REPLACE_RESOURCE, resource.getResourceName(), e);
        }
    }

    @Override
    public boolean isExistingResource(int tenantId, String resourceId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String resourceName = (String)jdbcTemplate.fetchSingleRecord("SELECT NAME FROM IDN_CONFIG_RESOURCE WHERE ID = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> resultSet.getString("NAME"), preparedStatement -> {
                preparedStatement.setString(1, resourceId);
                preparedStatement.setInt(2, tenantId);
            });
            return StringUtils.isNotEmpty((String)resourceName);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_RESOURCE, "id = " + resourceId, e);
        }
    }

    @Override
    public void addResource(Resource resource) throws ConfigurationManagementException {
        String resourceTypeId = this.getResourceTypeByName(resource.getResourceType()).getId();
        Timestamp currentTime = new Timestamp(new Date().getTime());
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            boolean isOracleOrMssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
            jdbcTemplate.withTransaction(template -> {
                boolean isAttributeExists = resource.getAttributes() != null;
                template.executeInsert(ConfigurationUtils.useCreatedTimeField() ? "INSERT INTO\n  IDN_CONFIG_RESOURCE(\n    ID,\n    TENANT_ID,\n    NAME,\n    CREATED_TIME,\n    LAST_MODIFIED,\n    HAS_FILE,\n    HAS_ATTRIBUTE,\n    TYPE_ID\n  )\nVALUES(?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO\n  IDN_CONFIG_RESOURCE(\n    ID,\n    TENANT_ID,\n    NAME,\n    LAST_MODIFIED,\n    HAS_FILE,    HAS_ATTRIBUTE,    TYPE_ID  )VALUES(?, ?, ?, ?, ?, ?, ?)", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setString(initialParameterIndex, resource.getResourceId());
                    preparedStatement.setInt(++initialParameterIndex, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                    preparedStatement.setString(++initialParameterIndex, resource.getResourceName());
                    if (ConfigurationUtils.useCreatedTimeField()) {
                        preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                    }
                    preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                    if (isOracleOrMssql) {
                        preparedStatement.setInt(++initialParameterIndex, 0);
                        preparedStatement.setInt(++initialParameterIndex, isAttributeExists ? 1 : 0);
                    } else {
                        preparedStatement.setBoolean(++initialParameterIndex, false);
                        preparedStatement.setBoolean(++initialParameterIndex, isAttributeExists);
                    }
                    preparedStatement.setString(++initialParameterIndex, resourceTypeId);
                }, (Object)resource, false);
                if (isAttributeExists) {
                    this.insertResourceAttributes(template, resource);
                }
                return null;
            });
            resource.setLastModified(currentTime.toInstant().toString());
            if (ConfigurationUtils.useCreatedTimeField()) {
                resource.setCreatedTime(currentTime.toInstant().toString());
            }
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ADD_RESOURCE, resource.getResourceName(), e);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
        }
    }

    @Override
    public void addResourceType(ResourceType resourceType) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeInsert("INSERT INTO IDN_CONFIG_TYPE (ID, NAME, DESCRIPTION) VALUES (?, ?, ?)", preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resourceType.getId());
                preparedStatement.setString(++initialParameterIndex, resourceType.getName());
                preparedStatement.setString(++initialParameterIndex, resourceType.getDescription());
            }, (Object)resourceType, false);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ADD_RESOURCE_TYPE, resourceType.getName(), e);
        }
    }

    @Override
    public void replaceResourceType(ResourceType resourceType) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            String query = "INSERT INTO IDN_CONFIG_TYPE (ID, NAME, DESCRIPTION) VALUES (?, ?, ?)  ON DUPLICATE KEY UPDATE NAME = VALUES(NAME), DESCRIPTION = VALUES(DESCRIPTION)";
            if (JdbcUtils.isH2()) {
                query = "MERGE INTO IDN_CONFIG_TYPE KEY (ID) VALUES (?, ?, ?)";
            } else if (JdbcUtils.isPostgreSQLDB()) {
                query = "INSERT INTO IDN_CONFIG_TYPE (ID, NAME, DESCRIPTION) VALUES (?, ?, ?) ON CONFLICT (ID) DO UPDATE SET NAME = EXCLUDED.NAME, DESCRIPTION = EXCLUDED.DESCRIPTION";
            } else if (JdbcUtils.isMSSqlDB() || JdbcUtils.isDB2DB()) {
                query = "MERGE IDN_CONFIG_TYPE T USING  (VALUES (?, ?, ?)) S (ID,NAME,DESCRIPTION) ON T.ID = S.ID WHEN MATCHED THEN UPDATE SET NAME = S.NAME, DESCRIPTION = S.DESCRIPTION WHEN NOT MATCHED THEN INSERT (ID,NAME,DESCRIPTION) VALUES (S.ID, S.NAME, S.DESCRIPTION);";
            } else if (JdbcUtils.isOracleDB()) {
                query = "MERGE INTO IDN_CONFIG_TYPE USING dual ON (ID = ?) WHEN MATCHED THEN UPDATE SET NAME = ? , DESCRIPTION = ? WHEN NOT MATCHED THEN INSERT (ID, NAME, DESCRIPTION)     VALUES (?, ?, ?)";
            }
            jdbcTemplate.executeInsert(query, preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resourceType.getId());
                preparedStatement.setString(++initialParameterIndex, resourceType.getName());
                preparedStatement.setString(++initialParameterIndex, resourceType.getDescription());
            }, (Object)resourceType, false);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_UPDATE_RESOURCE_TYPE, resourceType.getName(), e);
        }
    }

    @Override
    public ResourceType getResourceTypeByName(String resourceTypeName) throws ConfigurationManagementException {
        return this.getResourceTypeByIdentifier(resourceTypeName, null);
    }

    @Override
    public ResourceType getResourceTypeById(String resourceTypeId) throws ConfigurationManagementException {
        return this.getResourceTypeByIdentifier(null, resourceTypeId);
    }

    @Override
    public void deleteResourceTypeByName(String resourceTypeName) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate(this.selectDeleteResourceTypeQuery(null), preparedStatement -> preparedStatement.setString(1, resourceTypeName));
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_DELETE_RESOURCE_TYPE, resourceTypeName, e);
        }
    }

    @Override
    public void deleteAttribute(String attributeId, String resourceId, String attributeKey) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("DELETE FROM IDN_CONFIG_ATTRIBUTE WHERE ID = ?", preparedStatement -> preparedStatement.setString(1, attributeId));
                template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET LAST_MODIFIED = ? WHERE ID = ?", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setTimestamp(initialParameterIndex, new Timestamp(new Date().getTime()), calendar);
                    preparedStatement.setString(++initialParameterIndex, resourceId);
                });
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_DELETE_ATTRIBUTE, attributeKey, e);
        }
    }

    @Override
    public void updateAttribute(String attributeId, String resourceId, Attribute attribute) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("UPDATE IDN_CONFIG_ATTRIBUTE SET ATTR_VALUE = ? WHERE ID = ?", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setString(initialParameterIndex, attribute.getValue());
                    preparedStatement.setString(++initialParameterIndex, attributeId);
                });
                template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET LAST_MODIFIED = ? WHERE ID = ?", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setTimestamp(initialParameterIndex, new Timestamp(new Date().getTime()), calendar);
                    preparedStatement.setString(++initialParameterIndex, resourceId);
                });
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_UPDATE_ATTRIBUTE, attribute.getKey(), e);
        }
    }

    @Override
    public void addAttribute(String attributeId, String resourceId, Attribute attribute) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("INSERT INTO IDN_CONFIG_ATTRIBUTE(ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES(?, ?, ?, ?)", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setString(initialParameterIndex, attributeId);
                    preparedStatement.setString(++initialParameterIndex, resourceId);
                    preparedStatement.setString(++initialParameterIndex, attribute.getKey());
                    preparedStatement.setString(++initialParameterIndex, attribute.getValue());
                });
                template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET LAST_MODIFIED = ? WHERE ID = ?", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setTimestamp(initialParameterIndex, new Timestamp(new Date().getTime()), calendar);
                    preparedStatement.setString(++initialParameterIndex, resourceId);
                });
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_INSERT_ATTRIBUTE, attribute.getKey(), e);
        }
    }

    @Override
    public void replaceAttribute(String attributeId, String resourceId, Attribute attribute) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                String query = "INSERT IDN_CONFIG_ATTRIBUTE(ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES(?, ?, ?, ?) ON DUPLICATE KEY UPDATE RESOURCE_ID = VALUES(RESOURCE_ID), ATTR_KEY = VALUES(ATTR_KEY), ATTR_VALUE = VALUES(ATTR_VALUE)";
                if (JdbcUtils.isH2()) {
                    query = "MERGE INTO IDN_CONFIG_ATTRIBUTE KEY(ID) VALUES(?, ?, ?, ?)";
                } else if (JdbcUtils.isPostgreSQLDB()) {
                    query = "INSERT INTO IDN_CONFIG_ATTRIBUTE(ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES(?, ?, ?, ?) ON CONFLICT(ID) DO UPDATE SET RESOURCE_ID = EXCLUDED.RESOURCE_ID, ATTR_KEY = EXCLUDED.ATTR_KEY, ATTR_VALUE = EXCLUDED.ATTR_VALUE";
                } else if (JdbcUtils.isMSSqlDB() || JdbcUtils.isDB2DB()) {
                    query = "MERGE INTO IDN_CONFIG_ATTRIBUTE T USING (VALUES  (?, ?, ?, ?)) S (ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) ON T.ID = S.ID WHEN MATCHED THEN UPDATE SET RESOURCE_ID = S.RESOURCE_ID, ATTR_KEY = S.ATTR_KEY,ATTR_VALUE = S.ATTR_VALUE WHEN NOT MATCHED THEN INSERT (ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES (S.ID, S.RESOURCE_ID, S.ATTR_KEY, S.ATTR_VALUE);";
                } else if (JdbcUtils.isOracleDB()) {
                    query = "MERGE INTO IDN_CONFIG_ATTRIBUTE USING dual ON (ID = ?) WHEN MATCHED THEN UPDATE SET RESOURCE_ID = ?, ATTR_KEY = ? , ATTR_VALUE = ? WHEN NOT MATCHED THEN INSERT (ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES (?, ?, ?, ?)";
                }
                template.executeUpdate(query, preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setString(initialParameterIndex, attributeId);
                    preparedStatement.setString(++initialParameterIndex, resourceId);
                    preparedStatement.setString(++initialParameterIndex, attribute.getKey());
                    preparedStatement.setString(++initialParameterIndex, attribute.getValue());
                });
                template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET LAST_MODIFIED = ? WHERE ID = ?", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setTimestamp(initialParameterIndex, new Timestamp(new Date().getTime()), calendar);
                    preparedStatement.setString(++initialParameterIndex, resourceId);
                });
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_REPLACE_ATTRIBUTE, attribute.getKey(), e);
        }
    }

    @Override
    public Attribute getAttributeByKey(String resourceId, String attributeKey) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return (Attribute)jdbcTemplate.fetchSingleRecord("SELECT\n  ID,\n  RESOURCE_ID,\n  ATTR_KEY,\n  ATTR_VALUE\nFROM\n  IDN_CONFIG_ATTRIBUTE\nWHERE\n  ATTR_KEY = ?\n  AND RESOURCE_ID = ?", (resultSet, rowNumber) -> new Attribute(resultSet.getString("ATTR_KEY"), resultSet.getString("ATTR_VALUE"), resultSet.getString("ID")), preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, attributeKey);
                preparedStatement.setString(++initialParameterIndex, resourceId);
            });
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_ATTRIBUTE, attributeKey, e);
        }
    }

    private void updateMetadataForMYSQL(Resource resource, String resourceTypeId, boolean isAttributeExists, Timestamp currentTime, boolean useCreatedTime) throws TransactionException, ConfigurationManagementServerException {
        String query = "INSERT INTO  IDN_CONFIG_RESOURCE(\n    ID,\n    TENANT_ID,\n    NAME,\n    CREATED_TIME,\n    LAST_MODIFIED,\n    HAS_FILE,\n    HAS_ATTRIBUTE,\n    TYPE_ID\n  )\nVALUES(?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE TENANT_ID = VALUES(TENANT_ID), NAME = VALUES(NAME), LAST_MODIFIED = VALUES(LAST_MODIFIED), HAS_FILE = VALUES(HAS_FILE), HAS_ATTRIBUTE = VALUES(HAS_ATTRIBUTE), TYPE_ID = VALUES(TYPE_ID)";
        try {
            if (JdbcUtils.isPostgreSQLDB()) {
                query = "INSERT INTO IDN_CONFIG_RESOURCE(ID, TENANT_ID, NAME, CREATED_TIME, LAST_MODIFIED, HAS_FILE, HAS_ATTRIBUTE, TYPE_ID) VALUES(?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT (ID) DO UPDATE SET TENANT_ID = EXCLUDED.TENANT_ID, NAME = EXCLUDED.NAME, LAST_MODIFIED = EXCLUDED.LAST_MODIFIED, HAS_FILE = EXCLUDED.HAS_FILE, HAS_ATTRIBUTE = EXCLUDED.HAS_ATTRIBUTE, TYPE_ID = EXCLUDED.TYPE_ID";
            } else if (JdbcUtils.isMSSqlDB() || JdbcUtils.isDB2DB()) {
                query = "MERGE INTO IDN_CONFIG_RESOURCE T USING (VALUES (?, ?, ?, ?, ?, ?, ?, ?)) S (ID, TENANT_ID, NAME, CREATED_TIME, LAST_MODIFIED, HAS_FILE, HAS_ATTRIBUTE, TYPE_ID) ON T.ID = S.ID WHEN MATCHED THEN UPDATE SET TENANT_ID = S.TENANT_ID, NAME = S.NAME, LAST_MODIFIED = S.LAST_MODIFIED, HAS_FILE = S.HAS_FILE, HAS_ATTRIBUTE = S.HAS_ATTRIBUTE, TYPE_ID = S.TYPE_ID WHEN NOT MATCHED THEN INSERT (ID, TENANT_ID, NAME, CREATED_TIME, LAST_MODIFIED, HAS_FILE, HAS_ATTRIBUTE,TYPE_ID) VALUES (S.ID, S.TENANT_ID, S.NAME, S.CREATED_TIME, S.LAST_MODIFIED, S.HAS_FILE, S.HAS_ATTRIBUTE, S.TYPE_ID);";
            } else if (JdbcUtils.isOracleDB()) {
                query = "MERGE INTO IDN_CONFIG_RESOURCE USING dual ON (ID = ?) WHEN MATCHED THEN UPDATE SET TENANT_ID = ?, NAME = ? , LAST_MODIFIED = ?, HAS_FILE = ?, HAS_ATTRIBUTE = ?, TYPE_ID = ? WHEN NOT MATCHED THEN INSERT (ID, TENANT_ID, NAME, CREATED_TIME, LAST_MODIFIED, HAS_FILE, HAS_ATTRIBUTE, TYPE_ID) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
            }
            boolean isOracleOrMssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            String finalQuery = query;
            jdbcTemplate.withTransaction(template -> template.executeInsert(useCreatedTime ? finalQuery : "INSERT INTO\n  IDN_CONFIG_RESOURCE(\n    ID,\n    TENANT_ID,\n    NAME,\n    LAST_MODIFIED,\n    HAS_FILE,\n    HAS_ATTRIBUTE,\n    TYPE_ID\n  )\nVALUES(?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE TENANT_ID = VALUES(TENANT_ID), NAME = VALUES(NAME), LAST_MODIFIED = VALUES(LAST_MODIFIED), HAS_FILE = VALUES(HAS_FILE), HAS_ATTRIBUTE = VALUES(HAS_ATTRIBUTE), TYPE_ID = VALUES(TYPE_ID)", preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resource.getResourceId());
                preparedStatement.setInt(++initialParameterIndex, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                preparedStatement.setString(++initialParameterIndex, resource.getResourceName());
                if (useCreatedTime) {
                    preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                }
                preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                if (isOracleOrMssql) {
                    preparedStatement.setInt(++initialParameterIndex, 0);
                    preparedStatement.setInt(++initialParameterIndex, isAttributeExists ? 1 : 0);
                } else {
                    preparedStatement.setBoolean(++initialParameterIndex, false);
                    preparedStatement.setBoolean(++initialParameterIndex, isAttributeExists);
                }
                preparedStatement.setString(++initialParameterIndex, resourceTypeId);
            }, (Object)resource, false));
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
        }
    }

    private void updateMetadataForH2(Resource resource, String resourceTypeId, boolean isAttributeExists, Timestamp currentTime, boolean useCreatedTime) throws TransactionException, ConfigurationManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        if (this.isResourceExists(resource, resourceTypeId)) {
            jdbcTemplate.withTransaction(template -> template.executeInsert("UPDATE IDN_CONFIG_RESOURCE SET TENANT_ID = ?, NAME = ?, LAST_MODIFIED = ?, HAS_FILE = ?, HAS_ATTRIBUTE = ?, TYPE_ID = ? WHERE ID = ?", preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setInt(initialParameterIndex, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                preparedStatement.setString(++initialParameterIndex, resource.getResourceName());
                preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                preparedStatement.setBoolean(++initialParameterIndex, false);
                preparedStatement.setBoolean(++initialParameterIndex, isAttributeExists);
                preparedStatement.setString(++initialParameterIndex, resourceTypeId);
                preparedStatement.setString(++initialParameterIndex, resource.getResourceId());
            }, (Object)resource, false));
        } else {
            try {
                boolean isOracleOrMsssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
                jdbcTemplate.withTransaction(template -> template.executeInsert(useCreatedTime ? "INSERT INTO\n  IDN_CONFIG_RESOURCE(\n    ID,\n    TENANT_ID,\n    NAME,\n    CREATED_TIME,\n    LAST_MODIFIED,\n    HAS_FILE,\n    HAS_ATTRIBUTE,\n    TYPE_ID\n  )\nVALUES(?, ?, ?, ?, ?, ?, ?, ?)" : "INSERT INTO\n  IDN_CONFIG_RESOURCE(\n    ID,\n    TENANT_ID,\n    NAME,\n    LAST_MODIFIED,\n    HAS_FILE,    HAS_ATTRIBUTE,    TYPE_ID  )VALUES(?, ?, ?, ?, ?, ?, ?)", preparedStatement -> {
                    int initialParameterIndex = 1;
                    preparedStatement.setString(initialParameterIndex, resource.getResourceId());
                    preparedStatement.setInt(++initialParameterIndex, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
                    preparedStatement.setString(++initialParameterIndex, resource.getResourceName());
                    if (useCreatedTime) {
                        preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                    }
                    preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                    if (isOracleOrMsssql) {
                        preparedStatement.setInt(++initialParameterIndex, 0);
                        preparedStatement.setInt(++initialParameterIndex, isAttributeExists ? 1 : 0);
                    } else {
                        preparedStatement.setBoolean(++initialParameterIndex, false);
                        preparedStatement.setBoolean(++initialParameterIndex, isAttributeExists);
                    }
                    preparedStatement.setString(++initialParameterIndex, resourceTypeId);
                }, (Object)resource, false));
            }
            catch (DataAccessException e) {
                throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
            }
        }
    }

    private void updateResourceMetadata(Template<?> template, Resource resource, boolean isAttributeExists, boolean isFileExists, Timestamp currentTime) throws ConfigurationManagementClientException, DataAccessException {
        try {
            boolean isOracleOrMssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
            template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET NAME = ?, LAST_MODIFIED = ?, HAS_FILE = ?, HAS_ATTRIBUTE = ? WHERE ID = ?", preparedStatement -> {
                int initialParameterIndex = 1;
                preparedStatement.setString(initialParameterIndex, resource.getResourceName());
                preparedStatement.setTimestamp(++initialParameterIndex, currentTime, calendar);
                if (isOracleOrMssql) {
                    preparedStatement.setInt(++initialParameterIndex, isFileExists ? 1 : 0);
                    preparedStatement.setInt(++initialParameterIndex, isAttributeExists ? 1 : 0);
                } else {
                    preparedStatement.setBoolean(++initialParameterIndex, isFileExists);
                    preparedStatement.setBoolean(++initialParameterIndex, isAttributeExists);
                }
                preparedStatement.setString(++initialParameterIndex, resource.getResourceId());
            });
        }
        catch (DataAccessException e) {
            if (e.getCause() instanceof SQLIntegrityConstraintViolationException) {
                throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_ALREADY_EXISTS, resource.getResourceName(), e);
            }
            throw e;
        }
    }

    private boolean isResourceExists(Resource resource, String resourceTypeId) throws TransactionException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        String resourceId = (String)jdbcTemplate.withTransaction(template -> (String)template.fetchSingleRecord("SELECT ID FROM IDN_CONFIG_RESOURCE WHERE NAME = ? AND TENANT_ID = ? AND TYPE_ID = ?", (resultSet, rowNumber) -> resultSet.getString("ID"), preparedStatement -> {
            int initialParameterIndex = 1;
            preparedStatement.setString(initialParameterIndex, resource.getResourceName());
            preparedStatement.setInt(++initialParameterIndex, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            preparedStatement.setString(++initialParameterIndex, resourceTypeId);
        }));
        return resourceId != null;
    }

    private PlaceholderSQL buildPlaceholderSQL(Condition condition, boolean useCreatedTime) throws ConfigurationManagementException {
        String queryWithCreatedTime = "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.CREATED_TIME,\n  R.LAST_MODIFIED,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\n";
        String queryWithOutCreatedTime = "SELECT\n  R.ID,\n  R.TENANT_ID,\n  R.NAME,\n  R.LAST_MODIFIED,\n  T.NAME AS RESOURCE_TYPE,\n  T.DESCRIPTION AS DESCRIPTION,\n  F.ID AS FILE_ID,\n  A.ID AS ATTR_ID,\n  A.ATTR_KEY AS ATTR_KEY,\n  A.ATTR_VALUE AS ATTR_VALUE\nFROM\n  IDN_CONFIG_RESOURCE AS R\n  INNER JOIN IDN_CONFIG_TYPE AS T ON R.TYPE_ID = T.ID\n  LEFT JOIN IDN_CONFIG_ATTRIBUTE AS A ON (\n    R.HAS_ATTRIBUTE = TRUE\n    AND A.RESOURCE_ID = R.ID\n  )\n  LEFT JOIN IDN_CONFIG_FILE AS F ON (\n    R.HAS_FILE = TRUE\n    AND F.RESOURCE_ID = R.ID\n  )\n";
        try {
            if (JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB()) {
                queryWithCreatedTime = "SELECT   R.ID,   R.TENANT_ID,   R.NAME,   R.CREATED_TIME,   R.LAST_MODIFIED,   T.NAME  RESOURCE_TYPE,   T.DESCRIPTION  DESCRIPTION,   F.ID  FILE_ID,   A.ID  ATTR_ID,   A.ATTR_KEY  ATTR_KEY,   A.ATTR_VALUE  ATTR_VALUE FROM   IDN_CONFIG_RESOURCE  R   INNER JOIN IDN_CONFIG_TYPE  T ON R.TYPE_ID = T.ID   LEFT JOIN IDN_CONFIG_ATTRIBUTE  A ON (       R.HAS_ATTRIBUTE = 1       AND A.RESOURCE_ID = R.ID   )   LEFT JOIN IDN_CONFIG_FILE  F ON (       R.HAS_FILE = 1       AND F.RESOURCE_ID = R.ID   )";
            }
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(useCreatedTime ? queryWithCreatedTime : queryWithOutCreatedTime);
        sb.append("WHERE\n");
        try {
            PlaceholderSQL placeholderSQL = condition.buildQuery(new PrimitiveConditionValidator(new ResourceSearchBean()));
            placeholderSQL.setQuery(sb.append(placeholderSQL.getQuery()).toString());
            return placeholderSQL;
        }
        catch (PrimitiveConditionValidationException e) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_SEARCH_QUERY_SQL_PROPERTY_PARSE_ERROR, e.getMessage(), e);
        }
    }

    private Resources buildResourcesFromRawData(List<ConfigurationRawDataCollector> configurationRawDataCollectors) {
        HashMap resourcesCollector = new HashMap();
        HashMap attributes = new HashMap(0);
        HashMap resourceFiles = new HashMap(0);
        HashMap attributeKeySet = new HashMap();
        HashMap resourceFileIdSet = new HashMap();
        configurationRawDataCollectors.forEach(configurationRawDataCollector -> {
            String eachResourceId = configurationRawDataCollector.getResourceId();
            if (resourcesCollector.get(eachResourceId) == null) {
                Resource resource = new Resource();
                resource.setResourceId(configurationRawDataCollector.getResourceId());
                resource.setResourceName(configurationRawDataCollector.getResourceName());
                resource.setResourceType(configurationRawDataCollector.getResourceTypeName());
                resource.setHasFile(configurationRawDataCollector.isHasFile());
                resource.setHasAttribute(configurationRawDataCollector.isHasAttribute());
                if (configurationRawDataCollector.getCreatedTime() != null) {
                    resource.setCreatedTime(configurationRawDataCollector.getCreatedTime().toInstant().toString());
                }
                resource.setLastModified(configurationRawDataCollector.getLastModified().toInstant().toString());
                resource.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)configurationRawDataCollector.getTenantId()));
                attributes.put(eachResourceId, new ArrayList());
                attributeKeySet.put(eachResourceId, new ArrayList());
                resourceFiles.put(eachResourceId, new ArrayList());
                resourceFileIdSet.put(eachResourceId, new ArrayList());
                resourcesCollector.put(eachResourceId, resource);
            }
            if (!((List)attributeKeySet.get(eachResourceId)).contains(configurationRawDataCollector.getAttributeKey())) {
                ((List)attributeKeySet.get(eachResourceId)).add(configurationRawDataCollector.getAttributeKey());
                if (configurationRawDataCollector.getAttributeKey() != null) {
                    ((List)attributes.get(eachResourceId)).add(new Attribute(configurationRawDataCollector.getAttributeKey(), configurationRawDataCollector.getAttributeValue(), configurationRawDataCollector.getAttributeId()));
                }
            }
            if (!((List)resourceFileIdSet.get(eachResourceId)).contains(configurationRawDataCollector.getFileId())) {
                ((List)resourceFileIdSet.get(eachResourceId)).add(configurationRawDataCollector.getFileId());
                if (configurationRawDataCollector.getFileId() != null) {
                    ((List)resourceFiles.get(eachResourceId)).add(new ResourceFile(configurationRawDataCollector.getFileId(), configurationRawDataCollector.getFileName()));
                }
            }
        });
        resourcesCollector.values().forEach(resource -> {
            resource.setAttributes((List)attributes.get(resource.getResourceId()));
            resource.setFiles((List)resourceFiles.get(resource.getResourceId()));
        });
        return new Resources(new ArrayList<Resource>(resourcesCollector.values()));
    }

    private Resource buildResourceFromRawData(List<ConfigurationRawDataCollector> configurationRawDataCollectors) {
        Resource resource = new Resource();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(0);
        ArrayList<ResourceFile> resourceFiles = new ArrayList<ResourceFile>(0);
        HashSet attributeKeySet = new HashSet();
        HashSet fileIdSet = new HashSet();
        configurationRawDataCollectors.forEach(configurationRawDataCollector -> {
            if (resource.getResourceId() == null) {
                resource.setResourceId(configurationRawDataCollector.getResourceId());
                resource.setHasFile(configurationRawDataCollector.isHasFile());
                resource.setHasAttribute(configurationRawDataCollector.isHasAttribute());
                resource.setResourceName(configurationRawDataCollector.getResourceName());
                resource.setResourceType(configurationRawDataCollector.getResourceTypeName());
                if (configurationRawDataCollector.getCreatedTime() != null) {
                    resource.setCreatedTime(configurationRawDataCollector.getCreatedTime().toInstant().toString());
                }
                resource.setLastModified(configurationRawDataCollector.getLastModified().toInstant().toString());
                resource.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)configurationRawDataCollector.getTenantId()));
            }
            if (!attributeKeySet.contains(configurationRawDataCollector.getAttributeKey())) {
                attributeKeySet.add(configurationRawDataCollector.getAttributeKey());
                if (configurationRawDataCollector.getAttributeKey() != null) {
                    attributes.add(new Attribute(configurationRawDataCollector.getAttributeKey(), configurationRawDataCollector.getAttributeValue(), configurationRawDataCollector.getAttributeId()));
                }
            }
            if (!fileIdSet.contains(configurationRawDataCollector.getFileId())) {
                fileIdSet.add(configurationRawDataCollector.getFileId());
                if (configurationRawDataCollector.getFileId() != null) {
                    resourceFiles.add(new ResourceFile(configurationRawDataCollector.getFileId(), configurationRawDataCollector.getFileName()));
                }
            }
        });
        resource.setAttributes(attributes);
        resource.setFiles(resourceFiles);
        return resource;
    }

    private String buildQueryForAttributes(Resource resource) throws ConfigurationManagementClientException, DataAccessException {
        StringBuilder sb = new StringBuilder();
        if (JdbcUtils.isH2()) {
            sb.append("MERGE INTO\n  IDN_CONFIG_ATTRIBUTE KEY(ID) VALUES(?, ?, ?, ?)");
        } else if (JdbcUtils.isMySQLDB() || JdbcUtils.isPostgreSQLDB() || JdbcUtils.isMariaDB()) {
            sb.append("INSERT INTO\n  IDN_CONFIG_ATTRIBUTE(\n    ID,\n    RESOURCE_ID,\n    ATTR_KEY,\n    ATTR_VALUE\n  )\nVALUES(?, ?, ?, ?)");
        } else if (JdbcUtils.isMSSqlDB() || JdbcUtils.isDB2DB()) {
            sb.append("MERGE INTO IDN_CONFIG_ATTRIBUTE T USING (VALUES (?, ?, ?, ?)");
        } else if (JdbcUtils.isOracleDB()) {
            sb.append("MERGE INTO IDN_CONFIG_ATTRIBUTE T USING (SELECT ? ID, ? RESOURCE_ID, ? ATTR_KEY, ? ATTR_VALUE from dual ");
        }
        for (int i = 1; i < resource.getAttributes().size(); ++i) {
            if (JdbcUtils.isOracleDB()) {
                sb.append("UNION ALL SELECT ? ID, ? RESOURCE_ID, ? ATTR_KEY, ? ATTR_VALUE from dual ");
            } else {
                sb.append(", (?, ?, ?, ?)");
            }
            if (sb.toString().getBytes().length <= ConfigurationUtils.getMaximumQueryLengthInBytes()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error building SQL query for the attribute insert. Number of attributes: " + resource.getAttributes().size() + " exceeds the maximum limit: " + SQLConstants.MAX_QUERY_LENGTH_IN_BYTES_SQL));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_QUERY_LENGTH_EXCEEDED, null);
        }
        if (JdbcUtils.isMySQLDB() || JdbcUtils.isMariaDB()) {
            sb.append("ON DUPLICATE KEY UPDATE RESOURCE_ID = VALUES(RESOURCE_ID), ATTR_KEY = VALUES(ATTR_KEY), ATTR_VALUE = VALUES(ATTR_VALUE)");
        } else if (JdbcUtils.isPostgreSQLDB()) {
            sb.append("ON CONFLICT(ID) DO UPDATE SET RESOURCE_ID = EXCLUDED.RESOURCE_ID, ATTR_KEY = EXCLUDED.ATTR_KEY, ATTR_VALUE = EXCLUDED.ATTR_VALUE");
        } else if (JdbcUtils.isMSSqlDB() || JdbcUtils.isDB2DB()) {
            sb.append(") S (ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) ON T.ID = S.ID WHEN MATCHED THEN UPDATE SET RESOURCE_ID = S.RESOURCE_ID, ATTR_KEY = S.ATTR_KEY, ATTR_VALUE = S.ATTR_VALUE WHEN NOT MATCHED THEN INSERT (ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES (S.ID, S.RESOURCE_ID, S.ATTR_KEY, S.ATTR_VALUE);");
        } else if (JdbcUtils.isOracleDB()) {
            sb.append(") S ON (T.ID = S.ID) WHEN MATCHED THEN UPDATE SET T.RESOURCE_ID = S.RESOURCE_ID, T.ATTR_KEY = S.ATTR_KEY, T.ATTR_VALUE = S.ATTR_VALUE WHEN NOT MATCHED THEN INSERT (ID, RESOURCE_ID, ATTR_KEY, ATTR_VALUE) VALUES (S.ID, S.RESOURCE_ID, S.ATTR_KEY, S.ATTR_VALUE)");
        }
        return sb.toString();
    }

    private ResourceType getResourceTypeByIdentifier(String name, String id) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            ResourceType resourceTypeResponse = (ResourceType)jdbcTemplate.fetchSingleRecord(this.selectGetResourceTypeQuery(id), (resultSet, rowNumber) -> {
                ResourceType resourceType = new ResourceType();
                resourceType.setId(resultSet.getString("ID"));
                resourceType.setName(resultSet.getString("NAME"));
                resourceType.setDescription(resultSet.getString("DESCRIPTION"));
                return resourceType;
            }, preparedStatement -> preparedStatement.setString(1, StringUtils.isEmpty((String)name) ? id : name));
            return resourceTypeResponse;
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RESOURCE_TYPE, name, e);
        }
    }

    private String selectGetResourceTypeQuery(String id) {
        return StringUtils.isEmpty((String)id) ? "SELECT ID, NAME, DESCRIPTION FROM IDN_CONFIG_TYPE WHERE NAME = ? " : "SELECT ID, NAME, DESCRIPTION FROM IDN_CONFIG_TYPE WHERE ID = ? ";
    }

    private String selectDeleteResourceTypeQuery(String id) {
        return StringUtils.isEmpty((String)id) ? "DELETE FROM IDN_CONFIG_TYPE WHERE NAME = ?" : "DELETE FROM IDN_CONFIG_TYPE WHERE ID = ?";
    }

    private Timestamp getCreatedTimeInResponse(Resource resource, String resourceTypeId) throws TransactionException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        return (Timestamp)jdbcTemplate.withTransaction(template -> (Timestamp)template.fetchSingleRecord("SELECT\n  CREATED_TIME\nFROM\n  IDN_CONFIG_RESOURCE\nWHERE\n  NAME = ?\n  AND TENANT_ID = ?\n  AND TYPE_ID = ?", (resultSet, rowNumber) -> resultSet.getTimestamp("CREATED_TIME", calendar), preparedStatement -> {
            int initialParameterIndex = 1;
            preparedStatement.setString(initialParameterIndex, resource.getResourceName());
            preparedStatement.setInt(++initialParameterIndex, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
            preparedStatement.setString(++initialParameterIndex, resourceTypeId);
        }));
    }

    @Override
    public void addFile(String fileId, String resourceId, String fileName, InputStream fileStream) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            boolean isOracleOrMssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("INSERT INTO IDN_CONFIG_FILE(ID, VALUE, RESOURCE_ID, NAME) VALUES(?, ?, ?, ?)", preparedStatement -> {
                    preparedStatement.setString(1, fileId);
                    preparedStatement.setBlob(2, fileStream);
                    preparedStatement.setString(3, resourceId);
                    preparedStatement.setString(4, fileName);
                });
                template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET HAS_FILE = ? WHERE ID = ?", preparedStatement -> {
                    if (isOracleOrMssql) {
                        preparedStatement.setInt(1, 1);
                    } else {
                        preparedStatement.setBoolean(1, true);
                    }
                    preparedStatement.setString(2, resourceId);
                });
                this.updateResourceLastModified((Template<Object>)template, resourceId);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_INSERT_FILE, fileId, e);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
        }
    }

    @Override
    public InputStream getFileById(String resourceType, String resourceName, String fileId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return (InputStream)jdbcTemplate.fetchSingleRecord("SELECT IDN_CONFIG_FILE.ID, IDN_CONFIG_FILE.VALUE, IDN_CONFIG_FILE.RESOURCE_ID, IDN_CONFIG_FILE.NAME FROM IDN_CONFIG_FILE INNER JOIN IDN_CONFIG_RESOURCE ON IDN_CONFIG_FILE.RESOURCE_ID = IDN_CONFIG_RESOURCE.ID INNER JOIN IDN_CONFIG_TYPE ON IDN_CONFIG_RESOURCE.TYPE_ID = IDN_CONFIG_TYPE.ID where IDN_CONFIG_FILE.ID = ? and IDN_CONFIG_RESOURCE.NAME = ? and IDN_CONFIG_TYPE.NAME = ?", (resultSet, rowNumber) -> {
                Blob fileBlob = resultSet.getBlob("VALUE");
                if (fileBlob == null) {
                    return null;
                }
                return fileBlob.getBinaryStream();
            }, preparedStatement -> {
                preparedStatement.setString(1, fileId);
                preparedStatement.setString(2, resourceName);
                preparedStatement.setString(3, resourceType);
            });
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_FILE, fileId, e);
        }
    }

    @Override
    public void deleteFileById(String resourceType, String resourceName, String fileId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            boolean isOracleOrMssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
            jdbcTemplate.withTransaction(template -> {
                String resourceId = (String)template.fetchSingleRecord("SELECT IDN_CONFIG_FILE.ID, IDN_CONFIG_FILE.VALUE, IDN_CONFIG_FILE.RESOURCE_ID, IDN_CONFIG_FILE.NAME FROM IDN_CONFIG_FILE INNER JOIN IDN_CONFIG_RESOURCE ON IDN_CONFIG_FILE.RESOURCE_ID = IDN_CONFIG_RESOURCE.ID INNER JOIN IDN_CONFIG_TYPE ON IDN_CONFIG_RESOURCE.TYPE_ID = IDN_CONFIG_TYPE.ID where IDN_CONFIG_FILE.ID = ? and IDN_CONFIG_RESOURCE.NAME = ? and IDN_CONFIG_TYPE.NAME = ?", (resultSet, rowNumber) -> resultSet.getString("RESOURCE_ID"), preparedStatement -> {
                    preparedStatement.setString(1, fileId);
                    preparedStatement.setString(2, resourceName);
                    preparedStatement.setString(3, resourceType);
                });
                template.executeUpdate("DELETE FROM IDN_CONFIG_FILE WHERE ID = ?", preparedStatement -> preparedStatement.setString(1, fileId));
                List availableFilesForTheResource = template.executeQuery("SELECT\n  ID,\n  NAME\nFROM\n  IDN_CONFIG_FILE\nWHERE\n  RESOURCE_ID = ?", (resultSet, rowNumber) -> resultSet.getString("ID"), preparedStatement -> preparedStatement.setString(1, resourceId));
                if (availableFilesForTheResource.isEmpty()) {
                    template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET HAS_FILE = ? WHERE ID = ?", preparedStatement -> {
                        if (isOracleOrMssql) {
                            preparedStatement.setInt(1, 0);
                        } else {
                            preparedStatement.setBoolean(1, false);
                        }
                        preparedStatement.setString(2, resourceId);
                    });
                }
                this.updateResourceLastModified((Template<Object>)template, resourceId);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_DELETE_FILE, fileId, e);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
        }
    }

    private void updateResourceLastModified(Template<Object> template, String resourceId) throws DataAccessException {
        template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET LAST_MODIFIED = ? WHERE ID = ?", preparedStatement -> {
            preparedStatement.setTimestamp(1, new Timestamp(new Date().getTime()), Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
            preparedStatement.setString(2, resourceId);
        });
    }

    @Override
    public List<ResourceFile> getFiles(String resourceId, String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return jdbcTemplate.executeQuery("SELECT\n  ID,\n  NAME\nFROM\n  IDN_CONFIG_FILE\nWHERE\n  RESOURCE_ID = ?", (resultSet, rowNumber) -> {
                String resourceFileId = resultSet.getString("ID");
                String resourceFileName = resultSet.getString("NAME");
                return new ResourceFile(resourceFileId, ConfigurationUtils.getFilePath(resourceFileId, resourceTypeName, resourceName), resourceFileName);
            }, preparedStatement -> preparedStatement.setString(1, resourceId));
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_FILES, resourceName, e);
        }
    }

    @Override
    public List<ResourceFile> getFilesByResourceType(String resourceTypeId, int tenantId) throws ConfigurationManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return jdbcTemplate.executeQuery("SELECT IDN_CONFIG_FILE.ID, IDN_CONFIG_FILE.NAME FILE_NAME, IDN_CONFIG_RESOURCE.NAME RESOURCE_NAME, IDN_CONFIG_TYPE.NAME TYPE_NAME FROM IDN_CONFIG_FILE  INNER JOIN IDN_CONFIG_RESOURCE  ON IDN_CONFIG_FILE.RESOURCE_ID = IDN_CONFIG_RESOURCE.ID INNER JOIN IDN_CONFIG_TYPE ON IDN_CONFIG_RESOURCE.TYPE_ID = IDN_CONFIG_TYPE.ID where IDN_CONFIG_TYPE.ID = ? AND IDN_CONFIG_RESOURCE.TENANT_ID = ?", (resultSet, rowNumber) -> {
                String resourceFileId = resultSet.getString("ID");
                String resourceFileName = resultSet.getString("FILE_NAME");
                String resourceName = resultSet.getString("RESOURCE_NAME");
                String resourceTypeName = resultSet.getString("TYPE_NAME");
                return new ResourceFile(resourceFileId, ConfigurationUtils.getFilePath(resourceFileId, resourceTypeName, resourceName), resourceFileName);
            }, preparedStatement -> {
                preparedStatement.setString(1, resourceTypeId);
                preparedStatement.setInt(2, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_FILES_BY_TYPE, resourceTypeId, e);
        }
    }

    @Override
    public void deleteFiles(String resourceId) throws ConfigurationManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            boolean isOracleOrMssql = JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB();
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("DELETE FROM IDN_CONFIG_FILE WHERE RESOURCE_ID = ?", preparedStatement -> preparedStatement.setString(1, resourceId));
                template.executeUpdate("UPDATE IDN_CONFIG_RESOURCE SET HAS_FILE = ? WHERE ID = ?", preparedStatement -> {
                    if (isOracleOrMssql) {
                        preparedStatement.setInt(1, 0);
                    } else {
                        preparedStatement.setBoolean(1, false);
                    }
                    preparedStatement.setString(2, resourceId);
                });
                this.updateResourceLastModified((Template<Object>)template, resourceId);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_DELETE_FILES, resourceId, e);
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_CHECK_DB_METADATA, e.getMessage(), e);
        }
    }

    @Override
    public List<Resource> getResourcesByType(int tenantId, String resourceTypeId) throws ConfigurationManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return jdbcTemplate.executeQuery("SELECT IDN_CONFIG_RESOURCE.ID, IDN_CONFIG_RESOURCE.TENANT_ID, IDN_CONFIG_RESOURCE.NAME, IDN_CONFIG_RESOURCE.LAST_MODIFIED, IDN_CONFIG_RESOURCE.CREATED_TIME, IDN_CONFIG_RESOURCE.HAS_FILE, IDN_CONFIG_RESOURCE.HAS_ATTRIBUTE FROM IDN_CONFIG_RESOURCE WHERE IDN_CONFIG_RESOURCE.TYPE_ID = ? and IDN_CONFIG_RESOURCE.TENANT_ID = ?", LambdaExceptionUtils.rethrowRowMapper((resultSet, rowNumber) -> {
                String resourceId = resultSet.getString("ID");
                String resourceName = resultSet.getString("NAME");
                String resourceLastModified = resultSet.getString("LAST_MODIFIED");
                String resourceCreatedTime = resultSet.getString("CREATED_TIME");
                String resourceHasFile = resultSet.getString("HAS_FILE");
                if (StringUtils.equals((String)resourceHasFile, (String)"1") && (JdbcUtils.isOracleDB() || JdbcUtils.isMSSqlDB() || JdbcUtils.isDB2DB())) {
                    resourceHasFile = "true";
                }
                String resourceHasAttribute = resultSet.getString("HAS_ATTRIBUTE");
                Resource resource = new Resource();
                resource.setCreatedTime(resourceCreatedTime);
                resource.setHasAttribute(Boolean.valueOf(resourceHasAttribute));
                resource.setResourceId(resourceId);
                resource.setResourceName(resourceName);
                resource.setLastModified(resourceLastModified);
                resource.setHasFile(Boolean.valueOf(resourceHasFile));
                resource.setTenantDomain(IdentityTenantUtil.getTenantDomain((int)tenantId));
                resource.setFiles(this.getFilesByResourceType(resourceTypeId, tenantId));
                resource.setAttributes(this.getAttributesByResourceId(resourceId));
                return resource;
            }), preparedStatement -> {
                preparedStatement.setString(1, resourceTypeId);
                preparedStatement.setString(2, Integer.toString(tenantId));
            });
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCES_DOES_NOT_EXISTS, e);
        }
    }

    private List<Attribute> getAttributesByResourceId(String resourceId) throws ConfigurationManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return jdbcTemplate.executeQuery("SELECT\n  ID,\n  ATTR_KEY,\n  ATTR_VALUE\n  FROM\n  IDN_CONFIG_ATTRIBUTE\n  WHERE\n  RESOURCE_ID = ?", (resultSet, rowNumber) -> {
                String attributeId = resultSet.getString("ID");
                String attributeKey = resultSet.getString("ATTR_KEY");
                String attributeValue = resultSet.getString("ATTR_VALUE");
                return new Attribute(attributeKey, attributeValue, attributeId);
            }, preparedStatement -> preparedStatement.setString(1, resourceId));
        }
        catch (DataAccessException e) {
            throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_FILES_BY_TYPE, resourceId, e);
        }
    }

    private void insertResourceAttributes(Template<?> template, Resource resource) throws DataAccessException, ConfigurationManagementClientException {
        String attributesQuery = this.buildQueryForAttributes(resource);
        template.executeInsert(attributesQuery, preparedStatement -> {
            int attributeUpdateParameterIndex = 0;
            for (Attribute attribute : resource.getAttributes()) {
                preparedStatement.setString(++attributeUpdateParameterIndex, ConfigurationUtils.generateUniqueID());
                preparedStatement.setString(++attributeUpdateParameterIndex, resource.getResourceId());
                preparedStatement.setString(++attributeUpdateParameterIndex, attribute.getKey());
                preparedStatement.setString(++attributeUpdateParameterIndex, attribute.getValue());
            }
        }, (Object)resource, false);
    }
}

