/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core.dao.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.configuration.mgt.core.cache.ResourceByIdCache;
import org.wso2.carbon.identity.configuration.mgt.core.cache.ResourceByIdCacheKey;
import org.wso2.carbon.identity.configuration.mgt.core.cache.ResourceByNameCache;
import org.wso2.carbon.identity.configuration.mgt.core.cache.ResourceByNameCacheKey;
import org.wso2.carbon.identity.configuration.mgt.core.cache.ResourceCacheEntry;
import org.wso2.carbon.identity.configuration.mgt.core.constant.ConfigurationConstants;
import org.wso2.carbon.identity.configuration.mgt.core.dao.ConfigurationDAO;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementException;
import org.wso2.carbon.identity.configuration.mgt.core.internal.ConfigurationManagerComponentDataHolder;
import org.wso2.carbon.identity.configuration.mgt.core.model.Attribute;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceFile;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceType;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resources;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.user.api.UserStoreException;

public class CachedBackedConfigurationDAO
implements ConfigurationDAO {
    private static final Log log = LogFactory.getLog(CachedBackedConfigurationDAO.class);
    private final ConfigurationDAO configurationDAO;
    private final ResourceByIdCache resourceByIdCache;
    private final ResourceByNameCache resourceByNameCache;

    public CachedBackedConfigurationDAO(ConfigurationDAO configurationDAO) {
        this.configurationDAO = configurationDAO;
        this.resourceByIdCache = ResourceByIdCache.getInstance();
        this.resourceByNameCache = ResourceByNameCache.getInstance();
    }

    @Override
    public int getPriority() {
        return 2;
    }

    @Override
    public Resources getTenantResources(Condition condition) throws ConfigurationManagementException {
        return this.configurationDAO.getTenantResources(condition);
    }

    @Override
    public Resource getResourceByName(int tenantId, String resourceTypeId, String name) throws ConfigurationManagementException {
        Resource resource = this.getResourceFromCacheByName(name, tenantId);
        if (resource != null) {
            if (log.isDebugEnabled()) {
                String message = String.format("Cache hit for resource by it's name. Resource name: %s, Tenant id: %d, Resource type id: %s", name, tenantId, resourceTypeId);
                log.debug((Object)message);
            }
            return resource;
        }
        if (log.isDebugEnabled()) {
            String message = String.format("Cache miss for resource by it's name. Resource name: %s, Tenant id: %d, Resource type id: %s", name, tenantId, resourceTypeId);
            log.debug((Object)message);
        }
        resource = this.configurationDAO.getResourceByName(tenantId, resourceTypeId, name);
        this.addResourceToCache(resource);
        return resource;
    }

    @Override
    public Resource getResourceById(String resourceId) throws ConfigurationManagementException {
        Resource resource = this.getResourceFromCacheById(resourceId, "carbon.super");
        if (resource != null) {
            if (log.isDebugEnabled()) {
                String message = String.format("Cache hit for resource by it's id. Resource id: %s", resourceId);
                log.debug((Object)message);
            }
            return resource;
        }
        if (log.isDebugEnabled()) {
            String message = String.format("Cache miss for resource by it's id. Resource id: %s", resourceId);
            log.debug((Object)message);
        }
        resource = this.configurationDAO.getResourceById(resourceId);
        this.addResourceToCache(resource);
        return resource;
    }

    @Override
    public Resource getTenantResourceById(int tenantId, String resourceId) throws ConfigurationManagementException {
        return this.configurationDAO.getTenantResourceById(tenantId, resourceId);
    }

    @Override
    public void deleteResourceById(int tenantId, String resourceId) throws ConfigurationManagementException {
        this.configurationDAO.deleteResourceById(tenantId, resourceId);
        this.deleteCacheByResourceId(resourceId, tenantId);
    }

    @Override
    public void replaceResourceWithFiles(Resource resource) throws ConfigurationManagementException {
        this.configurationDAO.replaceResourceWithFiles(resource);
        this.deleteResourceFromCache(resource);
    }

    @Override
    public void deleteResourceByName(int tenantId, String resourceTypeId, String name) throws ConfigurationManagementException {
        this.configurationDAO.deleteResourceByName(tenantId, resourceTypeId, name);
        this.deleteCacheByResourceByName(name, tenantId);
    }

    @Override
    public void addResource(Resource resource) throws ConfigurationManagementException {
        this.configurationDAO.addResource(resource);
        this.addResourceToCache(resource);
    }

    @Override
    public void replaceResource(Resource resource) throws ConfigurationManagementException {
        this.configurationDAO.replaceResource(resource);
        this.deleteResourceFromCache(resource);
    }

    @Override
    public void addResourceType(ResourceType resourceType) throws ConfigurationManagementException {
        this.configurationDAO.addResourceType(resourceType);
    }

    @Override
    public void replaceResourceType(ResourceType resourceType) throws ConfigurationManagementException {
        this.configurationDAO.replaceResourceType(resourceType);
    }

    @Override
    public ResourceType getResourceTypeByName(String resourceTypeName) throws ConfigurationManagementException {
        return this.configurationDAO.getResourceTypeByName(resourceTypeName);
    }

    @Override
    public ResourceType getResourceTypeById(String resourceTypeId) throws ConfigurationManagementException {
        return this.configurationDAO.getResourceTypeById(resourceTypeId);
    }

    @Override
    public void deleteResourceTypeByName(String resourceTypeName) throws ConfigurationManagementException {
        this.configurationDAO.deleteResourceTypeByName(resourceTypeName);
    }

    @Override
    public Attribute getAttributeByKey(String resourceId, String attributeKey) throws ConfigurationManagementException {
        return this.configurationDAO.getAttributeByKey(resourceId, attributeKey);
    }

    @Override
    public void updateAttribute(String attributeId, String resourceId, Attribute attribute) throws ConfigurationManagementException {
        this.configurationDAO.updateAttribute(attributeId, resourceId, attribute);
    }

    @Override
    public void addAttribute(String attributeId, String resourceId, Attribute attribute) throws ConfigurationManagementException {
        this.configurationDAO.addAttribute(attributeId, resourceId, attribute);
    }

    @Override
    public void replaceAttribute(String attributeId, String resourceId, Attribute attribute) throws ConfigurationManagementException {
        this.configurationDAO.replaceAttribute(attributeId, resourceId, attribute);
    }

    @Override
    public void deleteAttribute(String attributeId, String resourceId, String attributeKey) throws ConfigurationManagementException {
        this.configurationDAO.deleteAttribute(attributeId, resourceId, attributeKey);
    }

    @Override
    public void addFile(String fileId, String resourceId, String fileName, InputStream fileStream) throws ConfigurationManagementException {
        this.configurationDAO.addFile(fileId, resourceId, fileName, fileStream);
    }

    @Override
    public InputStream getFileById(String resourceType, String resourceName, String fileId) throws ConfigurationManagementException {
        return this.configurationDAO.getFileById(resourceType, resourceName, fileId);
    }

    @Override
    public List<ResourceFile> getFiles(String resourceId, String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        return this.configurationDAO.getFiles(resourceId, resourceTypeName, resourceName);
    }

    @Override
    public List<ResourceFile> getFilesByResourceType(String resourceTypeId, int tenantId) throws ConfigurationManagementException {
        return this.configurationDAO.getFilesByResourceType(resourceTypeId, tenantId);
    }

    @Override
    public void deleteFileById(String resourceType, String resourceName, String fileId) throws ConfigurationManagementException {
        this.configurationDAO.deleteFileById(resourceType, resourceName, fileId);
    }

    @Override
    public void deleteFiles(String resourceId) throws ConfigurationManagementException {
        this.configurationDAO.deleteFiles(resourceId);
    }

    @Override
    public List getResourcesByType(int tenantId, String resourceTypeId) throws ConfigurationManagementException {
        return this.configurationDAO.getResourcesByType(tenantId, resourceTypeId);
    }

    @Override
    public boolean isExistingResource(int tenantId, String resourceId) throws ConfigurationManagementException {
        return this.configurationDAO.isExistingResource(tenantId, resourceId);
    }

    private Resource getResourceFromCacheById(String resourceId, int tenantId) throws ConfigurationManagementException {
        try {
            String tenantDomain = ConfigurationManagerComponentDataHolder.getInstance().getRealmService().getTenantManager().getDomain(tenantId);
            return this.getResourceFromCacheById(resourceId, tenantDomain);
        }
        catch (UserStoreException e) {
            throw new ConfigurationManagementException("Error when setting tenant domain. ", ConfigurationConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getCode(), e);
        }
    }

    private Resource getResourceFromCacheByName(String resourceName, int tenantId) throws ConfigurationManagementException {
        try {
            String tenantDomain = ConfigurationManagerComponentDataHolder.getInstance().getRealmService().getTenantManager().getDomain(tenantId);
            return this.getResourceFromCacheByName(resourceName, tenantDomain);
        }
        catch (UserStoreException e) {
            throw new ConfigurationManagementException("Error when setting tenant domain. ", ConfigurationConstants.ErrorMessages.ERROR_CODE_UNEXPECTED.getCode(), e);
        }
    }

    private Resource getResourceFromCacheById(String resourceId, String tenantDomain) throws ConfigurationManagementException {
        ResourceByIdCacheKey resourceByIdCacheKey = new ResourceByIdCacheKey(resourceId, tenantDomain);
        ResourceCacheEntry resourceCacheEntry = (ResourceCacheEntry)((Object)this.resourceByIdCache.getValueFromCache((Serializable)((Object)resourceByIdCacheKey)));
        if (resourceCacheEntry != null) {
            if (log.isDebugEnabled()) {
                String message = String.format("Entry found from Resource by id cache. Resource id: %s., Tenant domain %s", resourceId, tenantDomain);
                log.debug((Object)message);
            }
            return resourceCacheEntry.getResource();
        }
        return null;
    }

    private Resource getResourceFromCacheByName(String resourceName, String tenantDomain) throws ConfigurationManagementException {
        ResourceByNameCacheKey resourceByNameCacheKey = new ResourceByNameCacheKey(resourceName, tenantDomain);
        ResourceCacheEntry resourceCacheEntry = (ResourceCacheEntry)((Object)this.resourceByNameCache.getValueFromCache((Serializable)((Object)resourceByNameCacheKey)));
        if (resourceCacheEntry != null) {
            if (log.isDebugEnabled()) {
                String message = String.format("Entry found from Resource by name cache. Resource id: %s., Tenant domain %s", resourceName, tenantDomain);
                log.debug((Object)message);
            }
            return resourceCacheEntry.getResource();
        }
        return null;
    }

    private void addResourceToCache(Resource resource) throws ConfigurationManagementException {
        if (resource == null) {
            return;
        }
        ResourceByIdCacheKey resourceByIdCacheKey = new ResourceByIdCacheKey(resource.getResourceId(), resource.getTenantDomain());
        ResourceByNameCacheKey resourceByNameCacheKey = new ResourceByNameCacheKey(resource.getResourceName(), resource.getTenantDomain());
        ResourceCacheEntry resourceCacheEntry = new ResourceCacheEntry(resource);
        if (log.isDebugEnabled()) {
            String message = String.format("Following two cache entries created. 1. Resource by name cache %s, 2. Resource by id cache %s. Tenant domain for all caches: %s", resource.getResourceName(), resource.getResourceId(), resource.getTenantDomain());
            log.debug((Object)message);
        }
        this.resourceByIdCache.addToCache((Serializable)((Object)resourceByIdCacheKey), (Serializable)((Object)resourceCacheEntry));
        this.resourceByNameCache.addToCache((Serializable)((Object)resourceByNameCacheKey), (Serializable)((Object)resourceCacheEntry));
    }

    private void deleteResourceFromCache(Resource resource) throws ConfigurationManagementException {
        if (resource == null) {
            return;
        }
        ResourceByIdCacheKey resourceByIdCacheKey = new ResourceByIdCacheKey(resource.getResourceId(), resource.getTenantDomain());
        ResourceByNameCacheKey resourceByNameCacheKey = new ResourceByNameCacheKey(resource.getResourceName(), resource.getTenantDomain());
        if (log.isDebugEnabled()) {
            String message = String.format("Following two cache entries deleted. 1. Resource by name cache %s, 2. Resource by id cache %s. Tenant domain for all caches: %s", resource.getResourceName(), resource.getResourceId(), resource.getTenantDomain());
            log.debug((Object)message);
        }
        this.resourceByIdCache.clearCacheEntry((Serializable)((Object)resourceByIdCacheKey));
        this.resourceByNameCache.clearCacheEntry((Serializable)((Object)resourceByNameCacheKey));
    }

    private void deleteCacheByResourceId(String resourceId, int tenantId) throws ConfigurationManagementException {
        Resource resource = this.getResourceFromCacheById(resourceId, tenantId);
        if (resource == null) {
            return;
        }
        this.deleteResourceFromCache(resource);
    }

    private void deleteCacheByResourceByName(String resourceName, int tenantId) throws ConfigurationManagementException {
        Resource resource = this.getResourceFromCacheByName(resourceName, tenantId);
        if (resource == null) {
            return;
        }
        this.deleteResourceFromCache(resource);
    }
}

