/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.configuration.mgt.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.identity.configuration.mgt.core.ConfigurationManager;
import org.wso2.carbon.identity.configuration.mgt.core.constant.ConfigurationConstants;
import org.wso2.carbon.identity.configuration.mgt.core.dao.ConfigurationDAO;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementClientException;
import org.wso2.carbon.identity.configuration.mgt.core.exception.ConfigurationManagementException;
import org.wso2.carbon.identity.configuration.mgt.core.internal.ConfigurationManagerComponentDataHolder;
import org.wso2.carbon.identity.configuration.mgt.core.model.Attribute;
import org.wso2.carbon.identity.configuration.mgt.core.model.ConfigurationManagerConfigurationHolder;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resource;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceAdd;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceFile;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceType;
import org.wso2.carbon.identity.configuration.mgt.core.model.ResourceTypeAdd;
import org.wso2.carbon.identity.configuration.mgt.core.model.Resources;
import org.wso2.carbon.identity.configuration.mgt.core.search.ComplexCondition;
import org.wso2.carbon.identity.configuration.mgt.core.search.Condition;
import org.wso2.carbon.identity.configuration.mgt.core.search.PrimitiveCondition;
import org.wso2.carbon.identity.configuration.mgt.core.search.constant.ConditionType;
import org.wso2.carbon.identity.configuration.mgt.core.util.ConfigurationUtils;

public class ConfigurationManagerImpl
implements ConfigurationManager {
    private static final Log log = LogFactory.getLog(ConfigurationManagerImpl.class);
    private List<ConfigurationDAO> configurationDAOS;

    public ConfigurationManagerImpl(ConfigurationManagerConfigurationHolder configurationManagerConfigurationHolder) {
        this.configurationDAOS = configurationManagerConfigurationHolder.getConfigurationDAOS();
    }

    @Override
    public Resources getTenantResources(Condition searchCondition) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateSearchRequest(searchCondition);
        Resources resources = this.getConfigurationDAO().getTenantResources(searchCondition);
        if (resources == null) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCES_DOES_NOT_EXISTS, null);
        }
        return resources;
    }

    @Override
    public Resources getTenantResources(String tenantDomain, Condition searchCondition) throws ConfigurationManagementException {
        return this.getTenantResources(this.getTenantSpecificSearchCondition(tenantDomain, searchCondition));
    }

    private Condition getTenantSpecificSearchCondition(String tenantDomain, Condition searchCondition) {
        if (searchCondition != null) {
            PrimitiveCondition tenantCondition = new PrimitiveCondition("tenantDomain", ConditionType.PrimitiveOperator.EQUALS, tenantDomain);
            ArrayList<Condition> list = new ArrayList<Condition>();
            list.add(searchCondition);
            list.add(tenantCondition);
            return new ComplexCondition(ConditionType.ComplexOperator.AND, list);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Search condition is null");
        }
        return new PrimitiveCondition("tenantDomain", ConditionType.PrimitiveOperator.EQUALS, tenantDomain);
    }

    @Override
    public Resources getResources() throws ConfigurationManagementException {
        this.checkFeatureStatus();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Get Resources API is not Implemented yet.");
        }
        return null;
    }

    @Override
    public Resources getResourcesByType(String resourceTypeName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourcesRetrieveRequest(resourceTypeName);
        ResourceType resourceType = this.getResourceType(resourceTypeName);
        List resourceList = this.getConfigurationDAO().getResourcesByType(this.getTenantId(), resourceType.getId());
        if (resourceList == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No resource found for the resourceTypeName: " + resourceTypeName));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCES_DOES_NOT_EXISTS, resourceTypeName, null);
        }
        return new Resources(resourceList);
    }

    @Override
    public Resource getResource(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceRetrieveRequest(resourceTypeName, resourceName);
        ResourceType resourceType = this.getResourceType(resourceTypeName);
        Resource resource = this.getConfigurationDAO().getResourceByName(this.getTenantId(), resourceType.getId(), resourceName);
        if (resource == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No resource found for the resourceName: " + resourceName));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_DOES_NOT_EXISTS, resourceName, null);
        }
        return resource;
    }

    @Override
    public void deleteResource(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceDeleteRequest(resourceTypeName, resourceName);
        ResourceType resourceType = this.getResourceType(resourceTypeName);
        this.getConfigurationDAO().deleteResourceByName(this.getTenantId(), resourceType.getId(), resourceName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource: " + resourceName + " is deleted successfully."));
        }
    }

    @Override
    public Resource addResource(String resourceTypeName, ResourceAdd resourceAdd) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceCreateRequest(resourceTypeName, resourceAdd);
        Resource resource = this.generateResourceFromRequest(resourceTypeName, resourceAdd);
        String resourceId = ConfigurationUtils.generateUniqueID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource id generated: " + resourceId));
        }
        resource.setResourceId(resourceId);
        this.getConfigurationDAO().addResource(resource);
        if (log.isDebugEnabled()) {
            log.debug((Object)(resourceAdd.getName() + " resource created successfully."));
        }
        return resource;
    }

    @Override
    public Resource replaceResource(String resourceTypeName, ResourceAdd resourceAdd) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceReplaceRequest(resourceTypeName, resourceAdd);
        String resourceId = this.generateResourceId(resourceTypeName, resourceAdd.getName());
        Resource resource = this.generateResourceFromRequest(resourceTypeName, resourceAdd);
        resource.setResourceId(resourceId);
        this.getConfigurationDAO().replaceResource(resource);
        if (log.isDebugEnabled()) {
            log.debug((Object)(resourceAdd.getName() + " resource created successfully."));
        }
        return resource;
    }

    @Override
    public ResourceType getResourceType(String resourceTypeName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceTypeRetrieveRequest(resourceTypeName);
        ResourceType resourceType = this.getConfigurationDAO().getResourceTypeByName(resourceTypeName);
        if (resourceType == null || resourceType.getId() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource Type: " + resourceTypeName + " does not exist."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_DOES_NOT_EXISTS, resourceTypeName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource type: " + resourceType.getName() + " retrieved successfully."));
        }
        return resourceType;
    }

    @Override
    public void deleteResourceType(String resourceName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceTypeDeleteRequest(resourceName);
        this.getConfigurationDAO().deleteResourceTypeByName(resourceName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource type: " + resourceName + " is successfully deleted."));
        }
    }

    @Override
    public ResourceType addResourceType(ResourceTypeAdd resourceTypeAdd) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceTypeCreateRequest(resourceTypeAdd);
        String resourceTypeID = ConfigurationUtils.generateUniqueID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource type id generated: " + resourceTypeID));
        }
        ResourceType resourceType = this.generateResourceTypeFromRequest(resourceTypeAdd, resourceTypeID);
        this.getConfigurationDAO().addResourceType(resourceType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource type: " + resourceType.getName() + " successfully created with the id: " + resourceType.getId()));
        }
        return new ResourceType(resourceType.getName(), resourceType.getId(), resourceType.getDescription());
    }

    @Override
    public ResourceType replaceResourceType(ResourceTypeAdd resourceTypeAdd) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateResourceTypeReplaceRequest(resourceTypeAdd);
        String resourceTypeID = this.generateResourceTypeId(resourceTypeAdd.getName());
        ResourceType resourceType = this.generateResourceTypeFromRequest(resourceTypeAdd, resourceTypeID);
        this.getConfigurationDAO().replaceResourceType(resourceType);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource type: " + resourceType.getName() + " successfully replaced with the id: " + resourceType.getId()));
        }
        return new ResourceType(resourceType.getName(), resourceType.getId(), resourceType.getDescription());
    }

    @Override
    public void deleteAttribute(String resourceTypeName, String resourceName, String attributeKey) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateAttributeDeleteRequest(resourceTypeName, resourceName, attributeKey);
        Attribute existingAttribute = this.getAttribute(resourceTypeName, resourceName, attributeKey);
        this.getConfigurationDAO().deleteAttribute(existingAttribute.getAttributeId(), this.getResourceId(resourceTypeName, resourceName), attributeKey);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute: " + attributeKey + " successfully deleted."));
        }
    }

    @Override
    public Attribute getAttribute(String resourceTypeName, String resourceName, String attributeKey) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateAttributeGetRequest(resourceTypeName, resourceName, attributeKey);
        String resourceId = this.getResourceId(resourceTypeName, resourceName);
        Attribute attribute = this.getConfigurationDAO().getAttributeByKey(resourceId, attributeKey);
        if (attribute == null || attribute.getKey() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource Type: " + attributeKey + " does not exist."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_DOES_NOT_EXISTS, attributeKey);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource type: " + attributeKey + " retrieved successfully."));
        }
        return attribute;
    }

    @Override
    public Attribute updateAttribute(String resourceTypeName, String resourceName, Attribute attribute) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateAttributeRequest(attribute);
        Attribute existingAttribute = this.getAttribute(resourceTypeName, resourceName, attribute.getKey());
        this.getConfigurationDAO().updateAttribute(existingAttribute.getAttributeId(), this.getResourceId(resourceTypeName, resourceName), attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute: " + attribute.getKey() + " successfully updated."));
        }
        return attribute;
    }

    @Override
    public Attribute addAttribute(String resourceTypeName, String resourceName, Attribute attribute) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateAttributeAddRequest(resourceTypeName, resourceName, attribute.getKey());
        String resourceId = this.getResourceId(resourceTypeName, resourceName);
        String attributeId = ConfigurationUtils.generateUniqueID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute id generated: " + attributeId));
        }
        this.getConfigurationDAO().addAttribute(attributeId, resourceId, attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute: " + attribute.getKey() + " successfully updated."));
        }
        return attribute;
    }

    @Override
    public Attribute replaceAttribute(String resourceTypeName, String resourceName, Attribute attribute) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateAttributeRequest(attribute);
        String resourceId = this.getResourceId(resourceTypeName, resourceName);
        String attributeId = this.generateAttributeId(resourceTypeName, resourceName, attribute);
        this.getConfigurationDAO().replaceAttribute(attributeId, resourceId, attribute);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attribute: " + attribute.getKey() + " successfully replaced."));
        }
        return attribute;
    }

    private void validateSearchRequest(Condition condition) throws ConfigurationManagementClientException {
        if (condition == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Search condition:null is not valid");
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_SEARCH_REQUEST_INVALID, null);
        }
    }

    private void validateResourceRetrieveRequest(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceName) || StringUtils.isEmpty((String)resourceTypeName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid resource identifier with resourceName: " + resourceName + " and resourceTypeName: " + resourceTypeName + "."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_GET_REQUEST_INVALID, null);
        }
    }

    private void validateResourcesRetrieveRequest(String resourceTypeName) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceTypeName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid resource identifier with resourceTypeName: " + resourceTypeName + "."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_GET_REQUEST_INVALID, null);
        }
    }

    private int getTenantId() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }

    private String getTenantDomain() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    private void validateResourceDeleteRequest(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceName) || StringUtils.isEmpty((String)resourceTypeName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error identifying the resource with resource name: " + resourceName + " and resource type:" + resourceTypeName + "."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_DELETE_REQUEST_REQUIRED, null);
        }
        if (!this.isResourceExists(resourceTypeName, resourceName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A resource with the name: " + resourceName + " does not exists."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_DOES_NOT_EXISTS, resourceName);
        }
    }

    private Resource generateResourceFromRequest(String resourceTypeName, ResourceAdd resourceAdd) {
        Resource resource = new Resource();
        resource.setTenantDomain(this.getTenantDomain());
        resource.setResourceName(resourceAdd.getName());
        resource.setResourceType(resourceTypeName);
        resource.setAttributes(resourceAdd.getAttributes());
        return resource;
    }

    private void validateResourceCreateRequest(String resourceTypeName, ResourceAdd resourceAdd) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceTypeName) || !this.isResourceAddParameterValid(resourceAdd)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_ADD_REQUEST_INVALID, null);
        }
        if (this.isResourceExists(resourceTypeName, resourceAdd.getName())) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_ALREADY_EXISTS, resourceAdd.getName());
        }
    }

    private boolean isResourceAddParameterValid(ResourceAdd resourceAdd) {
        if (StringUtils.isEmpty((String)resourceAdd.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource name: " + resourceAdd.getName() + " is not valid."));
            }
            return false;
        }
        return true;
    }

    private boolean isResourceExists(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        try {
            this.getResource(resourceTypeName, resourceName);
        }
        catch (ConfigurationManagementClientException e) {
            if (this.isResourceNotExistsError(e)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private boolean isResourceExistsById(String resourceId) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        if (StringUtils.isBlank((String)resourceId)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_INVALID_RESOURCE_ID, resourceId);
        }
        return this.getConfigurationDAO().isExistingResource(this.getTenantId(), resourceId);
    }

    private boolean isResourceNotExistsError(ConfigurationManagementClientException e) {
        return ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_DOES_NOT_EXISTS.getCode().equals(e.getErrorCode());
    }

    private String generateResourceId(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        String resourceId;
        if (this.isResourceExists(resourceTypeName, resourceName)) {
            resourceId = this.getResource(resourceTypeName, resourceName).getResourceId();
        } else {
            resourceId = ConfigurationUtils.generateUniqueID();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource id generated: " + resourceId));
            }
        }
        return resourceId;
    }

    private void validateResourceReplaceRequest(String resourceTypeName, ResourceAdd resourceAdd) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceTypeName) || !this.isResourceAddParameterValid(resourceAdd)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_REPLACE_REQUEST_INVALID, null);
        }
    }

    private ResourceType getResourceTypeByIdentifier(String resourceName, String id) throws ConfigurationManagementException {
        return StringUtils.isEmpty((String)id) ? this.getConfigurationDAO().getResourceTypeByName(resourceName) : this.getConfigurationDAO().getResourceTypeById(id);
    }

    private void validateResourceTypeRetrieveRequest(String resourceName) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid resource type resourceName: " + resourceName + "."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_NAME_REQUIRED, null);
        }
    }

    private void validateResourceTypeDeleteRequest(String resourceName) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Invalid resource type resourceName: " + resourceName + "."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_NAME_REQUIRED, resourceName, null);
        }
        if (!this.isResourceTypeExists(resourceName)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A resource type with the resourceName: " + resourceName + " does not exists."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_DOES_NOT_EXISTS, resourceName);
        }
    }

    private void validateResourceTypeCreateRequest(ResourceTypeAdd resourceTypeAdd) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceTypeAdd.getName())) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_NAME_REQUIRED, null);
        }
        if (this.isResourceTypeExists(resourceTypeAdd.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A resource type with the name: " + resourceTypeAdd.getName() + " already exists."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_ALREADY_EXISTS, resourceTypeAdd.getName());
        }
    }

    private boolean isResourceTypeExists(String resourceTypeName) throws ConfigurationManagementException {
        try {
            this.getResourceType(resourceTypeName);
        }
        catch (ConfigurationManagementClientException e) {
            if (this.isResourceTypeNotExistError(e)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private boolean isResourceTypeNotExistError(ConfigurationManagementClientException e) {
        return ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_DOES_NOT_EXISTS.getCode().equals(e.getErrorCode());
    }

    private ResourceType generateResourceTypeFromRequest(ResourceTypeAdd resourceTypeCreate, String resourceTypeID) {
        ResourceType resourceType = new ResourceType();
        resourceType.setName(resourceTypeCreate.getName());
        resourceType.setDescription(resourceTypeCreate.getDescription());
        resourceType.setId(resourceTypeID);
        return resourceType;
    }

    private String generateResourceTypeId(String resourceTypeName) throws ConfigurationManagementException {
        String resourceTypeID;
        if (this.isResourceTypeExists(resourceTypeName)) {
            resourceTypeID = this.getResourceType(resourceTypeName).getId();
        } else {
            resourceTypeID = ConfigurationUtils.generateUniqueID();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource type id generated: " + resourceTypeID));
            }
        }
        return resourceTypeID;
    }

    private void validateResourceTypeReplaceRequest(ResourceTypeAdd resourceTypeAdd) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceTypeAdd.getName())) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_TYPE_NAME_REQUIRED, null);
        }
    }

    private void validateAttributeGetRequest(String resourceTypeName, String resourceName, String attributeKey) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)resourceName) || StringUtils.isEmpty((String)resourceTypeName) || StringUtils.isEmpty((String)attributeKey)) {
            String attributeIdentifiers = "resourceName = " + resourceName + ", resourceTypeName = " + resourceTypeName + ", attributeKey = " + attributeKey;
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_IDENTIFIERS_REQUIRED, attributeIdentifiers);
        }
    }

    private void validateAttributeRequest(Attribute attribute) throws ConfigurationManagementException {
        if (attribute == null || StringUtils.isEmpty((String)attribute.getKey())) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_REQUIRED, null);
        }
    }

    private boolean isAttributeExists(String resourceTypeName, String resourceName, String attributeKey) throws ConfigurationManagementException {
        try {
            this.getAttribute(resourceTypeName, resourceName, attributeKey);
        }
        catch (ConfigurationManagementClientException e) {
            if (this.isAttributeNotExistError(e)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private boolean isAttributeNotExistError(ConfigurationManagementClientException e) {
        return ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_DOES_NOT_EXISTS.getCode().equals(e.getErrorCode());
    }

    private void validateAttributeAddRequest(String resourceTypeName, String resourceName, String attributeKey) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)attributeKey) || StringUtils.isEmpty((String)attributeKey)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_REQUIRED, null);
        }
        if (this.isAttributeExists(resourceTypeName, resourceName, attributeKey)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_ALREADY_EXISTS, attributeKey);
        }
    }

    private void validateAttributeDeleteRequest(String resourceTypeName, String resourceName, String attributeKey) throws ConfigurationManagementException {
        if (StringUtils.isEmpty((String)attributeKey) || StringUtils.isEmpty((String)attributeKey)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_REQUIRED, null);
        }
        if (!this.isAttributeExists(resourceTypeName, resourceName, attributeKey)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_ATTRIBUTE_DOES_NOT_EXISTS, attributeKey);
        }
    }

    private String generateAttributeId(String resourceTypeName, String resourceName, Attribute attribute) throws ConfigurationManagementException {
        String attributeId;
        if (this.isAttributeExists(resourceTypeName, resourceName, attribute.getKey())) {
            attributeId = this.getAttribute(resourceTypeName, resourceName, attribute.getKey()).getAttributeId();
        } else {
            attributeId = ConfigurationUtils.generateUniqueID();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attribute id generated: " + attributeId));
            }
        }
        return attributeId;
    }

    private String getResourceId(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        return this.getResource(resourceTypeName, resourceName).getResourceId();
    }

    private String getResourceTypeId(String resourceTypeName) throws ConfigurationManagementException {
        return this.getResourceType(resourceTypeName).getId();
    }

    private ConfigurationDAO getConfigurationDAO() throws ConfigurationManagementException {
        if (!this.configurationDAOS.isEmpty()) {
            return this.configurationDAOS.get(this.configurationDAOS.size() - 1);
        }
        throw ConfigurationUtils.handleServerException(ConfigurationConstants.ErrorMessages.ERROR_CODE_GET_DAO, "configurationDAOs");
    }

    private void checkFeatureStatus() throws ConfigurationManagementException {
        if (!ConfigurationManagerComponentDataHolder.getInstance().isConfigurationManagementEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)ConfigurationConstants.ErrorMessages.ERROR_CODE_FEATURE_NOT_ENABLED.getMessage());
            }
            throw new ConfigurationManagementClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FEATURE_NOT_ENABLED.getMessage(), ConfigurationConstants.ErrorMessages.ERROR_CODE_FEATURE_NOT_ENABLED.getCode());
        }
    }

    @Override
    public ResourceFile addFile(String resourceTypeName, String resourceName, String fileName, InputStream fileStream) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateFileAddRequest(resourceTypeName, resourceName, fileName, fileStream);
        String resourceId = this.getResourceId(resourceTypeName, resourceName);
        String fileId = ConfigurationUtils.generateUniqueID();
        if (log.isDebugEnabled()) {
            log.debug((Object)("File id generated: " + fileId + " for the resource name: " + resourceName + " resource type name: " + resourceTypeName));
        }
        this.getConfigurationDAO().addFile(fileId, resourceId, fileName, fileStream);
        if (log.isDebugEnabled()) {
            log.debug((Object)("File: " + fileId + " successfully added for resource name: " + resourceName + " resource type name: " + resourceTypeName));
        }
        return new ResourceFile(fileId, ConfigurationUtils.getFilePath(fileId, resourceTypeName, resourceName), fileName);
    }

    @Override
    public List<ResourceFile> getFiles(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateRequest(resourceTypeName, resourceName);
        String resourceId = this.getResourceId(resourceTypeName, resourceName);
        List<ResourceFile> resourceFiles = this.getConfigurationDAO().getFiles(resourceId, resourceTypeName, resourceName);
        if (CollectionUtils.isEmpty(resourceFiles)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource: " + resourceName + " does not have any files."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILES_DOES_NOT_EXISTS, resourceName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Files for the resource: " + resourceName + " retrieved successfully."));
        }
        return resourceFiles;
    }

    @Override
    public List<ResourceFile> getFiles(String resourceTypeName, int tenantId) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateRequest(resourceTypeName);
        String resourceTypeId = this.getResourceTypeId(resourceTypeName);
        List<ResourceFile> resourceFiles = this.getConfigurationDAO().getFilesByResourceType(resourceTypeId, tenantId);
        if (CollectionUtils.isEmpty(resourceFiles)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource type: " + resourceTypeName + "  in tenant: " + this.getTenantDomain() + " does not have any files."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILES_DOES_NOT_EXISTS, resourceTypeName);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Files for the resource type: " + resourceTypeName + " retrieved successfully."));
        }
        return resourceFiles;
    }

    @Override
    public void deleteFiles(String resourceTypeName, String resourceName) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateRequest(resourceTypeName, resourceName);
        String resourceId = this.getResourceId(resourceTypeName, resourceName);
        this.getConfigurationDAO().deleteFiles(resourceId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All the files were deleted in the resource: " + resourceName + "."));
        }
    }

    @Override
    public InputStream getFileById(String resourceType, String resourceName, String fileId) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        this.validateRequest(resourceType, resourceName, fileId);
        InputStream fileStream = this.getConfigurationDAO().getFileById(resourceType, resourceName, fileId);
        if (fileStream == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource File: " + fileId + " does not exists."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_DOES_NOT_EXISTS, fileId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resource file: " + fileId + " retrieved successfully."));
        }
        return fileStream;
    }

    @Override
    public void deleteFileById(String resourceType, String resourceName, String fileId) throws ConfigurationManagementException {
        this.validateRequest(resourceType, resourceName, fileId);
        this.validateFileExistence(resourceType, resourceName, fileId);
        this.getConfigurationDAO().deleteFileById(resourceType, resourceName, fileId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("File: " + fileId + " successfully deleted."));
        }
    }

    private void validateRequest(String resourceTypeName, String resourceName) throws ConfigurationManagementClientException {
        if (StringUtils.isEmpty((String)resourceTypeName) || StringUtils.isEmpty((String)resourceName)) {
            String fileIdentifiers = "resourceType: " + resourceTypeName + ", resourceName: " + resourceName;
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_IDENTIFIERS_REQUIRED, fileIdentifiers);
        }
    }

    private void validateRequest(String resourceTypeName) throws ConfigurationManagementClientException {
        if (StringUtils.isEmpty((String)resourceTypeName)) {
            String fileIdentifiers = "resourceType: " + resourceTypeName;
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_IDENTIFIERS_REQUIRED, fileIdentifiers);
        }
    }

    private void validateRequest(String resourceTypeName, String resourceName, String fileId) throws ConfigurationManagementClientException {
        if (StringUtils.isEmpty((String)resourceTypeName) || StringUtils.isEmpty((String)resourceName) || StringUtils.isEmpty((String)fileId)) {
            String fileIdentifiers = "resourceType: " + resourceTypeName + ", resourceName: " + resourceName + ", fileId: " + fileId;
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_IDENTIFIERS_REQUIRED, fileIdentifiers);
        }
    }

    private void validateFileExistence(String resourceTypeName, String resourceName, String fileId) throws ConfigurationManagementException {
        if (!this.isFileExists(resourceTypeName, resourceName, fileId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A file with the id: " + fileId + " does not exists."));
            }
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_DOES_NOT_EXISTS, fileId);
        }
    }

    private void validateFileAddRequest(String resourceTypeName, String resourceName, String fileName, InputStream fileStream) throws ConfigurationManagementClientException {
        if (StringUtils.isEmpty((String)resourceTypeName) || StringUtils.isEmpty((String)resourceName) || StringUtils.isEmpty((String)fileName)) {
            String fileIdentifiers = "Resource type: " + resourceTypeName + ", resourceName: " + resourceName + ". FileName: " + fileName;
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_IDENTIFIERS_REQUIRED, fileIdentifiers);
        }
        if (fileStream == null) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_IDENTIFIERS_REQUIRED, "fileStream is invalid.");
        }
    }

    private boolean isFileExists(String resourceTypeName, String resourceName, String fileId) throws ConfigurationManagementException {
        try {
            this.getFileById(resourceTypeName, resourceName, fileId);
        }
        catch (ConfigurationManagementClientException e) {
            if (this.isFileNotExistsError(e)) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private boolean isFileNotExistsError(ConfigurationManagementClientException e) {
        return ConfigurationConstants.ErrorMessages.ERROR_CODE_FILE_DOES_NOT_EXISTS.getCode().equals(e.getErrorCode());
    }

    @Override
    public Resource getTenantResourceById(String resourceId) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        if (StringUtils.isBlank((String)resourceId)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_INVALID_RESOURCE_ID, resourceId);
        }
        Resource resource = this.getConfigurationDAO().getTenantResourceById(this.getTenantId(), resourceId);
        if (resource == null) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_ID_DOES_NOT_EXISTS, resourceId);
        }
        return resource;
    }

    @Override
    public void deleteResourceById(String resourceId) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        if (StringUtils.isBlank((String)resourceId)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_INVALID_RESOURCE_ID, resourceId);
        }
        if (this.isResourceExistsById(resourceId)) {
            this.getConfigurationDAO().deleteResourceById(this.getTenantId(), resourceId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource id: " + resourceId + " in tenant: " + this.getTenantDomain() + " deleted successfully."));
            }
        } else {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_ID_DOES_NOT_EXISTS, resourceId);
        }
    }

    @Override
    public void replaceResource(Resource resource) throws ConfigurationManagementException {
        this.checkFeatureStatus();
        String resourceId = resource.getResourceId();
        if (StringUtils.isBlank((String)resourceId)) {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_INVALID_RESOURCE_ID, resourceId);
        }
        if (this.isResourceExistsById(resource.getResourceId())) {
            this.getConfigurationDAO().replaceResourceWithFiles(resource);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource id: " + resourceId + " in tenant: " + this.getTenantDomain() + " updated successfully."));
            }
        } else {
            throw ConfigurationUtils.handleClientException(ConfigurationConstants.ErrorMessages.ERROR_CODE_RESOURCE_ID_DOES_NOT_EXISTS, resourceId);
        }
    }
}

