/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.base.BaseUtils;
import org.apache.axis2.transport.base.MetricsCollector;
import org.apache.axis2.transport.base.SynchronousCallback;
import org.apache.axis2.transport.base.TransportConfiguration;
import org.apache.axis2.transport.base.TransportListenerEndpointView;
import org.apache.axis2.transport.base.TransportMBeanSupport;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.axis2.transport.base.threads.WorkerPoolFactory;
import org.apache.axis2.transport.base.tracker.AxisServiceFilter;
import org.apache.axis2.transport.base.tracker.AxisServiceTracker;
import org.apache.axis2.transport.base.tracker.AxisServiceTrackerListener;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransportListener
implements TransportListener {
    protected Log log = null;
    protected ConfigurationContext cfgCtx = null;
    private TransportInDescription transportIn = null;
    private TransportOutDescription transportOut = null;
    protected int state = 0;
    protected boolean isNonBlocking = false;
    private AxisServiceTracker serviceTracker;
    protected WorkerPool workerPool = null;
    protected boolean useAxis2ThreadPool = false;
    private TransportMBeanSupport mbeanSupport;
    protected MetricsCollector metrics = new MetricsCollector();
    protected TransportConfiguration config;

    protected AbstractTransportListener() {
        this.log = LogFactory.getLog(this.getClass());
    }

    @Override
    public void init(ConfigurationContext cfgCtx, TransportInDescription transportIn) throws AxisFault {
        this.cfgCtx = cfgCtx;
        this.transportIn = transportIn;
        this.transportOut = cfgCtx.getAxisConfiguration().getTransportOut(this.getTransportName());
        this.config = TransportConfiguration.getConfiguration(this.getTransportName());
        if (this.useAxis2ThreadPool) {
            throw new AxisFault("Unsupported thread pool for task execution - Axis2 thread pool");
        }
        if (this.workerPool == null) {
            this.workerPool = WorkerPoolFactory.getWorkerPool(this.config.getServerCoreThreads(), this.config.getServerMaxThreads(), this.config.getServerKeepalive(), this.config.getServerQueueLen(), this.getTransportName() + "Server Worker thread group", this.getTransportName() + "-Worker");
        }
        this.serviceTracker = new AxisServiceTracker(cfgCtx.getAxisConfiguration(), new AxisServiceFilter(){

            @Override
            public boolean matches(AxisService service) {
                return !service.getName().startsWith("__") && BaseUtils.isUsingTransport(service, AbstractTransportListener.this.getTransportName());
            }
        }, new AxisServiceTrackerListener(){

            @Override
            public void serviceAdded(AxisService service) {
                AbstractTransportListener.this.internalStartListeningForService(service);
            }

            @Override
            public void serviceRemoved(AxisService service) {
                AbstractTransportListener.this.internalStopListeningForService(service);
            }
        });
        if (this.mbeanSupport == null) {
            this.mbeanSupport = new TransportMBeanSupport(this, this.getTransportName());
            this.mbeanSupport.register();
        }
    }

    @Override
    public void destroy() {
        try {
            if (this.state == 1) {
                try {
                    this.stop();
                }
                catch (AxisFault ignore) {
                    this.log.warn((Object)("Error stopping the transport : " + this.getTransportName()));
                }
            }
        }
        finally {
            this.state = 0;
            this.mbeanSupport.unregister();
        }
        try {
            this.workerPool.shutdown(10000);
        }
        catch (InterruptedException ex) {
            this.log.warn((Object)"Thread interrupted while waiting for worker pool to shut down");
        }
    }

    @Override
    public void stop() throws AxisFault {
        if (this.state == 1) {
            this.state = 0;
            this.log.info((Object)(this.getTransportName().toUpperCase() + " Listener Shutdown"));
            this.serviceTracker.stop();
        }
    }

    @Override
    public void start() throws AxisFault {
        if (this.state != 1) {
            this.state = 1;
            this.log.info((Object)(this.getTransportName().toUpperCase() + " listener started"));
            this.serviceTracker.start();
        }
    }

    @Override
    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName);
    }

    protected EndpointReference[] getEPRsForService(String serviceName) {
        return null;
    }

    public void disableTransportForService(AxisService service) {
        this.log.warn((Object)("Disabling the " + this.getTransportName() + " transport for the service " + service.getName() + ", because it is not configured properly for the service"));
        if (service.isEnableAllTransports()) {
            ArrayList<String> exposedTransports = new ArrayList<String>();
            for (TransportInDescription obj : this.cfgCtx.getAxisConfiguration().getTransportsIn().values()) {
                String transportName = obj.getName();
                if (transportName.equals(this.getTransportName())) continue;
                exposedTransports.add(transportName);
            }
            service.setEnableAllTransports(false);
            service.setExposedTransports(exposedTransports);
        } else {
            service.removeExposedTransport(this.getTransportName());
        }
    }

    void internalStartListeningForService(AxisService service) {
        String serviceName = service.getName();
        try {
            this.startListeningForService(service);
        }
        catch (AxisFault ex) {
            String transportName = this.getTransportName().toUpperCase();
            String msg = "Unable to configure the service " + serviceName + " for the " + transportName + " transport: " + ex.getMessage() + ". This service is being marked as faulty and will not be available over the " + transportName + " transport.";
            this.log.warn((Object)msg);
            this.log.debug((Object)("Disabling service " + serviceName + " for the " + transportName + "transport"), (Throwable)ex);
            BaseUtils.markServiceAsFaulty(serviceName, msg, service.getAxisConfiguration());
            this.disableTransportForService(service);
            return;
        }
        catch (Throwable ex) {
            String msg = "Unexpected error when configuring service " + serviceName + " for the " + this.getTransportName().toUpperCase() + " transport. It will be disabled for this transport and marked as faulty.";
            this.log.error((Object)msg, ex);
            BaseUtils.markServiceAsFaulty(serviceName, msg, service.getAxisConfiguration());
            this.disableTransportForService(service);
            return;
        }
        this.registerMBean(new TransportListenerEndpointView(this, serviceName), this.getEndpointMBeanName(serviceName));
    }

    void internalStopListeningForService(AxisService service) {
        this.unregisterMBean(this.getEndpointMBeanName(service.getName()));
        this.stopListeningForService(service);
    }

    protected abstract void startListeningForService(AxisService var1) throws AxisFault;

    protected abstract void stopListeningForService(AxisService var1);

    @Override
    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    @Override
    public SessionContext getSessionContext(MessageContext messageContext) {
        return null;
    }

    public MessageContext createMessageContext() {
        MessageContext msgCtx = new MessageContext();
        msgCtx.setConfigurationContext(this.cfgCtx);
        msgCtx.setIncomingTransportName(this.getTransportName());
        msgCtx.setTransportOut(this.transportOut);
        msgCtx.setTransportIn(this.transportIn);
        msgCtx.setServerSide(true);
        msgCtx.setMessageID(UUIDGenerator.getUUID());
        msgCtx.setProperty("ClientApiNonBlocking", !this.isNonBlocking);
        return msgCtx;
    }

    public void handleIncomingMessage(MessageContext msgCtx, Map trpHeaders, String soapAction, String contentType) throws AxisFault {
        block6: {
            if (soapAction != null) {
                msgCtx.setSoapAction(soapAction);
            }
            msgCtx.setProperty("TRANSPORT_HEADERS", trpHeaders);
            try {
                Map callBackMap = (Map)msgCtx.getConfigurationContext().getProperty("callbackTable");
                Object replyToMessageID = trpHeaders.get("In-Reply-To");
                if (replyToMessageID != null && callBackMap != null && callBackMap.get(replyToMessageID) != null) {
                    SynchronousCallback synchronousCallback = (SynchronousCallback)callBackMap.get(replyToMessageID);
                    synchronousCallback.setInMessageContext(msgCtx);
                    callBackMap.remove(replyToMessageID);
                } else {
                    AxisEngine.receive(msgCtx);
                }
            }
            catch (AxisFault e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Error receiving message", (Throwable)e);
                }
                if (!msgCtx.isServerSide()) break block6;
                AxisEngine.sendFault(MessageContextBuilder.createFaultMessageContext(msgCtx, e));
            }
        }
    }

    protected void handleException(String msg, Exception e) throws AxisFault {
        this.log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, e);
    }

    protected void logException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
    }

    public TransportInDescription getTransportInDescription() {
        return this.transportIn;
    }

    public String getTransportName() {
        return this.transportIn.getName();
    }

    public ConfigurationContext getConfigurationContext() {
        return this.cfgCtx;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metrics;
    }

    public void pause() throws AxisFault {
    }

    public void resume() throws AxisFault {
    }

    public void maintenenceShutdown(long millis) throws AxisFault {
    }

    public int getActiveThreadCount() {
        return this.workerPool.getActiveCount();
    }

    public int getQueueSize() {
        return this.workerPool.getQueueSize();
    }

    public long getMessagesReceived() {
        if (this.metrics != null) {
            return this.metrics.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getFaultsReceiving();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.metrics != null) {
            return this.metrics.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.metrics != null) {
            return this.metrics.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.metrics != null) {
            return this.metrics.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.metrics != null) {
            return this.metrics.getBytesSent();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.metrics != null) {
            return this.metrics.getTimeoutsSending();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.metrics != null) {
            return this.metrics.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.metrics != null) {
            return this.metrics.getResponseCodeTable();
        }
        return null;
    }

    public void resetStatistics() {
        if (this.metrics != null) {
            this.metrics.reset();
        }
    }

    public long getLastResetTime() {
        if (this.metrics != null) {
            return this.metrics.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.metrics != null) {
            return System.currentTimeMillis() - this.metrics.getLastResetTime();
        }
        return -1L;
    }

    private String getEndpointMBeanName(String serviceName) {
        return this.mbeanSupport.getMBeanName() + ",Group=Services,Service=" + serviceName;
    }

    private void registerMBean(Object mbeanInstance, String objectName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName(objectName);
            Set<ObjectName> set = mbs.queryNames(name, null);
            if (set != null && set.isEmpty()) {
                mbs.registerMBean(mbeanInstance, name);
            } else {
                mbs.unregisterMBean(name);
                mbs.registerMBean(mbeanInstance, name);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }

    private void unregisterMBean(String objectName) {
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName objName = new ObjectName(objectName);
            if (mbs.isRegistered(objName)) {
                mbs.unregisterMBean(objName);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Error un-registering a MBean with objectname ' " + objectName + " ' for JMX management"), (Throwable)e);
        }
    }
}

