/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.mail.internet.ContentType;
import javax.mail.internet.ParseException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.format.TextMessageBuilder;
import org.apache.commons.io.input.ReaderInputStream;

public class TextMessageBuilderAdapter
implements TextMessageBuilder {
    private final Builder builder;

    public TextMessageBuilderAdapter(Builder builder) {
        this.builder = builder;
    }

    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        return this.builder.processDocument(inputStream, contentType, messageContext);
    }

    @Override
    public OMElement processDocument(Reader reader, String contentType, MessageContext messageContext) throws AxisFault {
        String charset;
        try {
            ContentType ct = new ContentType(contentType);
            charset = ct.getParameter("charset");
        }
        catch (ParseException ex) {
            charset = null;
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        messageContext.setProperty("CHARACTER_SET_ENCODING", charset);
        return this.processDocument((InputStream)new ReaderInputStream(reader, charset), contentType, messageContext);
    }

    @Override
    public OMElement processDocument(String content, String contentType, MessageContext messageContext) throws AxisFault {
        return this.processDocument(new StringReader(content), contentType, messageContext);
    }
}

