/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import javax.activation.DataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.format.MessageFormatterEx;
import org.apache.axis2.format.TextFromElementDataSource;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;

public class PlainTextFormatter
implements MessageFormatterEx {
    @Override
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeTo(messageContext, format, baos, true);
        return baos.toByteArray();
    }

    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement textElt = messageContext.getEnvelope().getBody().getFirstElement();
        if (BaseConstants.DEFAULT_TEXT_WRAPPER.equals(textElt.getQName())) {
            try {
                OutputStreamWriter out = new OutputStreamWriter(outputStream, format.getCharSetEncoding());
                out.write(textElt.getFirstElement() == null ? textElt.getText() : textElt.getFirstElement().toString());
                ((Writer)out).flush();
            }
            catch (IOException e) {
                throw new AxisFault("Error writing text message to stream", e);
            }
            catch (Exception e) {
                throw new AxisFault("Error extracting the text payload from the message", e);
            }
        }
    }

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String encoding = format.getCharSetEncoding();
        String contentType = (String)messageContext.getProperty("ContentType");
        if (contentType == null) {
            contentType = "text/plain";
        }
        String setEncoding = (String)messageContext.getProperty("setCharacterEncoding");
        if (encoding != null && !"false".equals(setEncoding)) {
            contentType = contentType + "; charset=" + encoding;
        }
        if (soapAction != null && !"".equals(soapAction.trim()) && !"\"\"".equals(soapAction.trim())) {
            contentType = contentType + ";action=\"" + soapAction + "\";";
        }
        return contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext msgCtxt, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, msgCtxt, false);
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return null;
    }

    @Override
    public DataSource getDataSource(MessageContext messageContext, OMOutputFormat format, String soapAction) throws AxisFault {
        return new TextFromElementDataSource(messageContext.getEnvelope().getBody().getFirstElement(), format.getCharSetEncoding(), this.getContentType(messageContext, format, soapAction));
    }
}

