/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.authenticator.saml2.sso.SAML2SSOAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.internal.SAML2SSOAuthBEDataHolder;
import org.wso2.carbon.identity.authenticator.saml2.sso.util.X509CredentialImpl;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.xml.sax.SAXException;

public class Util {
    private static final int ENTITY_EXPANSION_LIMIT = 0;
    private static boolean bootStrapped = false;
    private static final Log log = LogFactory.getLog(Util.class);

    private Util() {
    }

    public static XMLObject unmarshall(String authReqStr) throws SAML2SSOAuthenticatorException {
        try {
            Util.doBootstrap();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringComments(true);
            Document document = Util.getDocument(documentBuilderFactory, authReqStr);
            if (Util.isSignedWithComments(document)) {
                documentBuilderFactory.setIgnoringComments(false);
                document = Util.getDocument(documentBuilderFactory, authReqStr);
            }
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            XMLObject response = unmarshaller.unmarshall(element);
            NodeList list = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "Response");
            if (list.getLength() > 0) {
                log.error((Object)"Invalid schema for the SAML2 response. Multiple responses detected");
                throw new SAML2SSOAuthenticatorException("Error occurred while processing saml2 response");
            }
            NodeList assertionList = response.getDOM().getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
            if (response instanceof Assertion) {
                if (assertionList.getLength() > 0) {
                    log.error((Object)"Invalid schema for the SAML2 assertion. Multiple assertions detected");
                    throw new SAML2SSOAuthenticatorException("Error occurred while processing saml2 response");
                }
            } else if (assertionList.getLength() > 1) {
                log.error((Object)"Invalid schema for the SAML2 response. Multiple assertions detected");
                throw new SAML2SSOAuthenticatorException("Error occurred while processing saml2 response");
            }
            return response;
        }
        catch (IOException | ParserConfigurationException | UnmarshallingException | SAXException e) {
            log.error((Object)"Error occured while processing saml2 response");
            throw new SAML2SSOAuthenticatorException("Error occured while processing saml2 response", e);
        }
    }

    public static void doBootstrap() {
        if (!bootStrapped) {
            try {
                SAMLInitializer.doBootstrap();
                bootStrapped = true;
            }
            catch (InitializationException e) {
                log.error((Object)"Error in bootstrapping the OpenSAML3 library", (Throwable)e);
            }
        }
    }

    public static X509CredentialImpl getX509CredentialImplForTenant(String domainName) throws SAML2SSOAuthenticatorException {
        int tenantID = -1234;
        RealmService realmService = SAML2SSOAuthBEDataHolder.getInstance().getRealmService();
        if (!domainName.equals("carbon.super")) {
            try {
                tenantID = realmService.getTenantManager().getTenantId(domainName);
            }
            catch (UserStoreException e) {
                String errorMsg = "Error getting the TenantID for the domain name";
                log.error((Object)errorMsg, (Throwable)e);
                throw new SAML2SSOAuthenticatorException(errorMsg, e);
            }
        }
        KeyStoreManager keyStoreManager = null;
        X509CredentialImpl credentialImpl = null;
        try {
            IdentityTenantUtil.initializeRegistry((int)tenantID, (String)domainName);
            keyStoreManager = KeyStoreManager.getInstance((int)tenantID);
            if (tenantID != -1234) {
                KeyStore keystore = keyStoreManager.getKeyStore(Util.generateKSNameFromDomainName(domainName));
                X509Certificate cert = (X509Certificate)keystore.getCertificate(domainName);
                credentialImpl = new X509CredentialImpl(cert);
            } else {
                String alias = SAML2SSOAuthBEDataHolder.getInstance().getIdPCertAlias();
                X509Certificate cert = null;
                if (alias != null) {
                    cert = (X509Certificate)keyStoreManager.getPrimaryKeyStore().getCertificate(alias);
                    if (cert == null) {
                        String errorMsg = "Cannot find a certificate with the alias " + alias + " in the default key store. Please check the 'IdPCertAlias' property in the SSO configuration of the authenticators.xml";
                        log.error((Object)errorMsg);
                        throw new SAML2SSOAuthenticatorException(errorMsg);
                    }
                } else {
                    cert = keyStoreManager.getDefaultPrimaryCertificate();
                }
                credentialImpl = new X509CredentialImpl(cert);
            }
        }
        catch (Exception e) {
            String errorMsg = "Error instantiating an X509CredentialImpl object for the public cert.";
            log.error((Object)errorMsg, (Throwable)e);
            throw new SAML2SSOAuthenticatorException(errorMsg, e);
        }
        return credentialImpl;
    }

    private static String generateKSNameFromDomainName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    private static boolean isSignedWithComments(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String assertionId = (String)xPath.compile("//*[local-name()='Assertion']/@ID").evaluate(document, XPathConstants.STRING);
            if (StringUtils.isBlank((String)assertionId)) {
                return false;
            }
            NodeList nodeList = (NodeList)xPath.compile("//*[local-name()='Assertion']/*[local-name()='Signature']/*[local-name()='SignedInfo']/*[local-name()='Reference'][@URI='#" + assertionId + "']/*[local-name()='Transforms']/*[local-name()='Transform'][@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#WithComments']").evaluate(document, XPathConstants.NODESET);
            return nodeList != null && nodeList.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            String message = "Failed to find the canonicalization algorithm of the assertion. Defaulting to: http://www.w3.org/2001/10/xml-exc-c14n#";
            log.warn((Object)message);
            if (log.isDebugEnabled()) {
                log.debug((Object)message, (Throwable)e);
            }
            return false;
        }
    }

    private static Document getDocument(DocumentBuilderFactory documentBuilderFactory, String samlString) throws IOException, SAXException, ParserConfigurationException {
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd or secure-processing.", (Throwable)e);
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        return docBuilder.parse(new ByteArrayInputStream(samlString.trim().getBytes()));
    }
}

