/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso.internal;

import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.identity.authenticator.saml2.sso.SAML2SSOAuthenticator;
import org.wso2.carbon.identity.authenticator.saml2.sso.internal.SAML2SSOAuthBEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="saml2.sso.authenticator.dscomponent", immediate=true)
public class SAML2SSOAuthenticatorDSComponent {
    private static final Log log = LogFactory.getLog(SAML2SSOAuthenticatorDSComponent.class);

    @Activate
    protected void activate(ComponentContext ctxt) {
        block3: {
            try {
                SAML2SSOAuthBEDataHolder.getInstance().setBundleContext(ctxt.getBundleContext());
                SAML2SSOAuthenticator authenticator = new SAML2SSOAuthenticator();
                Hashtable<String, String> props = new Hashtable<String, String>();
                props.put("authenticator.type", authenticator.getAuthenticatorName());
                ctxt.getBundleContext().registerService(CarbonServerAuthenticator.class.getName(), (Object)authenticator, props);
                this.configureIdPCertAlias();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"SAML2 SSO Authenticator BE Bundle activated successfuly.");
                }
            }
            catch (Throwable e) {
                if (!log.isDebugEnabled()) break block3;
                log.error((Object)"SAML2 SSO Authenticator BE Bundle activation Failed.");
            }
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        SAML2SSOAuthBEDataHolder.getInstance().setBundleContext(null);
        log.debug((Object)"SAML2 SSO Authenticator BE Bundle is deactivated ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        SAML2SSOAuthBEDataHolder.getInstance().setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        SAML2SSOAuthBEDataHolder.getInstance().setRegistryService(null);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        SAML2SSOAuthBEDataHolder.getInstance().setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        SAML2SSOAuthBEDataHolder.getInstance().setRealmService(null);
    }

    private void configureIdPCertAlias() {
        Map authenticatorParams;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig("SAML2SSOAuthenticator");
        if (authenticatorConfig != null && (authenticatorParams = authenticatorConfig.getParameters()).containsKey("IdPCertAlias")) {
            SAML2SSOAuthBEDataHolder.getInstance().setIdPCertAlias((String)authenticatorParams.get("IdPCertAlias"));
        }
    }
}

