/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.authenticator.saml2.sso;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.impl.XSAnyImpl;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.security.AuthenticatorsConfiguration;
import org.wso2.carbon.core.services.authentication.CarbonServerAuthenticator;
import org.wso2.carbon.core.services.util.CarbonAuthenticationUtil;
import org.wso2.carbon.core.util.AnonymousSessionUtil;
import org.wso2.carbon.core.util.PermissionUpdateUtil;
import org.wso2.carbon.identity.authenticator.saml2.sso.SAML2SSOAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.SAML2SSOUIAuthenticatorException;
import org.wso2.carbon.identity.authenticator.saml2.sso.common.Util;
import org.wso2.carbon.identity.authenticator.saml2.sso.dto.AuthnReqDTO;
import org.wso2.carbon.identity.authenticator.saml2.sso.internal.SAML2SSOAuthBEDataHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.utils.AuthenticationObserver;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class SAML2SSOAuthenticator
implements CarbonServerAuthenticator {
    public static final Log log = LogFactory.getLog(SAML2SSOAuthenticator.class);
    private static final Log AUDIT_LOG = CarbonConstants.AUDIT_LOG;
    private SAML2SSOAuthBEDataHolder dataHolder = SAML2SSOAuthBEDataHolder.getInstance();
    private static final int DEFAULT_PRIORITY_LEVEL = 3;
    private static final String AUTHENTICATOR_NAME = "SAML2SSOAuthenticator";
    private SecureRandom random = new SecureRandom();
    private int timeStampSkewInSeconds = 300;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login(AuthnReqDTO authDto) {
        boolean bl;
        int tenantId;
        HttpSession httpSession;
        String auditResult;
        String tenantDomain;
        String username;
        block23: {
            RealmService realmService;
            RegistryService registryService;
            XMLObject xmlObject;
            block22: {
                block21: {
                    block20: {
                        username = null;
                        tenantDomain = null;
                        auditResult = "Failed";
                        httpSession = this.getHttpSession();
                        xmlObject = org.wso2.carbon.identity.authenticator.saml2.sso.util.Util.unmarshall(Util.decode((String)authDto.getResponse()));
                        username = Util.getUsername((XMLObject)xmlObject);
                        if (!StringUtils.isBlank((String)username)) break block20;
                        log.error((Object)"Authentication Request is rejected. SAMLResponse does not contain the username of the subject.");
                        CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)"", (int)-1, (String)"SAML2 SSO Authentication", (String)"SAMLResponse does not contain the username of the subject");
                        boolean bl2 = false;
                        if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                            String auditInitiator = username + "@" + tenantDomain;
                            String auditData = "";
                            AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
                        }
                        return bl2;
                    }
                    try {
                        this.validateAssertionValidityPeriod(xmlObject);
                    }
                    catch (SAML2SSOAuthenticatorException e) {
                        log.error((Object)("Authentication Request is rejected. " + e.getMessage()));
                        CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)-1, (String)"SAML2 SSO Authentication", (String)e.getMessage());
                        boolean auditInitiator = false;
                        if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                            String auditInitiator2 = username + "@" + tenantDomain;
                            String auditData = "";
                            AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator2, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
                        }
                        return auditInitiator;
                    }
                    if (this.validateAudienceRestrictionInXML(xmlObject)) break block21;
                    log.error((Object)"Authentication Request is rejected. SAMLResponse AudienceRestriction validation failed.");
                    CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)-1, (String)"SAML2 SSO Authentication", (String)"AudienceRestriction validation failed");
                    boolean e = false;
                    if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                        String auditInitiator = username + "@" + tenantDomain;
                        String auditData = "";
                        AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
                    }
                    return e;
                }
                registryService = this.dataHolder.getRegistryService();
                realmService = this.dataHolder.getRealmService();
                tenantDomain = MultitenantUtils.getTenantDomain((String)username);
                tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
                boolean isSignatureValid = false;
                this.handleAuthenticationStarted(tenantId);
                isSignatureValid = this.validateSignature(xmlObject, tenantDomain);
                if (isSignatureValid) break block22;
                log.error((Object)"Authentication Request is rejected. Signature validation failed.");
                CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)tenantId, (String)"SAML2 SSO Authentication", (String)"Invalid Signature");
                this.handleAuthenticationCompleted(tenantId, false);
                boolean bl3 = false;
                if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                    String auditInitiator = username + "@" + tenantDomain;
                    String auditData = "";
                    AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
                }
                return bl3;
            }
            username = MultitenantUtils.getTenantAwareUsername((String)username);
            UserRealm realm = AnonymousSessionUtil.getRealmByTenantDomain((RegistryService)registryService, (RealmService)realmService, (String)tenantDomain);
            this.provisionUser(username, realm, xmlObject);
            PermissionUpdateUtil.updatePermissionTree((int)tenantId);
            boolean isAuthorized = false;
            if (realm != null) {
                isAuthorized = realm.getAuthorizationManager().isUserAuthorized(username, "/permission/admin/login", "ui.execute");
            }
            if (!isAuthorized) break block23;
            UserCoreUtil.setDomainInThreadLocal(null);
            CarbonAuthenticationUtil.onSuccessAdminLogin((HttpSession)httpSession, (String)username, (int)tenantId, (String)tenantDomain, (String)"SAML2 SSO Authentication");
            this.handleAuthenticationCompleted(tenantId, true);
            auditResult = "Success";
            boolean bl4 = true;
            if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                String auditInitiator = username + "@" + tenantDomain;
                String auditData = "";
                AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
            }
            return bl4;
        }
        try {
            log.error((Object)"Authentication Request is rejected. Authorization Failure.");
            CarbonAuthenticationUtil.onFailedAdminLogin((HttpSession)httpSession, (String)username, (int)tenantId, (String)"SAML2 SSO Authentication", (String)"Authorization Failure");
            this.handleAuthenticationCompleted(tenantId, false);
            bl = false;
        }
        catch (Exception e) {
            boolean bl5;
            try {
                String msg = "System error while Authenticating/Authorizing User : " + e.getMessage();
                log.error((Object)msg, (Throwable)e);
                bl5 = false;
            }
            catch (Throwable throwable) {
                if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                    String auditInitiator = username + "@" + tenantDomain;
                    String auditData = "";
                    AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
                }
                throw throwable;
            }
            if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
                String auditInitiator = username + "@" + tenantDomain;
                String auditData = "";
                AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
            }
            return bl5;
        }
        if (username != null && username.trim().length() > 0 && AUDIT_LOG.isInfoEnabled()) {
            String auditInitiator = username + "@" + tenantDomain;
            String auditData = "";
            AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Login", AUTHENTICATOR_NAME, auditData, auditResult));
        }
        return bl;
    }

    private void handleAuthenticationStarted(int tenantId) {
        BundleContext bundleContext = this.dataHolder.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).startedAuthentication(tenantId);
                }
            }
            tracker.close();
        }
    }

    private void handleAuthenticationCompleted(int tenantId, boolean isSuccessful) {
        BundleContext bundleContext = this.dataHolder.getBundleContext();
        if (bundleContext != null) {
            ServiceTracker tracker = new ServiceTracker(bundleContext, AuthenticationObserver.class.getName(), null);
            tracker.open();
            Object[] services = tracker.getServices();
            if (services != null) {
                for (Object service : services) {
                    ((AuthenticationObserver)service).completedAuthentication(tenantId, isSuccessful);
                }
            }
            tracker.close();
        }
    }

    public void logout() {
        Date currentTime = Calendar.getInstance().getTime();
        SimpleDateFormat date = new SimpleDateFormat("'['yyyy-MM-dd HH:mm:ss,SSSS']'");
        HttpSession session = this.getHttpSession();
        if (session != null) {
            String loggedInUser = (String)session.getAttribute("wso2carbon.admin.logged.in");
            String delegatedBy = (String)session.getAttribute("DELEGATED_BY");
            if (StringUtils.isNotBlank((String)loggedInUser)) {
                String logMessage = "'" + loggedInUser + "' logged out at " + date.format(currentTime);
                if (delegatedBy != null) {
                    logMessage = logMessage + " delegated by " + delegatedBy;
                }
                log.info((Object)logMessage);
            }
            session.invalidate();
            if (loggedInUser != null && AUDIT_LOG.isInfoEnabled()) {
                String tenantAwareUsername = loggedInUser;
                String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                String auditInitiator = tenantAwareUsername + "@" + tenantDomain;
                String auditData = delegatedBy != null ? "Delegated By : " + delegatedBy : "";
                AUDIT_LOG.info((Object)String.format("Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ", auditInitiator, "Logout", AUTHENTICATOR_NAME, auditData, "Success"));
            }
        }
    }

    public boolean isHandle(MessageContext messageContext) {
        return true;
    }

    public boolean isAuthenticated(MessageContext messageContext) {
        HttpServletRequest request = (HttpServletRequest)messageContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession();
        String loginStatus = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
        return loginStatus != null;
    }

    public boolean authenticateWithRememberMe(MessageContext messageContext) {
        return false;
    }

    public int getPriority() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && authenticatorConfig.getPriority() > 0) {
            return authenticatorConfig.getPriority();
        }
        return 3;
    }

    public String getAuthenticatorName() {
        return AUTHENTICATOR_NAME;
    }

    public boolean isDisabled() {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            return authenticatorConfig.isDisabled();
        }
        return false;
    }

    private boolean isResponseSignatureValidationEnabled() {
        String responseSignatureValidation;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (responseSignatureValidation = (String)authenticatorConfig.getParameters().get("ResponseSignatureValidationEnabled")) != null && responseSignatureValidation.equalsIgnoreCase("false")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Response signature validation is disabled in the configuration");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Response signature validation is enabled in the configuration");
        }
        return true;
    }

    private boolean isAssertionSignatureValidationEnabled() {
        String assertionSignatureValidation;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (assertionSignatureValidation = (String)authenticatorConfig.getParameters().get("AssertionSignatureValidationEnabled")) != null && !Boolean.parseBoolean(assertionSignatureValidation)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Assertion signature validation is disabled in the configuration");
            }
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Assertion signature validation is enabled in the configuration");
        }
        return true;
    }

    private boolean isVerifySignWithUserDomain() {
        String responseSignatureValidation;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && "true".equalsIgnoreCase(responseSignatureValidation = (String)authenticatorConfig.getParameters().get("VerifySignatureWithUserDomain"))) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Signature validation is done based on user tenant domain");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Signature validation is done with super tenant domain");
        }
        return false;
    }

    private int getTimeStampSkewInSeconds() {
        String timeStampSkew;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (timeStampSkew = (String)authenticatorConfig.getParameters().get("TimestampSkew")) != null) {
            this.timeStampSkewInSeconds = Integer.parseInt(timeStampSkew);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("TimestampSkew is set to " + this.timeStampSkewInSeconds + " s."));
        }
        return this.timeStampSkewInSeconds;
    }

    private boolean validateSignature(XMLObject xmlObject, String domainName) {
        if (xmlObject instanceof Response) {
            Response response = (Response)xmlObject;
            if (!this.isResponseSignatureValidationEnabled() || this.validateSignature(response, domainName)) {
                return !this.isAssertionSignatureValidationEnabled() || this.validateSignature(this.getAssertionFromResponse(response), domainName);
            }
        } else {
            if (xmlObject instanceof Assertion) {
                return !this.isAssertionSignatureValidationEnabled() || this.validateSignature((Assertion)xmlObject, domainName);
            }
            log.error((Object)"Only Response and Assertion objects are validated in this authenticator");
        }
        return false;
    }

    private boolean validateSignature(Response response, String domainName) {
        boolean isSignatureValid = false;
        if (response == null || response.getSignature() == null) {
            log.error((Object)"SAML Response is not signed or response not available. Authentication process will be terminated.");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Validating SAML Response Signature.");
            }
            isSignatureValid = this.validateSignature(response.getSignature(), domainName);
        }
        return isSignatureValid;
    }

    private boolean validateSignature(Assertion assertion, String domainName) {
        boolean isSignatureValid = false;
        if (assertion == null || assertion.getSignature() == null) {
            log.error((Object)"SAML Assertion is not signed or assertion not available. Authentication process will be terminated.");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Validating SAML Assertion Signature.");
            }
            isSignatureValid = this.validateSignature(assertion.getSignature(), domainName);
        }
        return isSignatureValid;
    }

    private boolean validateSignature(Signature signature, String domainName) {
        boolean isSignatureValid;
        block8: {
            isSignatureValid = false;
            try {
                SAMLSignatureProfileValidator signatureProfileValidator = new SAMLSignatureProfileValidator();
                signatureProfileValidator.validate(signature);
            }
            catch (SignatureException e) {
                String logMsg = "Signature do not confirm to SAML signature profile. Possible XML Signature Wrapping Attack!";
                AUDIT_LOG.warn((Object)logMsg);
                if (log.isDebugEnabled()) {
                    log.debug((Object)logMsg, (Throwable)e);
                }
                return isSignatureValid;
            }
            try {
                if (this.isVerifySignWithUserDomain()) {
                    SignatureValidator.validate((Signature)signature, (Credential)org.wso2.carbon.identity.authenticator.saml2.sso.util.Util.getX509CredentialImplForTenant(domainName));
                } else {
                    SignatureValidator.validate((Signature)signature, (Credential)org.wso2.carbon.identity.authenticator.saml2.sso.util.Util.getX509CredentialImplForTenant("carbon.super"));
                }
                isSignatureValid = true;
            }
            catch (SAML2SSOAuthenticatorException e) {
                String errorMsg = "Error when creating an X509CredentialImpl instance";
                log.error((Object)errorMsg, (Throwable)((Object)e));
            }
            catch (SignatureException e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("SAML Signature validation failed from domain : " + domainName), (Throwable)e);
            }
        }
        return isSignatureValid;
    }

    private Assertion getAssertionFromResponse(Response response) {
        Assertion assertion = null;
        List assertions = response.getAssertions();
        if (assertions != null && !assertions.isEmpty()) {
            assertion = (Assertion)assertions.get(0);
        } else {
            List encryptedAssertions = response.getEncryptedAssertions();
            if (encryptedAssertions.size() > 0) {
                EncryptedAssertion encryptedAssertion = (EncryptedAssertion)encryptedAssertions.get(0);
                try {
                    String tenantDomain = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
                    assertion = Util.getDecryptedAssertion((EncryptedAssertion)encryptedAssertion, (String)tenantDomain);
                }
                catch (SAML2SSOUIAuthenticatorException e) {
                    log.error((Object)"Error while obtaining the assertion from saml response.", (Throwable)e);
                }
            }
        }
        return assertion;
    }

    private boolean validateAudienceRestrictionInXML(XMLObject xmlObject) {
        if (xmlObject instanceof Response) {
            return this.validateAudienceRestrictionInResponse((Response)xmlObject);
        }
        if (xmlObject instanceof Assertion) {
            return this.validateAudienceRestrictionInAssertion((Assertion)xmlObject);
        }
        log.error((Object)"Only Response and Assertion objects are validated in this authendicator");
        return false;
    }

    public boolean validateAudienceRestrictionInResponse(Response response) {
        Assertion assertion = this.getAssertionFromResponse(response);
        return this.validateAudienceRestrictionInAssertion(assertion);
    }

    public boolean validateAudienceRestrictionInAssertion(Assertion assertion) {
        if (assertion != null) {
            Conditions conditions = assertion.getConditions();
            if (conditions != null) {
                List audienceRestrictions = conditions.getAudienceRestrictions();
                if (audienceRestrictions != null && !audienceRestrictions.isEmpty()) {
                    for (AudienceRestriction audienceRestriction : audienceRestrictions) {
                        if (audienceRestriction.getAudiences() != null && audienceRestriction.getAudiences().size() > 0) {
                            for (Audience audience : audienceRestriction.getAudiences()) {
                                String spId = Util.getServiceProviderId();
                                if (spId == null) {
                                    Util.initSSOConfigParams();
                                    spId = Util.getServiceProviderId();
                                }
                                if (spId != null) {
                                    if (!spId.equals(audience.getAudienceURI())) continue;
                                    return true;
                                }
                                log.warn((Object)"No SAML2 service provider ID defined.");
                            }
                            continue;
                        }
                        log.warn((Object)"SAML2 Response's AudienceRestriction doesn't contain Audiences");
                    }
                } else {
                    log.error((Object)"SAML2 Response doesn't contain AudienceRestrictions");
                }
            } else {
                log.error((Object)"SAML2 Response doesn't contain Conditions");
            }
        }
        return false;
    }

    private HttpSession getHttpSession() {
        MessageContext msgCtx = MessageContext.getCurrentMessageContext();
        HttpSession httpSession = null;
        if (msgCtx != null) {
            HttpServletRequest request = (HttpServletRequest)msgCtx.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            httpSession = request.getSession();
        }
        return httpSession;
    }

    private void provisionUser(String username, UserRealm realm, XMLObject xmlObject) throws UserStoreException, SAML2SSOAuthenticatorException {
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null) {
            Map configParameters = authenticatorConfig.getParameters();
            boolean isJITProvisioningEnabled = false;
            if (configParameters.containsKey("JITUserProvisioningEnabled")) {
                isJITProvisioningEnabled = Boolean.parseBoolean((String)configParameters.get("JITUserProvisioningEnabled"));
            }
            if (isJITProvisioningEnabled) {
                Object[] newRoles;
                String userstoreDomain = null;
                if (configParameters.containsKey("ProvisioningDefaultUserstore")) {
                    userstoreDomain = (String)configParameters.get("ProvisioningDefaultUserstore");
                }
                UserStoreManager userstore = null;
                if (userstoreDomain != null && !userstoreDomain.isEmpty()) {
                    userstore = realm.getUserStoreManager().getSecondaryUserStoreManager(userstoreDomain);
                }
                if (userstore == null) {
                    userstore = realm.getUserStoreManager();
                }
                if (((newRoles = this.getRoles(xmlObject)) == null || newRoles.length == 0) && configParameters.containsKey("ProvisioningDefaultRole")) {
                    newRoles = new String[]{(String)configParameters.get("ProvisioningDefaultRole")};
                }
                if (newRoles == null) {
                    newRoles = new String[]{};
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("User " + username + " contains roles : " + Arrays.toString(newRoles) + " as per response and (default role) config"));
                }
                ArrayList addingRoles = new ArrayList();
                Collections.addAll(addingRoles, newRoles);
                List<String> allExistingRoles = Arrays.asList(userstore.getRoleNames());
                addingRoles.retainAll(allExistingRoles);
                if (userstore.isExistingUser(username)) {
                    List<String> currentRolesList = Arrays.asList(userstore.getRoleListOfUser(username));
                    addingRoles.removeAll(currentRolesList);
                    ArrayList<String> deletingRoles = new ArrayList<String>();
                    deletingRoles.addAll(currentRolesList);
                    deletingRoles.removeAll(Arrays.asList(newRoles));
                    deletingRoles.remove(realm.getRealmConfiguration().getEveryOneRoleName());
                    if (userstore.getRealmConfiguration().isPrimary() && username.equals(realm.getRealmConfiguration().getAdminUserName())) {
                        boolean isSuperAdminRoleRequired = false;
                        if (configParameters.containsKey("IsSuperAdminRoleRequired")) {
                            isSuperAdminRoleRequired = Boolean.parseBoolean((String)configParameters.get("IsSuperAdminRoleRequired"));
                        }
                        if (!isSuperAdminRoleRequired && deletingRoles.contains(realm.getRealmConfiguration().getAdminRoleName())) {
                            deletingRoles.remove(realm.getRealmConfiguration().getAdminRoleName());
                            log.warn((Object)"Proceeding with allowing super admin to be logged in, eventhough response doesn't include superadmin role assiged for the superadmin user.");
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Deleting roles : " + Arrays.toString(deletingRoles.toArray(new String[0])) + " and Adding roles : " + Arrays.toString(addingRoles.toArray(new String[0]))));
                    }
                    userstore.updateRoleListOfUser(username, deletingRoles.toArray(new String[0]), addingRoles.toArray(new String[0]));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User: " + username + " is updated via SAML authenticator with roles : " + Arrays.toString(newRoles)));
                    }
                } else {
                    userstore.addUser(username, (Object)this.generatePassword(username), addingRoles.toArray(new String[0]), null, null);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User: " + username + " is provisioned via SAML authenticator with roles : " + Arrays.toString(addingRoles.toArray(new String[0]))));
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"User provisioning diabled");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot find authenticator config for authenticator : SAML2SSOAuthenticator");
            }
            throw new SAML2SSOAuthenticatorException("Cannot find authenticator config for authenticator : SAML2SSOAuthenticator");
        }
    }

    private String generatePassword(String username) {
        return new BigInteger(130, this.random).toString(32);
    }

    private String[] getRoles(XMLObject xmlObject) {
        String[] arrRoles = new String[]{};
        if (xmlObject instanceof Response) {
            return this.getRolesFromResponse((Response)xmlObject);
        }
        if (xmlObject instanceof Assertion) {
            return this.getRolesFromAssertion((Assertion)xmlObject);
        }
        return arrRoles;
    }

    private String[] getRolesFromResponse(Response response) {
        List assertions = response.getAssertions();
        Assertion assertion = null;
        if (assertions != null && assertions.size() > 0) {
            assertion = (Assertion)assertions.get(0);
            return this.getRolesFromAssertion(assertion);
        }
        return null;
    }

    private String[] getRolesFromAssertion(Assertion assertion) {
        ArrayList<String> roles = new ArrayList<String>();
        String roleClaim = this.getRoleClaim();
        List attributeStatementList = assertion.getAttributeStatements();
        if (attributeStatementList != null) {
            for (AttributeStatement statement : attributeStatementList) {
                List attributesList = statement.getAttributes();
                for (Attribute attribute : attributesList) {
                    String attributeName = attribute.getName();
                    if (attributeName == null || !roleClaim.equals(attributeName)) continue;
                    List attributeValues = attribute.getAttributeValues();
                    if (attributeValues != null && attributeValues.size() == 1) {
                        String attributeValueString = this.getAttributeValue((XMLObject)attributeValues.get(0));
                        String multiAttributeSeparator = this.getAttributeSeperator();
                        Object[] attributeValuesArray = attributeValueString.split(multiAttributeSeparator);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding attributes for Assertion: " + assertion + " AttributeName : " + attributeName + ", AttributeValue : " + Arrays.toString(attributeValuesArray)));
                        }
                        roles.addAll(Arrays.asList(attributeValuesArray));
                        continue;
                    }
                    if (attributeValues == null || attributeValues.size() <= 1) continue;
                    for (XMLObject attributeValue : attributeValues) {
                        String attributeValueString = this.getAttributeValue(attributeValue);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Adding attributes for Assertion: " + assertion + " AttributeName : " + attributeName + ", AttributeValue : " + attributeValue));
                        }
                        roles.add(attributeValueString);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Role list found for assertion: " + assertion + ", roles: " + roles));
        }
        return roles.toArray(new String[roles.size()]);
    }

    private String getAttributeValue(XMLObject attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        if (attributeValue instanceof XSString) {
            return this.getStringAttributeValue((XSString)attributeValue);
        }
        if (attributeValue instanceof XSAnyImpl) {
            return this.getAnyAttributeValue((XSAnyImpl)attributeValue);
        }
        return attributeValue.toString();
    }

    private String getStringAttributeValue(XSString attributeValue) {
        return attributeValue.getValue();
    }

    private String getAnyAttributeValue(XSAnyImpl attributeValue) {
        return attributeValue.getTextContent();
    }

    private String getRoleClaim() {
        Map configParameters;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (configParameters = authenticatorConfig.getParameters()).containsKey("RoleClaimAttribute")) {
            return (String)configParameters.get("RoleClaimAttribute");
        }
        return "http://wso2.org/claims/role";
    }

    private String getAttributeSeperator() {
        Map configParameters;
        AuthenticatorsConfiguration authenticatorsConfiguration = AuthenticatorsConfiguration.getInstance();
        AuthenticatorsConfiguration.AuthenticatorConfig authenticatorConfig = authenticatorsConfiguration.getAuthenticatorConfig(AUTHENTICATOR_NAME);
        if (authenticatorConfig != null && (configParameters = authenticatorConfig.getParameters()).containsKey("AttributeValueSeparator")) {
            return (String)configParameters.get("AttributeValueSeparator");
        }
        return ",";
    }

    private void validateAssertionValidityPeriod(XMLObject xmlObject) throws SAML2SSOAuthenticatorException {
        Assertion assertion;
        if (xmlObject instanceof Response) {
            assertion = this.getAssertionFromResponse((Response)xmlObject);
        } else if (xmlObject instanceof Assertion) {
            assertion = (Assertion)xmlObject;
        } else {
            throw new SAML2SSOAuthenticatorException("Only Response and Assertion objects are validated in this authenticator");
        }
        if (assertion == null) {
            throw new SAML2SSOAuthenticatorException("Cannot find a SAML Assertion");
        }
        if (assertion.getConditions() != null) {
            DateTime validFrom = assertion.getConditions().getNotBefore();
            DateTime validTill = assertion.getConditions().getNotOnOrAfter();
            int timeStampSkewInSeconds = this.getTimeStampSkewInSeconds();
            if (validFrom != null && validFrom.minusSeconds(timeStampSkewInSeconds).isAfterNow()) {
                throw new SAML2SSOAuthenticatorException("Failed to meet SAML Assertion Condition 'Not Before'");
            }
            if (validTill != null && validTill.plusSeconds(timeStampSkewInSeconds).isBeforeNow()) {
                throw new SAML2SSOAuthenticatorException("Failed to meet SAML Assertion Condition 'Not On Or After'");
            }
            if (validFrom != null && validTill != null && validFrom.isAfter((ReadableInstant)validTill)) {
                throw new SAML2SSOAuthenticatorException("SAML Assertion Condition 'Not Before' must be less than the value of 'Not On Or After'");
            }
        }
    }
}

