/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.jwttransformer;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.wso2.carbon.apimgt.common.gateway.dto.ClaimMappingDto;
import org.wso2.carbon.apimgt.common.gateway.dto.TokenIssuerDto;
import org.wso2.carbon.apimgt.common.gateway.exception.JWTGeneratorException;
import org.wso2.carbon.apimgt.common.gateway.jwttransformer.JWTTransformer;

public class DefaultJWTTransformer
implements JWTTransformer {
    protected TokenIssuerDto tokenIssuer = null;

    @Override
    public String getTransformedConsumerKey(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        try {
            if (this.tokenIssuer.getConsumerKeyClaim() == null) {
                if (jwtClaimsSet.getClaim("consumerKey") != null) {
                    return jwtClaimsSet.getStringClaim("consumerKey");
                }
                if (jwtClaimsSet.getClaim("azp") != null) {
                    return jwtClaimsSet.getStringClaim("azp");
                }
            } else if (jwtClaimsSet.getClaim(this.tokenIssuer.getConsumerKeyClaim()) != null) {
                return jwtClaimsSet.getStringClaim(this.tokenIssuer.getConsumerKeyClaim());
            }
        }
        catch (ParseException e) {
            throw new JWTGeneratorException("Error while parsing JWT claims", e);
        }
        return null;
    }

    @Override
    public List<String> getTransformedScopes(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        try {
            String scopeClaim = "scope";
            if (StringUtils.isNotEmpty((CharSequence)this.tokenIssuer.getScopesClaim())) {
                scopeClaim = this.tokenIssuer.getScopesClaim();
            }
            if (jwtClaimsSet.getClaim(scopeClaim) instanceof String) {
                return Arrays.asList(jwtClaimsSet.getStringClaim(scopeClaim).split(" "));
            }
            if (jwtClaimsSet.getClaim(scopeClaim) instanceof List) {
                return jwtClaimsSet.getStringListClaim(scopeClaim);
            }
        }
        catch (ParseException e) {
            throw new JWTGeneratorException("Error while parsing JWT claims", e);
        }
        return Arrays.asList("default");
    }

    @Override
    public JWTClaimsSet transform(JWTClaimsSet jwtClaimsSet) {
        JWTClaimsSet.Builder transformedJWT = new JWTClaimsSet.Builder();
        if (this.tokenIssuer != null) {
            Map<String, ClaimMappingDto> claimConfigurations = this.tokenIssuer.getClaimConfigurations();
            for (Map.Entry claimEntry : jwtClaimsSet.getClaims().entrySet()) {
                ClaimMappingDto claimMappingDto = claimConfigurations.get(claimEntry.getKey());
                String claimKey = (String)claimEntry.getKey();
                if (claimMappingDto != null) {
                    claimKey = claimMappingDto.getLocalClaim();
                }
                transformedJWT.claim(claimKey, claimEntry.getValue());
            }
            return transformedJWT.build();
        }
        return jwtClaimsSet;
    }

    @Override
    public String getIssuer() {
        return "";
    }

    @Override
    public void loadConfiguration(TokenIssuerDto tokenIssuerConfiguration) {
        this.tokenIssuer = tokenIssuerConfiguration;
    }

    @Override
    public Boolean getTransformedIsAppTokenType(JWTClaimsSet jwtClaimsSet) throws JWTGeneratorException {
        try {
            if (jwtClaimsSet.getClaim("aut") != null) {
                String aut = jwtClaimsSet.getStringClaim("aut");
                return StringUtils.equalsIgnoreCase((CharSequence)aut, (CharSequence)"application");
            }
        }
        catch (ParseException e) {
            throw new JWTGeneratorException("Error while parsing JWT claims", e);
        }
        return false;
    }
}

