/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.common.gateway.dto;

import java.util.HashMap;
import java.util.Map;
import javax.security.cert.Certificate;
import org.wso2.carbon.apimgt.common.gateway.dto.ClaimMappingDto;
import org.wso2.carbon.apimgt.common.gateway.dto.JWKSConfigurationDTO;

public class TokenIssuerDto {
    private String issuer;
    private boolean disableDefaultClaimMapping = false;
    private Map<String, ClaimMappingDto> claimConfigurations = new HashMap<String, ClaimMappingDto>();
    private JWKSConfigurationDTO jwksConfigurationDTO = new JWKSConfigurationDTO();
    private Certificate certificate;
    private String consumerKeyClaim;
    private String scopesClaim;

    public TokenIssuerDto(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Map<String, ClaimMappingDto> getClaimConfigurations() {
        return this.claimConfigurations;
    }

    public void addClaimMapping(ClaimMappingDto claimMappingDto) {
        this.claimConfigurations.put(claimMappingDto.getRemoteClaim(), claimMappingDto);
    }

    public JWKSConfigurationDTO getJwksConfigurationDTO() {
        return this.jwksConfigurationDTO;
    }

    public boolean isDisableDefaultClaimMapping() {
        return this.disableDefaultClaimMapping;
    }

    public void setDisableDefaultClaimMapping(boolean disableDefaultClaimMapping) {
        this.disableDefaultClaimMapping = disableDefaultClaimMapping;
    }

    public void setJwksConfigurationDTO(JWKSConfigurationDTO jwksConfigurationDTO) {
        this.jwksConfigurationDTO = jwksConfigurationDTO;
    }

    public String getConsumerKeyClaim() {
        return this.consumerKeyClaim;
    }

    public void setConsumerKeyClaim(String consumerKeyClaim) {
        this.consumerKeyClaim = consumerKeyClaim;
    }

    public String getScopesClaim() {
        return this.scopesClaim;
    }

    public void setScopesClaim(String scopesClaim) {
        this.scopesClaim = scopesClaim;
    }

    public void addClaimMappings(ClaimMappingDto[] claimMappingDto) {
        for (ClaimMappingDto mappingDto : claimMappingDto) {
            this.addClaimMapping(mappingDto);
        }
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }
}

