/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.ws.internal.builders.utils;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPFaultCode;
import org.apache.axiom.soap.SOAPFaultDetail;
import org.apache.axiom.soap.SOAPFaultReason;
import org.apache.axiom.soap.SOAPFaultSubCode;
import org.apache.axiom.soap.SOAPFaultText;
import org.apache.axiom.soap.SOAPFaultValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.event.ws.internal.builders.exceptions.BuilderException;
import org.wso2.carbon.event.ws.internal.builders.exceptions.InvalidMessageException;

@Deprecated
public class BuilderUtils {
    private static final Log log = LogFactory.getLog(BuilderUtils.class);

    public static String getEndpointFromWSAAddress(OMElement address) {
        if (address == null || address.getText() == null) {
            log.error((Object)"Invalid WSA Address");
            throw new BuilderException("Invalid WSA Address");
        }
        return address.getText().trim();
    }

    public static SOAPEnvelope genFaultResponse(String code, String subCode, String reason, String detail, boolean isSOAP11) {
        if (isSOAP11) {
            SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
            SOAPEnvelope message = soapFactory.getDefaultFaultEnvelope();
            SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
            soapFaultReason.setText(reason);
            message.getBody().getFault().setReason(soapFaultReason);
            SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
            QName qNameSubCode = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", subCode, "wse");
            soapFaultCode.setText(qNameSubCode);
            message.getBody().getFault().setCode(soapFaultCode);
            return message;
        }
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope message = soapFactory.getDefaultFaultEnvelope();
        SOAPFaultDetail soapFaultDetail = soapFactory.createSOAPFaultDetail();
        soapFaultDetail.setText(detail);
        message.getBody().getFault().setDetail(soapFaultDetail);
        SOAPFaultReason soapFaultReason = soapFactory.createSOAPFaultReason();
        SOAPFaultText soapFaultText = soapFactory.createSOAPFaultText();
        soapFaultText.setText(reason);
        soapFaultReason.addSOAPText(soapFaultText);
        message.getBody().getFault().setReason(soapFaultReason);
        SOAPFaultCode soapFaultCode = soapFactory.createSOAPFaultCode();
        SOAPFaultValue soapFaultValue = soapFactory.createSOAPFaultValue(soapFaultCode);
        soapFaultValue.setText(code);
        soapFaultCode.setValue(soapFaultValue);
        SOAPFaultSubCode soapFaultSubCode = soapFactory.createSOAPFaultSubCode(soapFaultCode);
        SOAPFaultValue soapFaultValueSub = soapFactory.createSOAPFaultValue(soapFaultSubCode);
        QName qNameSubCode = new QName("http://schemas.xmlsoap.org/ws/2004/08/eventing", subCode, "wse");
        soapFaultValueSub.setText(qNameSubCode);
        soapFaultSubCode.setValue(soapFaultValueSub);
        soapFaultCode.setSubCode(soapFaultSubCode);
        message.getBody().getFault().setCode(soapFaultCode);
        return message;
    }

    public static Subscription createSubscription(String endpoint, String filterDialect, String topic) throws InvalidMessageException {
        Subscription subscription = new Subscription();
        if (endpoint == null) {
            throw new InvalidMessageException("Endpoint not found in the subscription request");
        }
        subscription.setEventSinkURL(endpoint);
        if (topic == null) {
            throw new InvalidMessageException("Error in creating subscription. Topic not defined");
        }
        subscription.setTopicName(topic);
        return subscription;
    }
}

