/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.commons.rest.api.swagger;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.api.API;
import org.apache.synapse.api.Resource;
import org.apache.synapse.api.dispatch.DispatcherHelper;
import org.apache.synapse.api.dispatch.URLMappingBasedDispatcher;
import org.wso2.carbon.mediation.commons.rest.api.swagger.SwaggerConstants;

public class GenericApiObjectDefinition {
    private static final Log log = LogFactory.getLog(GenericApiObjectDefinition.class);

    private static Map<String, Object> getResponsesMap() {
        LinkedHashMap<String, Object> responsesMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, String> responseDetailsMap = new LinkedHashMap<String, String>();
        responseDetailsMap.put("description", "Default Response");
        responsesMap.put("default", responseDetailsMap);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response map created with size " + responsesMap.size()));
        }
        return responsesMap;
    }

    public static Map<String, Object> getPathMap(API api) {
        LinkedHashMap<String, Object> pathsMap = new LinkedHashMap<String, Object>();
        for (Resource resource : api.getResources()) {
            DispatcherHelper resourceDispatcherHelper = resource.getDispatcherHelper();
            LinkedHashMap methodMap = (LinkedHashMap)pathsMap.get(GenericApiObjectDefinition.getPathFromUrl(GenericApiObjectDefinition.getUri(resourceDispatcherHelper)));
            if (methodMap == null) {
                methodMap = new LinkedHashMap();
            }
            for (String method : resource.getMethods()) {
                Object[] parameters;
                if (method == null) continue;
                LinkedHashMap<String, Object> methodInfoMap = new LinkedHashMap<String, Object>();
                methodInfoMap.put("responses", GenericApiObjectDefinition.getResponsesMap());
                if (resourceDispatcherHelper != null && (parameters = GenericApiObjectDefinition.getResourceParameters(resource, method)).length > 0) {
                    methodInfoMap.put("parameters", parameters);
                }
                methodMap.put(method.toLowerCase(), methodInfoMap);
            }
            pathsMap.put(GenericApiObjectDefinition.getPathFromUrl(GenericApiObjectDefinition.getUri(resourceDispatcherHelper)), methodMap);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Paths map created with size " + pathsMap.size()));
        }
        return pathsMap;
    }

    private static String getUri(DispatcherHelper resourceDispatcherHelper) {
        return resourceDispatcherHelper == null ? "/" : resourceDispatcherHelper.getString();
    }

    private static Object[] getResourceParameters(Resource resource, String method) {
        ArrayList<Map<String, Object>> parameterList = new ArrayList<Map<String, Object>>();
        String uri = resource.getDispatcherHelper().getString();
        if (resource.getDispatcherHelper() instanceof URLMappingBasedDispatcher) {
            GenericApiObjectDefinition.generateParameterList(parameterList, uri, false);
        } else {
            GenericApiObjectDefinition.generateParameterList(parameterList, uri, true);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Parameters processed for the URI + " + uri + " size " + parameterList.size()));
        }
        GenericApiObjectDefinition.generateBodyParameter(parameterList, resource, method);
        return parameterList.toArray();
    }

    private static void generateParameterList(ArrayList<Map<String, Object>> parameterList, String uriString, boolean generateBothTypes) {
        if (uriString == null) {
            return;
        }
        if (generateBothTypes) {
            String[] params;
            for (String parameter : params = GenericApiObjectDefinition.getQueryStringFromUrl(uriString).split("&")) {
                int pos;
                if (parameter == null || (pos = parameter.indexOf(61)) <= 0) continue;
                parameterList.add(GenericApiObjectDefinition.getParametersMap(parameter.substring(0, pos), "query"));
            }
        }
        Matcher matcher = SwaggerConstants.PATH_PARAMETER_PATTERN.matcher(GenericApiObjectDefinition.getPathFromUrl(uriString));
        while (matcher.find()) {
            parameterList.add(GenericApiObjectDefinition.getParametersMap(matcher.group(1), "path"));
        }
    }

    private static void generateBodyParameter(ArrayList<Map<String, Object>> parameterList, Resource resource, String method) {
        if (method.equalsIgnoreCase("post") || method.equalsIgnoreCase("put") || method.equalsIgnoreCase("patch")) {
            parameterList.add(GenericApiObjectDefinition.getParametersMap("payload", "body", "Sample Payload", false));
        }
    }

    private static Map<String, Object> getParametersMap(String parameterName, String parameterType) {
        return GenericApiObjectDefinition.getParametersMap(parameterName, parameterType, parameterName, true);
    }

    private static Map<String, Object> getParametersMap(String parameterName, String parameterType, String description, boolean required) {
        LinkedHashMap<String, Object> parameterMap = new LinkedHashMap<String, Object>();
        parameterMap.put("description", description);
        parameterMap.put("in", parameterType);
        parameterMap.put("name", parameterName);
        parameterMap.put("required", required);
        if (parameterType.equals("body")) {
            LinkedHashMap<String, Object> schemaMap = new LinkedHashMap<String, Object>();
            LinkedHashMap schemaPropertiesMap = new LinkedHashMap();
            LinkedHashMap<String, String> schemaPropertiesTypeMap = new LinkedHashMap<String, String>();
            schemaPropertiesTypeMap.put("type", "string");
            schemaPropertiesMap.put("payload", schemaPropertiesTypeMap);
            schemaMap.put("type", "object");
            schemaMap.put("properties", schemaPropertiesMap);
            parameterMap.put("schema", schemaMap);
        } else {
            parameterMap.put("type", "string");
        }
        return parameterMap;
    }

    private static String getPathFromUrl(String uri) {
        int pos = uri.indexOf("?");
        if (pos > 0) {
            return uri.substring(0, pos);
        }
        return uri;
    }

    private static String getQueryStringFromUrl(String uri) {
        int pos = uri.indexOf("?");
        if (pos > 0) {
            return uri.substring(pos + 1);
        }
        return "";
    }

    public static String convertYamlToJson(String yaml) throws JsonProcessingException {
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object obj = yamlReader.readValue(yaml, Object.class);
        ObjectMapper jsonWriter = new ObjectMapper();
        return jsonWriter.writeValueAsString(obj);
    }
}

