/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import org.apache.commons.lang.StringUtils;
import org.apache.xerces.util.SecurityManager;
import org.apache.xml.security.Init;
import org.apache.xml.security.utils.Base64;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallerFactory;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallerFactory;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.saml2.core.ArtifactResolve;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.X509Certificate;
import org.opensaml.xmlsec.signature.X509Data;
import org.opensaml.xmlsec.signature.support.Signer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.wso2.carbon.identity.saml.common.util.SAMLInitializer;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.xml.sax.SAXException;

public class SSOAgentUtils {
    private static Logger LOGGER = Logger.getLogger("org.wso2.carbon.identity.sso.agent");
    private static boolean isBootStrapped = false;
    private static Random random = new Random();
    private static final int ENTITY_EXPANSION_LIMIT = 0;

    private SSOAgentUtils() {
    }

    public static String createID() {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] charMapping = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        char[] chars = new char[40];
        for (int i = 0; i < bytes.length; ++i) {
            int left = bytes[i] >> 4 & 0xF;
            int right = bytes[i] & 0xF;
            chars[i * 2] = charMapping[left];
            chars[i * 2 + 1] = charMapping[right];
        }
        return String.valueOf(chars);
    }

    public static void doBootstrap() throws SSOAgentException {
        if (!isBootStrapped) {
            try {
                SAMLInitializer.doBootstrap();
                isBootStrapped = true;
            }
            catch (InitializationException e) {
                throw new SSOAgentException("Error in bootstrapping the OpenSAML3 library", e);
            }
        }
    }

    public static AuthnRequest setSignature(AuthnRequest authnRequest, String signatureAlgorithm, X509Credential cred) throws SSOAgentException {
        SSOAgentUtils.doBootstrap();
        return SSOAgentUtils.setSignatureValue(authnRequest, signatureAlgorithm, cred);
    }

    public static LogoutRequest setSignature(LogoutRequest logoutRequest, String signatureAlgorithm, X509Credential cred) throws SSOAgentException {
        return SSOAgentUtils.setSignatureValue(logoutRequest, signatureAlgorithm, cred);
    }

    public static ArtifactResolve setSignature(ArtifactResolve artifactResolve, String signatureAlgorithm, X509Credential cred) throws SSOAgentException {
        return SSOAgentUtils.setSignatureValue(artifactResolve, signatureAlgorithm, cred);
    }

    public static <T extends SignableXMLObject> T setSignatureValue(T xmlObject, String signatureAlgorithm, X509Credential cred) throws SSOAgentException {
        try {
            Signature signature = SSOAgentUtils.setSignatureRaw(signatureAlgorithm, cred);
            xmlObject.setSignature(signature);
            ArrayList<Signature> signatureList = new ArrayList<Signature>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            marshaller.marshall(xmlObject);
            Init.init();
            Signer.signObjects(signatureList);
            return xmlObject;
        }
        catch (Exception e) {
            throw new SSOAgentException("Error while signing the SAML Request message", e);
        }
    }

    private static Signature setSignatureRaw(String signatureAlgorithm, X509Credential cred) throws SSOAgentException {
        Signature signature = (Signature)SSOAgentUtils.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)cred);
        signature.setSignatureAlgorithm(signatureAlgorithm);
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            KeyInfo keyInfo = (KeyInfo)SSOAgentUtils.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data data = (X509Data)SSOAgentUtils.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)SSOAgentUtils.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encode((byte[])cred.getEntityCertificate().getEncoded());
            cert.setValue(value);
            data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(data);
            signature.setKeyInfo(keyInfo);
            return signature;
        }
        catch (CertificateEncodingException e) {
            throw new SSOAgentException("Error getting certificate", e);
        }
    }

    public static void addDeflateSignatureToHTTPQueryString(StringBuilder httpQueryString, X509Credential cred) throws SSOAgentException {
        SSOAgentUtils.doBootstrap();
        try {
            httpQueryString.append("&SigAlg=" + URLEncoder.encode("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "UTF-8").trim());
            java.security.Signature signature = java.security.Signature.getInstance("SHA1withRSA");
            signature.initSign(cred.getPrivateKey());
            signature.update(httpQueryString.toString().getBytes(Charset.forName("UTF-8")));
            byte[] signatureByteArray = signature.sign();
            String signatureBase64encodedString = Base64Support.encode((byte[])signatureByteArray, (boolean)false);
            httpQueryString.append("&Signature=" + URLEncoder.encode(signatureBase64encodedString, "UTF-8").trim());
        }
        catch (Exception e) {
            throw new SSOAgentException("Error applying SAML2 Redirect Binding signature", e);
        }
    }

    private static XMLObject buildXMLObject(QName objectQName) throws SSOAgentException {
        SSOAgentUtils.doBootstrap();
        XMLObjectBuilder builder = XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilder(objectQName);
        if (builder == null) {
            throw new SSOAgentException("Unable to retrieve builder for object QName " + objectQName);
        }
        return builder.buildObject(objectQName.getNamespaceURI(), objectQName.getLocalPart(), objectQName.getPrefix());
    }

    public static void sendPostResponse(HttpServletRequest request, HttpServletResponse response, String htmlPayload) throws SSOAgentException {
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            ((Writer)writer).write(htmlPayload);
            response.flushBuffer();
        }
        catch (IOException e) {
            throw new SSOAgentException("Error occurred while writing to HttpServletResponse", e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error occurred while closing Writer", e);
                }
            }
        }
    }

    public static String marshall(XMLObject xmlObject) throws SSOAgentException {
        try {
            MarshallerFactory marshallerFactory = XMLObjectProviderRegistrySupport.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            ByteArrayOutputStream byteArrayOutputStrm = new ByteArrayOutputStream();
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            LSOutput output = impl.createLSOutput();
            output.setByteStream(byteArrayOutputStrm);
            writer.write(element, output);
            return byteArrayOutputStrm.toString();
        }
        catch (Exception e) {
            throw new SSOAgentException("Error Serializing the SAML Response", e);
        }
    }

    public static XMLObject unmarshall(String saml2SSOString) throws SSOAgentException {
        SSOAgentUtils.doBootstrap();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            LOGGER.log(Level.SEVERE, "Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd or secure-processing.");
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        documentBuilderFactory.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        try {
            documentBuilderFactory.setIgnoringComments(true);
            Document document = SSOAgentUtils.getDocument(documentBuilderFactory, saml2SSOString);
            if (SSOAgentUtils.isSignedWithComments(document)) {
                documentBuilderFactory.setIgnoringComments(false);
                document = SSOAgentUtils.getDocument(documentBuilderFactory, saml2SSOString);
            }
            Element element = document.getDocumentElement();
            UnmarshallerFactory unmarshallerFactory = XMLObjectProviderRegistrySupport.getUnmarshallerFactory();
            Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(element);
            return unmarshaller.unmarshall(element);
        }
        catch (ParserConfigurationException e) {
            throw new SSOAgentException("Error in unmarshalling SAML2SSO Request from the encoded String", e);
        }
        catch (UnmarshallingException e) {
            throw new SSOAgentException("Error in unmarshalling SAML2SSO Request from the encoded String", e);
        }
        catch (SAXException e) {
            throw new SSOAgentException("Error in unmarshalling SAML2SSO Request from the encoded String", e);
        }
        catch (IOException e) {
            throw new SSOAgentException("Error in unmarshalling SAML2SSO Request from the encoded String", e);
        }
    }

    private static boolean isSignedWithComments(Document document) {
        XPath xPath = XPathFactory.newInstance().newXPath();
        try {
            String assertionId = (String)xPath.compile("//*[local-name()='Assertion']/@ID").evaluate(document, XPathConstants.STRING);
            if (StringUtils.isBlank((String)assertionId)) {
                return false;
            }
            NodeList nodeList = (NodeList)xPath.compile("//*[local-name()='Assertion']/*[local-name()='Signature']/*[local-name()='SignedInfo']/*[local-name()='Reference'][@URI='#" + assertionId + "']/*[local-name()='Transforms']/*[local-name()='Transform'][@Algorithm='http://www.w3.org/2001/10/xml-exc-c14n#WithComments']").evaluate(document, XPathConstants.NODESET);
            return nodeList != null && nodeList.getLength() > 0;
        }
        catch (XPathExpressionException e) {
            String message = "Failed to find the canonicalization algorithm of the assertion. Defaulting to: http://www.w3.org/2001/10/xml-exc-c14n#";
            LOGGER.log(Level.WARNING, message);
            return false;
        }
    }

    private static Document getDocument(DocumentBuilderFactory documentBuilderFactory, String samlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(samlString.getBytes());
        return docBuilder.parse(inputStream);
    }
}

