/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.util;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.wso2.carbon.identity.sso.agent.bean.LoggedInSessionBean;
import org.wso2.carbon.identity.sso.agent.bean.SSOAgentConfig;

public class SSOAgentRequestResolver {
    SSOAgentConfig ssoAgentConfig = null;
    HttpServletRequest request = null;

    public SSOAgentRequestResolver(HttpServletRequest request, HttpServletResponse response, SSOAgentConfig ssoAgentConfig) {
        this.request = request;
        this.ssoAgentConfig = ssoAgentConfig;
    }

    public boolean isSLORequest() {
        return this.ssoAgentConfig.isSAML2SSOLoginEnabled() != false && this.request.getParameter("SAMLRequest") != null;
    }

    public boolean isSAML2SSOResponse() {
        return this.ssoAgentConfig.isSAML2SSOLoginEnabled() != false && this.request.getParameter("SAMLResponse") != null;
    }

    public boolean isSAML2ArtifactResponse() {
        return this.ssoAgentConfig.isSAML2SSOLoginEnabled() != false && this.request.getParameter("SAMLart") != null;
    }

    public boolean isOpenIdLoginResponse() {
        return this.ssoAgentConfig.isOpenIdLoginEnabled() != false && this.ssoAgentConfig.getOpenId().getMode() != null && !this.ssoAgentConfig.getOpenId().getMode().trim().isEmpty();
    }

    public boolean isSLOURL() {
        return this.ssoAgentConfig.isSAML2SSOLoginEnabled() != false && this.ssoAgentConfig.getSAML2().isSLOEnabled() != false && this.request.getRequestURI().endsWith(this.ssoAgentConfig.getSAML2().getSLOURL());
    }

    public boolean isHttpPostBinding() {
        return this.ssoAgentConfig.getSAML2().getHttpBinding() != null && "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST".equals(this.ssoAgentConfig.getSAML2().getHttpBinding());
    }

    public boolean isSAML2SSOURL() {
        return this.ssoAgentConfig.isSAML2SSOLoginEnabled() != false && this.request.getRequestURI().endsWith(this.ssoAgentConfig.getSAML2SSOURL());
    }

    public boolean isOpenIdURL() {
        return this.ssoAgentConfig.isOpenIdLoginEnabled() != false && this.request.getRequestURI().endsWith(this.ssoAgentConfig.getOpenIdURL()) && this.ssoAgentConfig.getOpenId().getClaimedId() != null && !this.ssoAgentConfig.getOpenId().getClaimedId().trim().isEmpty();
    }

    public boolean isPassiveAuthnRequest() {
        return !(this.ssoAgentConfig.isSAML2SSOLoginEnabled() == false && this.ssoAgentConfig.isOpenIdLoginEnabled() == false || this.request.getSession(false) != null && this.request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean") != null);
    }

    public boolean isSAML2OAuth2GrantRequest() {
        return this.ssoAgentConfig.isSAML2SSOLoginEnabled() != false && this.ssoAgentConfig.isOAuth2SAML2GrantEnabled() != false && this.request.getRequestURI().endsWith(this.ssoAgentConfig.getOAuth2SAML2GrantURL()) && this.request.getSession(false) != null && this.request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean") != null && ((LoggedInSessionBean)this.request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO() != null && ((LoggedInSessionBean)this.request.getSession(false).getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO().getAssertion() != null;
    }

    public boolean isURLToSkip() {
        return this.ssoAgentConfig.getSkipURIs().contains(this.request.getRequestURI());
    }
}

