/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.session.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import org.wso2.carbon.identity.sso.agent.bean.LoggedInSessionBean;

public class SSOAgentSessionManager {
    private static Map<String, Set<HttpSession>> ssoSessionsMap = new HashMap<String, Set<HttpSession>>();

    private SSOAgentSessionManager() {
    }

    public static void invalidateSession(HttpSession session) {
        Set<HttpSession> sessions;
        String sessionIndex;
        LoggedInSessionBean sessionBean = (LoggedInSessionBean)session.getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
        if (sessionBean != null && sessionBean.getSAML2SSO() != null && (sessionIndex = sessionBean.getSAML2SSO().getSessionIndex()) != null && (sessions = ssoSessionsMap.get(sessionIndex)) != null) {
            sessions.remove(session);
        }
    }

    public static Set<HttpSession> invalidateAllSessions(HttpSession session) {
        String sessionIndex;
        LoggedInSessionBean sessionBean = (LoggedInSessionBean)session.getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean");
        Set<Object> sessions = new HashSet<HttpSession>();
        if (sessionBean != null && sessionBean.getSAML2SSO() != null && (sessionIndex = sessionBean.getSAML2SSO().getSessionIndex()) != null) {
            sessions = ssoSessionsMap.remove(sessionIndex);
        }
        if (sessions == null) {
            sessions = new HashSet();
        }
        return sessions;
    }

    public static Set<HttpSession> invalidateAllSessions(String sessionIndex) {
        Set<HttpSession> sessions = ssoSessionsMap.remove(sessionIndex);
        if (sessions == null) {
            sessions = new HashSet<HttpSession>();
        }
        return sessions;
    }

    public static void addAuthenticatedSession(HttpSession session) {
        String sessionIndex = ((LoggedInSessionBean)session.getAttribute("org.wso2.carbon.identity.sso.agent.LoggedInSessionBean")).getSAML2SSO().getSessionIndex();
        if (ssoSessionsMap.get(sessionIndex) != null) {
            ssoSessionsMap.get(sessionIndex).add(session);
        } else {
            HashSet<HttpSession> sessions = new HashSet<HttpSession>();
            sessions.add(session);
            ssoSessionsMap.put(sessionIndex, sessions);
        }
    }
}

