/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.sso.agent.security;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.sso.agent.exception.SSOAgentException;
import org.wso2.carbon.identity.sso.agent.security.SSOAgentX509Credential;

public class SSOAgentCarbonX509Credential
implements SSOAgentX509Credential {
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private X509Certificate entityCertificate = null;

    public SSOAgentCarbonX509Credential(int tenantId, String tenantDomain) throws SSOAgentException {
        this.readCarbonX509Credentials(tenantId, tenantDomain);
    }

    @Override
    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public X509Certificate getEntityCertificate() {
        return this.entityCertificate;
    }

    protected void readCarbonX509Credentials(int tenantId, String tenantDomain) throws SSOAgentException {
        KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
        if (!tenantDomain.equals("carbon.super")) {
            String ksName = tenantDomain.trim().replace(".", "-");
            String jksName = ksName + ".jks";
            KeyStore keyStore = null;
            try {
                keyStore = tenantKSM.getKeyStore(jksName);
            }
            catch (Exception e) {
                throw new SSOAgentException("Error occurred while retrieving key store of tenant " + tenantDomain, e);
            }
            try {
                this.entityCertificate = (X509Certificate)keyStore.getCertificate(tenantDomain);
            }
            catch (KeyStoreException e) {
                throw new SSOAgentException("Error occurred while retrieving public certificate with alias " + tenantDomain + " of tenant " + tenantDomain, e);
            }
            this.privateKey = (PrivateKey)tenantKSM.getPrivateKey(jksName, tenantDomain);
        } else {
            try {
                this.entityCertificate = tenantKSM.getDefaultPrimaryCertificate();
            }
            catch (Exception e) {
                throw new SSOAgentException("Error retrieving default primary certificate of carbon.super", e);
            }
            try {
                this.privateKey = tenantKSM.getDefaultPrivateKey();
            }
            catch (Exception e) {
                throw new SSOAgentException("Error retrieving default private key of carbon.super", e);
            }
        }
        this.publicKey = this.entityCertificate.getPublicKey();
    }
}

